/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.FallThroughStyle;
import org.openrewrite.java.cleanup.FallThroughVisitor;
import org.openrewrite.java.tree.J;

public class FallThrough
extends Recipe {
    public String getDisplayName() {
        return "Fall through";
    }

    public String getDescription() {
        return "Checks for fall-through in switch statements, adding `break` statements in locations where a case contains Java code but does not have a `break`, `return`, `throw`, or `continue` statement.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new FallThroughFromCompilationUnitStyle();
    }

    private static class FallThroughFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private FallThroughFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            FallThroughStyle style = (FallThroughStyle)cu.getStyle(FallThroughStyle.class);
            if (style == null) {
                style = FallThroughStyle.fallThroughStyle();
            }
            this.doAfterVisit(new FallThroughVisitor(style));
            return cu;
        }
    }
}

