/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.internal.FormatFirstClassPrefix;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class AddImport<P>
extends JavaIsoVisitor<P> {
    private final String type;
    @Nullable
    private final String statik;
    private final boolean onlyIfReferenced;
    private final JavaType.Class classType;

    public AddImport(String type, @Nullable String statik, boolean onlyIfReferenced) {
        this.type = type;
        this.classType = JavaType.Class.build(type);
        this.statik = statik;
        this.onlyIfReferenced = onlyIfReferenced;
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        if (JavaType.Primitive.fromKeyword(this.classType.getFullyQualifiedName()) != null) {
            return cu;
        }
        if (this.onlyIfReferenced && !this.hasReference(cu)) {
            return cu;
        }
        if (this.classType.getPackageName().isEmpty()) {
            return cu;
        }
        if (cu.getImports().stream().anyMatch(i -> {
            String ending = i.getQualid().getSimpleName();
            if (this.statik == null) {
                return !i.isStatic() && i.getPackageName().equals(this.classType.getPackageName()) && (ending.equals(this.classType.getClassName()) || ending.equals("*"));
            }
            return i.isStatic() && i.getTypeName().equals(this.classType.getFullyQualifiedName()) && (ending.equals(this.statik) || ending.equals("*"));
        })) {
            return cu;
        }
        J.Import importToAdd = new J.Import(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JLeftPadded<Boolean>(this.statik == null ? Space.EMPTY : Space.format(" "), this.statik != null, Markers.EMPTY), (J.FieldAccess)TypeTree.build(this.classType.getFullyQualifiedName() + (this.statik == null ? "" : "." + this.statik)).withPrefix(Space.format(" ")));
        ArrayList<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>(cu.getPadding().getImports());
        if (imports.isEmpty()) {
            importToAdd = cu.getPackageDeclaration() == null ? importToAdd.withPrefix(cu.getClasses().get(0).getPrefix()) : importToAdd.withPrefix(Space.format("\n\n"));
        }
        imports.add(new JRightPadded<J.Import>(importToAdd, Space.EMPTY, Markers.EMPTY));
        cu = cu.getPadding().withImports(imports);
        this.doAfterVisit(new OrderImports.OrderImportsVisitor(false));
        this.doAfterVisit(new FormatFirstClassPrefix());
        return cu;
    }

    private boolean isTypeReference(NameTree t) {
        boolean isTypRef = true;
        if (t instanceof J.FieldAccess) {
            isTypRef = TypeUtils.isOfClassType(((J.FieldAccess)t).getTarget().getType(), this.type);
        }
        return isTypRef;
    }

    private boolean hasReference(J.CompilationUnit compilationUnit) {
        if (this.statik == null) {
            for (NameTree t : FindTypes.find(compilationUnit, this.type)) {
                if (t instanceof J.FieldAccess && ((J.FieldAccess)t).isFullyQualifiedClassReference(this.type) || !this.isTypeReference(t)) continue;
                return true;
            }
            return false;
        }
        for (J invocation : FindMethods.find(compilationUnit, this.type + " *(..)")) {
            J.MethodInvocation mi;
            if (!(invocation instanceof J.MethodInvocation) || (mi = (J.MethodInvocation)invocation).getSelect() != null || !this.statik.equals("*") && !mi.getName().getSimpleName().equals(this.statik)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddImport)) {
            return false;
        }
        AddImport other = (AddImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.onlyIfReferenced != other.onlyIfReferenced) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$statik = this.statik;
        String other$statik = other.statik;
        return !(this$statik == null ? other$statik != null : !this$statik.equals(other$statik));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.onlyIfReferenced ? 79 : 97);
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $statik = this.statik;
        result = result * 59 + ($statik == null ? 43 : $statik.hashCode());
        return result;
    }
}

