/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.List;
import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

class TabsAndIndentsVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final TabsAndIndentsStyle style;
    private final String spacesForTab;

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style) {
        this(style, null);
    }

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < style.getTabSize(); ++i) {
            s.append(' ');
        }
        this.spacesForTab = s.toString();
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p, Cursor parent) {
        this.setCursor(parent);
        for (Cursor c = parent; c != null; c = c.getParent()) {
            int indent;
            Object v = c.getValue();
            Space space = null;
            if (v instanceof J) {
                space = ((J)v).getPrefix();
            } else if (v instanceof JRightPadded) {
                space = ((JRightPadded)v).getAfter();
            } else if (v instanceof JLeftPadded) {
                space = ((JLeftPadded)v).getBefore();
            } else if (v instanceof JContainer) {
                space = ((JContainer)v).getBefore();
            }
            if (space == null || !space.getLastWhitespace().contains("\n") || (indent = this.findIndent(space)) == 0) continue;
            c.putMessage("lastIndent", (Object)indent);
        }
        this.preVisit((J)parent.getPath(J.class::isInstance).next(), p);
        return this.visit(tree, (Object)p);
    }

    @Nullable
    public J preVisit(J tree, P p) {
        if (tree instanceof J.CompilationUnit || tree instanceof J.Package || tree instanceof J.Import || tree instanceof J.Label || tree instanceof J.DoWhileLoop || tree instanceof J.ArrayDimension || tree instanceof J.ClassDeclaration) {
            this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
        } else if (tree instanceof J.Block || tree instanceof J.If || tree instanceof J.If.Else || tree instanceof J.ForLoop || tree instanceof J.ForEachLoop || tree instanceof J.WhileLoop || tree instanceof J.Case || tree instanceof J.EnumValueSet) {
            this.getCursor().putMessage("indentType", (Object)IndentType.INDENT);
        } else {
            this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
        }
        return (J)super.preVisit((Tree)tree, p);
    }

    @Override
    public J visitForControl(J.ForLoop.Control control, P p) {
        return control;
    }

    @Override
    public J visitForEachControl(J.ForEachLoop.Control control, P p) {
        return control;
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        boolean alignBlockToParent;
        boolean alignToAnnotation = false;
        Cursor parent = this.getCursor().getParent();
        if (parent != null && parent.getValue() instanceof J.Annotation) {
            parent.getParentOrThrow().putMessage("afterAnnotation", (Object)true);
        } else if (parent != null) {
            if (!this.getCursor().getParentOrThrow().getPath(J.Annotation.class::isInstance).hasNext()) {
                boolean bl = alignToAnnotation = this.getCursor().pollNearestMessage("afterAnnotation") != null && !(this.getCursor().getParentOrThrow().getValue() instanceof J.Annotation);
            }
        }
        if (!space.getLastWhitespace().contains("\n") || parent == null) {
            return space;
        }
        int indent = Optional.ofNullable((Integer)this.getCursor().getNearestMessage("lastIndent")).orElse(0);
        IndentType indentType = Optional.ofNullable((IndentType)((Object)this.getCursor().getParentOrThrow().getNearestMessage("indentType"))).orElse(IndentType.ALIGN);
        boolean bl = alignBlockToParent = loc.equals((Object)Space.Location.BLOCK_END) || loc.equals((Object)Space.Location.NEW_ARRAY_INITIALIZER_SUFFIX) || loc.equals((Object)Space.Location.ELSE_PREFIX);
        if (alignBlockToParent || alignToAnnotation) {
            indentType = IndentType.ALIGN;
        }
        switch (indentType) {
            case ALIGN: {
                break;
            }
            case INDENT: {
                indent += this.style.getIndentSize().intValue();
                break;
            }
            case CONTINUATION_INDENT: {
                indent += this.style.getContinuationIndent().intValue();
            }
        }
        Space s = this.indentTo(space, indent);
        if (!(this.getCursor().getValue() instanceof JLeftPadded) && !(this.getCursor().getValue() instanceof J.EnumValueSet)) {
            this.getCursor().putMessage("lastIndent", (Object)indent);
        }
        return s;
    }

    @Override
    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, P p) {
        Space after;
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        int indent = Optional.ofNullable((Integer)this.getCursor().getNearestMessage("lastIndent")).orElse(0);
        if (right.getElement() instanceof J) {
            J elem = (J)right.getElement();
            if (right.getAfter().getLastWhitespace().contains("\n") || elem.getPrefix().getLastWhitespace().contains("\n")) {
                switch (loc) {
                    case FOR_CONDITION: 
                    case FOR_UPDATE: {
                        J.ForLoop.Control control = (J.ForLoop.Control)this.getCursor().getParentOrThrow().getValue();
                        Space initPrefix = control.getPadding().getInit().getElement().getPrefix();
                        if (!initPrefix.getLastWhitespace().contains("\n")) {
                            int initIndent = this.forInitColumn();
                            this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(initIndent - this.style.getContinuationIndent()));
                            elem = (J)this.visitAndCast(elem, p);
                            this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                            after = this.indentTo(right.getAfter(), initIndent);
                            break;
                        }
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                    case METHOD_DECLARATION_PARAMETER: {
                        JContainer container = (JContainer)this.getCursor().getParentOrThrow().getValue();
                        J firstArg = (J)container.getElements().iterator().next();
                        if (firstArg.getPrefix().getWhitespace().isEmpty()) {
                            after = right.getAfter();
                            break;
                        }
                        if (firstArg.getPrefix().getLastWhitespace().contains("\n")) {
                            elem = (J)this.visitAndCast(elem, p);
                            after = this.indentTo(right.getAfter(), indent);
                            break;
                        }
                        int firstArgIndent = this.findIndent(firstArg.getPrefix());
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)firstArgIndent);
                        elem = (J)this.visitAndCast(elem, p);
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                        after = this.indentTo(right.getAfter(), firstArgIndent);
                        break;
                    }
                    case METHOD_INVOCATION_ARGUMENT: {
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.indentTo(right.getAfter(), indent);
                        break;
                    }
                    case NEW_CLASS_ARGUMENTS: 
                    case ARRAY_INDEX: 
                    case PARENTHESES: 
                    case TYPE_PARAMETER: {
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.indentTo(right.getAfter(), indent);
                        break;
                    }
                    case METHOD_SELECT: {
                        Cursor cursor = this.getCursor();
                        while (true) {
                            if (cursor.getValue() instanceof JRightPadded) {
                                cursor = cursor.getParentOrThrow();
                            }
                            if (!(cursor.getValue() instanceof J.MethodInvocation)) break;
                            Integer methodIndent = (Integer)cursor.getNearestMessage("lastIndent");
                            if (methodIndent != null) {
                                indent = methodIndent;
                            }
                            cursor = cursor.getParentOrThrow();
                        }
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                        break;
                    }
                    case ANNOTATION_ARGUMENT: {
                        JContainer args = (JContainer)this.getCursor().getParentOrThrow().getValue();
                        elem = (J)this.visitAndCast(elem, p);
                        if (args.getPadding().getElements().get(args.getElements().size() - 1) == right) {
                            this.getCursor().getParentOrThrow().putMessage("indentType", (Object)IndentType.ALIGN);
                        }
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                    default: {
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                }
            } else {
                switch (loc) {
                    case METHOD_INVOCATION_ARGUMENT: 
                    case NEW_CLASS_ARGUMENTS: {
                        if (!elem.getPrefix().getLastWhitespace().contains("\n")) {
                            JContainer args = (JContainer)this.getCursor().getParentOrThrow().getValue();
                            boolean seenArg = false;
                            boolean anyOtherArgOnOwnLine = false;
                            for (JRightPadded arg : args.getPadding().getElements()) {
                                if (arg == this.getCursor().getValue()) {
                                    seenArg = true;
                                    continue;
                                }
                                if (!seenArg || !((J)arg.getElement()).getPrefix().getLastWhitespace().contains("\n")) continue;
                                anyOtherArgOnOwnLine = true;
                                break;
                            }
                            if (!anyOtherArgOnOwnLine) {
                                elem = (J)this.visitAndCast(elem, p);
                                after = this.indentTo(right.getAfter(), indent);
                                break;
                            }
                        }
                        if (!(elem instanceof J.Binary)) {
                            if (!(elem instanceof J.MethodInvocation)) {
                                this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                            } else if (elem.getPrefix().getLastWhitespace().contains("\n")) {
                                this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                            } else {
                                J.MethodInvocation methodInvocation = (J.MethodInvocation)elem;
                                Expression select = methodInvocation.getSelect();
                                if (select instanceof J.FieldAccess || select instanceof J.Identifier || select instanceof J.MethodInvocation) {
                                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                                }
                            }
                        }
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                    default: {
                        elem = (J)this.visitAndCast(elem, p);
                        after = right.getAfter();
                    }
                }
            }
            t = elem;
        } else {
            after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        }
        this.setCursor(this.getCursor().getParent());
        return after == right.getAfter() && t == right.getElement() ? right : new JRightPadded<T>(t, after, right.getMarkers());
    }

    @Override
    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, JContainer.Location loc, P p) {
        List js;
        Space before;
        this.setCursor(new Cursor(this.getCursor(), container));
        int indent = Optional.ofNullable((Integer)this.getCursor().getNearestMessage("lastIndent")).orElse(0);
        if (container.getBefore().getLastWhitespace().contains("\n")) {
            switch (loc) {
                case TYPE_PARAMETERS: 
                case IMPLEMENTS: 
                case THROWS: 
                case NEW_CLASS_ARGUMENTS: {
                    before = this.indentTo(container.getBefore(), indent + this.style.getContinuationIndent());
                    this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
                default: {
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
            }
        } else {
            switch (loc) {
                case TYPE_PARAMETERS: 
                case IMPLEMENTS: 
                case THROWS: 
                case NEW_CLASS_ARGUMENTS: 
                case METHOD_INVOCATION_ARGUMENTS: {
                    this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
                default: {
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                }
            }
        }
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build(before, js, container.getMarkers());
    }

    private Space indentTo(Space space, int column) {
        if (!space.getLastWhitespace().contains("\n")) {
            return space;
        }
        space = this.style.getUseTabCharacter() != false ? space.withWhitespace(space.getWhitespace().replaceAll(" ", "")) : space.withWhitespace(space.getWhitespace().replaceAll("\t", ""));
        int indent = this.findIndent(space);
        if (!space.getComments().isEmpty()) {
            indent = this.findIndent(Space.format(space.getComments().get(space.getComments().size() - 1).getSuffix()));
        }
        if (indent != column) {
            int shift = column - indent;
            space = space.withComments(ListUtils.map(space.getComments(), c -> this.indentComment((Comment)c, shift)));
            space = space.withWhitespace(this.indent(space.getWhitespace(), shift));
        }
        return space;
    }

    private Comment indentComment(Comment comment, int shift) {
        StringBuilder newSuffix = new StringBuilder(comment.getSuffix());
        this.shift(newSuffix, shift);
        String newText = comment.getText();
        if (comment.getStyle() != Comment.Style.LINE) {
            StringBuilder newTextBuilder = new StringBuilder();
            for (char c : comment.getText().toCharArray()) {
                newTextBuilder.append(c);
                if (c != '\n') continue;
                this.shift(newTextBuilder, shift);
            }
            newText = newTextBuilder.toString();
        }
        return comment.withText(newText).withSuffix(newSuffix.toString());
    }

    private String indent(String whitespace, int shift) {
        if (!this.style.getUseTabCharacter().booleanValue() && whitespace.contains("\t")) {
            whitespace = whitespace.replaceAll("\t", this.spacesForTab);
        }
        StringBuilder newWhitespace = new StringBuilder(whitespace);
        this.shift(newWhitespace, shift);
        return newWhitespace.toString();
    }

    private void shift(StringBuilder text, int shift) {
        int tabIndent = this.style.getTabSize();
        if (!this.style.getUseTabCharacter().booleanValue()) {
            tabIndent = Integer.MAX_VALUE;
        }
        if (shift > 0) {
            int i;
            for (i = 0; i < shift / tabIndent; ++i) {
                text.append('\t');
            }
            for (i = 0; i < shift % tabIndent; ++i) {
                text.append(' ');
            }
        } else {
            int len = this.style.getUseTabCharacter() != false ? text.length() + shift / tabIndent : text.length() + shift;
            if (len > 0) {
                text.delete(len, text.length());
            }
        }
    }

    private int findIndent(Space space) {
        String indent = space.getIndent();
        int size = 0;
        for (char c : indent.toCharArray()) {
            size += c == '\t' ? this.style.getTabSize() : 1;
            if (c != '\n' && c != '\r') continue;
            size = 0;
        }
        return size;
    }

    private int forInitColumn() {
        Cursor forCursor = this.getCursor().dropParentUntil(J.ForLoop.class::isInstance);
        J.ForLoop forLoop = (J.ForLoop)forCursor.getValue();
        Object parent = forCursor.getParentOrThrow().getValue();
        J.ForLoop alignTo = parent instanceof J.Label ? ((J.Label)parent).withStatement(forLoop.withBody(null)) : forLoop.withBody(null);
        int column = 0;
        boolean afterInitStart = false;
        for (char c : alignTo.print().toCharArray()) {
            if (c == '(') {
                afterInitStart = true;
            } else if (afterInitStart && !Character.isWhitespace(c)) {
                return column - 1;
            }
            ++column;
        }
        throw new IllegalStateException("For loops must have a control section");
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    private static enum IndentType {
        ALIGN,
        INDENT,
        CONTINUATION_INDENT;

    }
}

