/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.EqualsAvoidsNullStyle;
import org.openrewrite.java.cleanup.EqualsAvoidsNullVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;

public class EqualsAvoidsNull
extends Recipe {
    public String getDisplayName() {
        return "Equals avoids null";
    }

    public String getDescription() {
        return "Checks that any combination of String literals is on the left side of an `equals()` comparison. Also checks for String literals assigned to some field (such as `someString.equals(anotherString = \"text\"))`.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new EqualsAvoidsNullFromCompilationUnitStyle();
    }

    private static class EqualsAvoidsNullFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private EqualsAvoidsNullFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            EqualsAvoidsNullStyle style = (EqualsAvoidsNullStyle)cu.getStyle(EqualsAvoidsNullStyle.class);
            if (style == null) {
                style = IntelliJ.equalsAvoidsNull();
            }
            this.doAfterVisit(new EqualsAvoidsNullVisitor(style));
            return cu;
        }
    }
}

