/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.security;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class SecureTempFileCreation
extends Recipe {
    private static final ThreadLocal<JavaParser> JAVA_PARSER_THREAD_LOCAL = ThreadLocal.withInitial(() -> JavaParser.fromJavaVersion().build());
    private static final String CREATE_TEMP_FILE_PATTERN = "java.io.File createTempFile(..)";
    private static final MethodMatcher matcher = new MethodMatcher("java.io.File createTempFile(..)");

    public String getDisplayName() {
        return "Use secure temporary file creation";
    }

    public String getDescription() {
        return "`java.io.File.createTempFile()` has exploitable default file permissions. This recipe migrates to the more secure `java.nio.file.Files.createTempFile()`.";
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(CREATE_TEMP_FILE_PATTERN);
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = method;
                if (matcher.matches(m)) {
                    this.maybeAddImport("java.nio.file.Files");
                    if (m.getArguments().size() == 2) {
                        m = (J.MethodInvocation)m.withTemplate(this.template("Files.createTempFile(#{}, #{}).toFile();").imports("java.nio.file.Files").javaParser((JavaParser)JAVA_PARSER_THREAD_LOCAL.get()).build(), m.getCoordinates().replace(), m.getArguments().get(0), m.getArguments().get(1));
                    } else if (m.getArguments().size() == 3) {
                        m = (J.MethodInvocation)m.withTemplate(this.template("Files.createTempFile(#{}.toPath(), #{}, #{}).toFile();").imports("java.nio.file.Files").javaParser((JavaParser)JAVA_PARSER_THREAD_LOCAL.get()).build(), m.getCoordinates().replace(), m.getArguments().get(2), m.getArguments().get(0), m.getArguments().get(1));
                    }
                }
                return m;
            }
        };
    }
}

