/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import java.util.List;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

final class ControlFlowJavaPrinter<P>
extends JavaPrinter<P> {
    final List<J> nodesToPrint;

    @Override
    public J visitAssert(J.Assert azzert, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(azzert, p);
        return super.visitAssert(azzert, p);
    }

    @Override
    public J visitAssignment(J.Assignment assignment, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(assignment, p);
        return super.visitAssignment(assignment, p);
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(assignOp, p);
        return super.visitAssignmentOperation(assignOp, p);
    }

    @Override
    public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(binary, p);
        return super.visitBinary(binary, p);
    }

    @Override
    public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(block, p);
        J.Block customized = block.withPrefix(block.getEnd());
        return super.visitBlock(customized, p);
    }

    @Override
    protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
        if (paddedStat == null) {
            return;
        }
        this.maybeEnableOrDisable(paddedStat.getElement(), p);
        super.visitStatement(paddedStat, location, p);
    }

    @Override
    public J visitBreak(J.Break breakStatement, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(breakStatement, p);
        return super.visitBreak(breakStatement, p);
    }

    @Override
    public J visitCase(J.Case caze, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(caze, p);
        return super.visitCase(caze, p);
    }

    @Override
    public J visitCatch(J.Try.Catch catzh, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(catzh, p);
        return super.visitCatch(catzh, p);
    }

    @Override
    public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(classDecl, p);
        return super.visitClassDeclaration(classDecl, p);
    }

    @Override
    public J visitContinue(J.Continue continueStatement, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(continueStatement, p);
        return super.visitContinue(continueStatement, p);
    }

    @Override
    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, PrintOutputCapture<P> p) {
        J.If enclosing = (J.If)this.getCursor().firstEnclosing(J.If.class);
        if (enclosing != null && enclosing.getIfCondition() == controlParens) {
            return super.visitControlParentheses(controlParens, p);
        }
        J.WhileLoop enclosingLoop = (J.WhileLoop)this.getCursor().firstEnclosing(J.WhileLoop.class);
        if (enclosingLoop != null && enclosingLoop.getCondition() == controlParens) {
            return super.visitControlParentheses(controlParens, p);
        }
        J.DoWhileLoop enclosingDoWhileLoop = (J.DoWhileLoop)this.getCursor().firstEnclosing(J.DoWhileLoop.class);
        if (enclosingDoWhileLoop != null && enclosingDoWhileLoop.getWhileCondition() == controlParens) {
            return super.visitControlParentheses(controlParens, p);
        }
        this.maybeEnableOrDisable(controlParens, p);
        return super.visitControlParentheses(controlParens, p);
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(doWhileLoop, p);
        return super.visitDoWhileLoop(doWhileLoop, p);
    }

    @Override
    public J visitEnumValue(J.EnumValue enoom, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(enoom, p);
        return super.visitEnumValue(enoom, p);
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enums, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(enums, p);
        return super.visitEnumValueSet(enums, p);
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(fieldAccess, p);
        return super.visitFieldAccess(fieldAccess, p);
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(forLoop, p);
        return super.visitForLoop(forLoop, p);
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(forEachLoop, p);
        return super.visitForEachLoop(forEachLoop, p);
    }

    @Override
    public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
        J.Assignment parentAssignment = (J.Assignment)this.getCursor().firstEnclosing(J.Assignment.class);
        if (parentAssignment != null && parentAssignment.getVariable().unwrap() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.VariableDeclarations.NamedVariable parentNamedVariable = (J.VariableDeclarations.NamedVariable)this.getCursor().firstEnclosing(J.VariableDeclarations.NamedVariable.class);
        if (parentNamedVariable != null && parentNamedVariable.getName() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.FieldAccess parentFieldAccess = (J.FieldAccess)this.getCursor().firstEnclosing(J.FieldAccess.class);
        if (parentFieldAccess != null && parentFieldAccess.getName() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.NewClass parentNewClass = (J.NewClass)this.getCursor().firstEnclosing(J.NewClass.class);
        if (parentNewClass != null && parentNewClass.getClazz() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.MethodInvocation parentMethodInvocation = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
        if (parentMethodInvocation != null && parentMethodInvocation.getName() == ident) {
            return super.visitIdentifier(ident, p);
        }
        this.maybeEnableOrDisable(ident, p);
        return super.visitIdentifier(ident, p);
    }

    @Override
    public J visitIf(J.If iff, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(iff, p);
        return super.visitIf(iff, p);
    }

    @Override
    public J visitElse(J.If.Else elze, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(elze, p);
        return super.visitElse(elze, p);
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(instanceOf, p);
        return super.visitInstanceOf(instanceOf, p);
    }

    @Override
    public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(lambda, p);
        return super.visitLambda(lambda, p);
    }

    @Override
    public J visitLiteral(J.Literal literal, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(literal, p);
        return super.visitLiteral(literal, p);
    }

    @Override
    public J visitMemberReference(J.MemberReference memberRef, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(memberRef, p);
        return super.visitMemberReference(memberRef, p);
    }

    @Override
    public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(method, p);
        return super.visitMethodDeclaration(method, p);
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(method, p);
        return super.visitMethodInvocation(method, p);
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(multiCatch, p);
        return super.visitMultiCatch(multiCatch, p);
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(multiVariable, p);
        return super.visitVariableDeclarations(multiVariable, p);
    }

    @Override
    public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(newArray, p);
        return super.visitNewArray(newArray, p);
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(parens, p);
        return super.visitParentheses(parens, p);
    }

    @Override
    public J visitSwitch(J.Switch switzh, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(switzh, p);
        return super.visitSwitch(switzh, p);
    }

    @Override
    public J visitSynchronized(J.Synchronized synch, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(synch, p);
        return super.visitSynchronized(synch, p);
    }

    @Override
    public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(ternary, p);
        return super.visitTernary(ternary, p);
    }

    @Override
    public J visitThrow(J.Throw thrown, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(thrown, p);
        return super.visitThrow(thrown, p);
    }

    @Override
    public J visitTry(J.Try tryable, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(tryable, p);
        return super.visitTry(tryable, p);
    }

    @Override
    public J visitUnary(J.Unary unary, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(unary, p);
        return super.visitUnary(unary, p);
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(variable, p);
        return super.visitVariable(variable, p);
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(whileLoop, p);
        return super.visitWhileLoop(whileLoop, p);
    }

    @Override
    public J visitEmpty(J.Empty empty, PrintOutputCapture<P> pPrintOutputCapture) {
        J.MethodInvocation maybeParent = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
        if (maybeParent != null && maybeParent.getArguments().contains(empty)) {
            return super.visitEmpty(empty, pPrintOutputCapture);
        }
        this.maybeEnableOrDisable(empty, pPrintOutputCapture);
        return super.visitEmpty(empty.withPrefix(Space.build(" ", ListUtils.concat(empty.getComments(), (Object)new TextComment(true, "Empty", "", Markers.EMPTY)))), pPrintOutputCapture);
    }

    private void maybeEnableOrDisable(J j, PrintOutputCapture<P> p) {
        if (this.nodesToPrint.contains(j)) {
            ControlFlowJavaPrinter.castPrint(p).enable();
        } else {
            ControlFlowJavaPrinter.castPrint(p).disable();
        }
    }

    private static <P> ControlFlowPrintOutputCapture<P> castPrint(PrintOutputCapture<P> print) {
        return (ControlFlowPrintOutputCapture)print;
    }

    public ControlFlowJavaPrinter(List<J> nodesToPrint) {
        this.nodesToPrint = nodesToPrint;
    }

    static class ControlFlowPrintOutputCapture<P>
    extends PrintOutputCapture<P> {
        boolean enabled = false;

        public ControlFlowPrintOutputCapture(P p) {
            super(p);
        }

        public PrintOutputCapture<P> append(char c) {
            if (this.enabled) {
                return super.append(c);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return super.append(c);
                }
            }
            return super.append(' ');
        }

        public PrintOutputCapture<P> append(@Nullable String text) {
            if (this.enabled) {
                return super.append(text);
            }
            if (text != null) {
                return super.append(text.replaceAll("[^ \\t\\n\\r]", " "));
            }
            return this;
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }
    }
}

