/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.cleanup.LambdaBlockToExpression;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class UseLambdaForFunctionalInterface
extends Recipe {
    public String getDisplayName() {
        return "Use lambdas expression to replace anonymous class where possible";
    }

    public String getDescription() {
        return "Instead of anonymous class declarations, use a lambda where possible. Using lambdas to replace anonymous classes can lead to more expressive and maintainable code, improve code readability, reduce code duplication, and achieve better performance in some cases.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1604");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                JavaType.FullyQualified type;
                J.NewClass n = (J.NewClass)super.visitNewClass(newClass, ctx);
                if (n.getBody() != null && n.getBody().getStatements().size() == 1 && n.getBody().getStatements().get(0) instanceof J.MethodDeclaration && n.getClazz() != null && (type = TypeUtils.asFullyQualified(n.getClazz().getType())) != null && type.getKind().equals((Object)JavaType.FullyQualified.Kind.Interface)) {
                    JavaType.Method sam = null;
                    for (JavaType.Method method : type.getMethods()) {
                        if (method.hasFlags(Flag.Default) || method.hasFlags(Flag.Static)) continue;
                        if (sam != null) {
                            return n;
                        }
                        sam = method;
                    }
                    if (sam == null) {
                        return n;
                    }
                    if (UseLambdaForFunctionalInterface.usesThis(this.getCursor()) || UseLambdaForFunctionalInterface.shadowsLocalVariable(this.getCursor()) || UseLambdaForFunctionalInterface.usedAsStatement(this.getCursor()) || UseLambdaForFunctionalInterface.fieldInitializerReferencingUninitializedField(this.getCursor())) {
                        return n;
                    }
                    JavaType.FullyQualified typedInterface = null;
                    JavaType.FullyQualified anonymousClass = TypeUtils.asFullyQualified(n.getType());
                    if (anonymousClass != null) {
                        typedInterface = anonymousClass.getInterfaces().stream().filter(i -> i.getFullyQualifiedName().equals(type.getFullyQualifiedName())).findFirst().orElse(null);
                    }
                    if (typedInterface == null) {
                        return n;
                    }
                    StringBuilder templateBuilder = new StringBuilder();
                    J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)n.getBody().getStatements().get(0);
                    if (methodDeclaration.getParameters().get(0) instanceof J.Empty) {
                        templateBuilder.append("() -> {");
                    } else {
                        templateBuilder.append(methodDeclaration.getParameters().stream().map(param -> ((J.VariableDeclarations)param).getVariables().get(0).getSimpleName()).collect(Collectors.joining(",", "(", ") -> {")));
                    }
                    JavaType returnType = sam.getReturnType();
                    if (!JavaType.Primitive.Void.equals(returnType)) {
                        templateBuilder.append("return ").append(this.valueOfType(returnType)).append(';');
                    }
                    templateBuilder.append('}');
                    J.Lambda lambda = (J.Lambda)n.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), templateBuilder.toString()).build(), n.getCoordinates().replace(), new Object[0]);
                    lambda = lambda.withType(typedInterface);
                    lambda = (J.Lambda)new UnnecessaryParenthesesVisitor(Checkstyle.unnecessaryParentheses()).visitNonNull(lambda, ctx);
                    J.Block lambdaBody = methodDeclaration.getBody();
                    assert (lambdaBody != null);
                    lambda = lambda.withBody(lambdaBody.withPrefix(Space.format(" ")));
                    lambda = (J.Lambda)new LambdaBlockToExpression().getVisitor().visitNonNull((Tree)lambda, (Object)ctx);
                    this.doAfterVisit(new RemoveUnusedImports());
                    return this.autoFormat(lambda, ctx);
                }
                return n;
            }

            private String valueOfType(@Nullable JavaType type) {
                JavaType.Primitive primitive = TypeUtils.asPrimitive(type);
                if (primitive != null) {
                    switch (primitive) {
                        case Boolean: {
                            return "true";
                        }
                        case Byte: 
                        case Char: 
                        case Int: 
                        case Double: 
                        case Float: 
                        case Long: 
                        case Short: {
                            return "0";
                        }
                        case String: 
                        case Null: {
                            return "null";
                        }
                    }
                    return "";
                }
                return "null";
            }
        };
    }

    private static boolean usesThis(Cursor cursor) {
        J.NewClass n = (J.NewClass)cursor.getValue();
        assert (n.getBody() != null);
        final AtomicBoolean hasThis = new AtomicBoolean(false);
        new JavaVisitor<Integer>(){

            @Override
            public J visitIdentifier(J.Identifier ident, Integer integer) {
                if (ident.getSimpleName().equals("this")) {
                    hasThis.set(true);
                }
                return super.visitIdentifier(ident, integer);
            }
        }.visit(n.getBody(), 0, cursor);
        return hasThis.get();
    }

    private static List<String> parameterNames(J.MethodDeclaration method) {
        return method.getParameters().stream().filter(s -> s instanceof J.VariableDeclarations).map(v -> ((J.VariableDeclarations)v).getVariables().get(0).getSimpleName()).collect(Collectors.toList());
    }

    private static List<String> classFields(J.ClassDeclaration classDeclaration) {
        return classDeclaration.getBody().getStatements().stream().filter(s -> s instanceof J.VariableDeclarations).map(v -> ((J.VariableDeclarations)v).getVariables().get(0).getSimpleName()).collect(Collectors.toList());
    }

    private static boolean usedAsStatement(Cursor cursor) {
        Iterator path = cursor.getParentOrThrow().getPath();
        Object last = cursor.getValue();
        while (path.hasNext()) {
            Object next = path.next();
            if (next instanceof J.Block) {
                return true;
            }
            if (next instanceof J && !(next instanceof J.MethodInvocation)) {
                return false;
            }
            if (next instanceof J.MethodInvocation) {
                for (Expression argument : ((J.MethodInvocation)next).getArguments()) {
                    if (argument != last) continue;
                    return false;
                }
            }
            if (!(next instanceof J)) continue;
            last = next;
        }
        return false;
    }

    private static boolean fieldInitializerReferencingUninitializedField(Cursor cursor) {
        J.NewClass n = (J.NewClass)cursor.getValue();
        assert (n.getBody() != null);
        Cursor parent = cursor.dropParentUntil(is -> is instanceof J.VariableDeclarations.NamedVariable || is instanceof SourceFile);
        Object parentValue = parent.getValue();
        if (!(parentValue instanceof J.VariableDeclarations.NamedVariable)) {
            return false;
        }
        J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)cursor.firstEnclosing(J.VariableDeclarations.NamedVariable.class);
        if (variable == null || variable.getInitializer() == null) {
            return false;
        }
        parent = cursor.dropParentUntil(is -> is instanceof J.MethodDeclaration || is instanceof J.ClassDeclaration || is instanceof SourceFile);
        parentValue = parent.getValue();
        if (!(parentValue instanceof J.ClassDeclaration) || ((J.ClassDeclaration)parentValue).getType() == null) {
            return false;
        }
        final JavaType.FullyQualified owner = ((J.ClassDeclaration)parentValue).getType();
        final AtomicBoolean referencesUninitializedFinalField = new AtomicBoolean(false);
        new JavaIsoVisitor<Integer>(){

            @Override
            public J.Identifier visitIdentifier(J.Identifier ident, Integer integer) {
                if (referencesUninitializedFinalField.get()) {
                    return ident;
                }
                if (ident.getFieldType() != null && ident.getFieldType().hasFlags(Flag.Final) && !ident.getFieldType().hasFlags(Flag.HasInit) && owner.equals(ident.getFieldType().getOwner())) {
                    referencesUninitializedFinalField.set(true);
                }
                return super.visitIdentifier(ident, integer);
            }
        }.visit(n.getBody(), 0, cursor);
        return referencesUninitializedFinalField.get();
    }

    private static boolean shadowsLocalVariable(Cursor cursor) {
        final J.NewClass n = (J.NewClass)cursor.getValue();
        assert (n.getBody() != null);
        final AtomicBoolean hasShadow = new AtomicBoolean(false);
        final ArrayList<String> localVariables = new ArrayList<String>();
        final ArrayList nameScopeBlocks = new ArrayList();
        J nameScope = (J)cursor.dropParentUntil(p -> {
            if (p instanceof J.Block) {
                nameScopeBlocks.add((J.Block)p);
            }
            return p instanceof J.MethodDeclaration || p instanceof J.ClassDeclaration;
        }).getValue();
        if (nameScope instanceof J.MethodDeclaration) {
            J.MethodDeclaration m = (J.MethodDeclaration)nameScope;
            localVariables.addAll(UseLambdaForFunctionalInterface.parameterNames(m));
            J.ClassDeclaration c = (J.ClassDeclaration)cursor.firstEnclosing(J.ClassDeclaration.class);
            assert (c != null);
            localVariables.addAll(UseLambdaForFunctionalInterface.classFields(c));
        } else {
            J.ClassDeclaration c = (J.ClassDeclaration)nameScope;
            localVariables.addAll(UseLambdaForFunctionalInterface.classFields(c));
        }
        new JavaVisitor<List<String>>(){

            @Override
            public J visitVariable(J.VariableDeclarations.NamedVariable variable, List<String> variables) {
                variables.add(variable.getSimpleName());
                return variable;
            }

            @Override
            public J visitBlock(J.Block block, List<String> strings) {
                return nameScopeBlocks.contains(block) ? super.visitBlock(block, strings) : block;
            }

            @Override
            public J visitNewClass(J.NewClass newClass, List<String> variables) {
                if (newClass == n) {
                    this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
                }
                return newClass;
            }

            @Nullable
            public J visit(@Nullable Tree tree, List<String> variables) {
                if (this.getCursor().getNearestMessage("stop") != null) {
                    return (J)tree;
                }
                return (J)super.visit(tree, variables);
            }
        }.visit(nameScope, localVariables);
        new JavaVisitor<Integer>(){

            @Override
            public J visitVariable(J.VariableDeclarations.NamedVariable variable, Integer integer) {
                if (localVariables.contains(variable.getSimpleName())) {
                    hasShadow.set(true);
                }
                return super.visitVariable(variable, integer);
            }
        }.visit(n.getBody(), 0, cursor);
        return hasShadow.get();
    }
}

