/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.JavaType;

class TypeVisitor
extends MethodSignatureParserBaseVisitor<String> {
    TypeVisitor() {
    }

    @Override
    public String visitClassNameOrInterface(MethodSignatureParser.ClassNameOrInterfaceContext ctx) {
        StringBuilder classNameBuilder = new StringBuilder();
        for (ParseTree c : ctx.children) {
            classNameBuilder.append(StringUtils.aspectjNameToPattern((String)c.getText()));
        }
        String className = classNameBuilder.toString();
        if (!className.contains(".")) {
            try {
                String beforeArr;
                int arrInit = className.lastIndexOf("\\[");
                String string = beforeArr = arrInit == -1 ? className : className.substring(0, arrInit);
                if (JavaType.Primitive.fromKeyword(beforeArr) != null) {
                    if ("String".equals(beforeArr)) {
                        return "java.lang." + className;
                    }
                    return className;
                }
                Class.forName("java.lang." + beforeArr, false, TypeVisitor.class.getClassLoader());
                return "java.lang." + className;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return className;
    }
}

