/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.Tree;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.internal.grammar.TemplateParameterLexer;
import org.openrewrite.java.internal.grammar.TemplateParameterParser;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

class JavaTemplateSemanticallyEqual
extends SemanticallyEqual {
    JavaTemplateSemanticallyEqual() {
    }

    static TemplateMatchResult matchesTemplate(JavaTemplate template, J input) {
        JavaCoordinates coordinates;
        if (input instanceof Expression) {
            coordinates = ((Expression)input).getCoordinates().replace();
        } else if (input instanceof Statement) {
            coordinates = ((Statement)input).getCoordinates().replace();
        } else {
            throw new IllegalArgumentException("Only expressions and statements can be matched against a template: " + input.getClass());
        }
        Object[] parameters = JavaTemplateSemanticallyEqual.createTemplateParameters(template.getCode());
        try {
            Object templateTree = template.withTemplate((Tree)input, coordinates, parameters);
            return JavaTemplateSemanticallyEqual.matchTemplate(templateTree, input);
        }
        catch (RuntimeException e) {
            return new TemplateMatchResult(false, Collections.emptyList());
        }
    }

    private static J[] createTemplateParameters(String code) {
        String previous;
        PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("#{", "}", null);
        ArrayList parameters = new ArrayList();
        String substituted = code;
        while (!(previous = substituted).equals(substituted = propertyPlaceholderHelper.replacePlaceholders(substituted, key -> {
            if (key.isEmpty()) throw new IllegalArgumentException("Only typed placeholders are allowed.");
            TemplateParameterParser parser = new TemplateParameterParser((TokenStream)new CommonTokenStream((TokenSource)new TemplateParameterLexer((CharStream)CharStreams.fromString((String)key))));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

                public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                    throw new IllegalArgumentException(String.format("Syntax error at line %d:%d %s.", line, charPositionInLine, msg), (Throwable)e);
                }
            });
            TemplateParameterParser.MatcherPatternContext ctx = parser.matcherPattern();
            String matcherName = ctx.matcherName().Identifier().getText();
            List<TemplateParameterParser.MatcherParameterContext> params = ctx.matcherParameter();
            if (!"any".equals(matcherName)) throw new IllegalArgumentException("Invalid template matcher '" + key + "'");
            String fqn = params.size() == 1 ? (params.get(0).Identifier() != null ? params.get(0).Identifier().getText() : params.get(0).FullyQualifiedName().getText()) : "java.lang.Object";
            String s = fqn.replace("$", ".");
            Markers markers = Markers.build(Collections.singleton(new TemplateParameter(Tree.randomId(), s)));
            parameters.add(new J.Empty(Tree.randomId(), Space.EMPTY, markers));
            return s;
        }))) {
        }
        return parameters.toArray(new J[0]);
    }

    private static TemplateMatchResult matchTemplate(J templateTree, J tree) {
        JavaTemplateSemanticallyEqualVisitor semanticallyEqualVisitor = new JavaTemplateSemanticallyEqualVisitor();
        semanticallyEqualVisitor.visit((Tree)templateTree, tree);
        return new TemplateMatchResult(semanticallyEqualVisitor.isEqual(), semanticallyEqualVisitor.matchedParameters);
    }

    static final class TemplateMatchResult {
        private final boolean match;
        private final List<J> matchedParameters;

        public TemplateMatchResult(boolean match, List<J> matchedParameters) {
            this.match = match;
            this.matchedParameters = matchedParameters;
        }

        public boolean isMatch() {
            return this.match;
        }

        public List<J> getMatchedParameters() {
            return this.matchedParameters;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateMatchResult)) {
                return false;
            }
            TemplateMatchResult other = (TemplateMatchResult)o;
            if (this.isMatch() != other.isMatch()) {
                return false;
            }
            List<J> this$matchedParameters = this.getMatchedParameters();
            List<J> other$matchedParameters = other.getMatchedParameters();
            return !(this$matchedParameters == null ? other$matchedParameters != null : !((Object)this$matchedParameters).equals(other$matchedParameters));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMatch() ? 79 : 97);
            List<J> $matchedParameters = this.getMatchedParameters();
            result = result * 59 + ($matchedParameters == null ? 43 : ((Object)$matchedParameters).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaTemplateSemanticallyEqual.TemplateMatchResult(match=" + this.isMatch() + ", matchedParameters=" + this.getMatchedParameters() + ")";
        }
    }

    private static class JavaTemplateSemanticallyEqualVisitor
    extends SemanticallyEqual.SemanticallyEqualVisitor {
        final List<J> matchedParameters = new ArrayList<J>();

        public JavaTemplateSemanticallyEqualVisitor() {
            super(true);
        }

        private boolean matchTemplateParameterPlaceholder(J.Empty empty, J j) {
            return empty.getMarkers().findFirst(TemplateParameter.class).map(m -> "java.lang.Object".equals(((TemplateParameter)m).typeName) || j instanceof TypedTree && TypeUtils.isAssignableTo(((TemplateParameter)m).typeName, ((TypedTree)j).getType())).orElse(false) != false && this.matchedParameters.add(j);
        }

        @Override
        public J.Empty visitEmpty(J.Empty empty, J j) {
            if (this.isEqual.get()) {
                if (this.matchTemplateParameterPlaceholder(empty, j)) {
                    return empty;
                }
                if (!(j instanceof J.Empty)) {
                    this.isEqual.set(false);
                    return empty;
                }
                J.Empty compareTo = (J.Empty)j;
                if (this.nullMissMatch(empty.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return empty;
                }
            }
            return empty;
        }
    }

    private static final class TemplateParameter
    implements Marker {
        private final UUID id;
        private final String typeName;

        public TemplateParameter(UUID id, String typeName) {
            this.id = id;
            this.typeName = typeName;
        }

        public UUID getId() {
            return this.id;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateParameter)) {
                return false;
            }
            TemplateParameter other = (TemplateParameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaTemplateSemanticallyEqual.TemplateParameter(id=" + this.getId() + ", typeName=" + this.getTypeName() + ")";
        }

        @NonNull
        public TemplateParameter withId(UUID id) {
            return this.id == id ? this : new TemplateParameter(id, this.typeName);
        }

        @NonNull
        public TemplateParameter withTypeName(String typeName) {
            return this.typeName == typeName ? this : new TemplateParameter(this.id, typeName);
        }
    }
}

