/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.RandomizeIdVisitor;
import org.openrewrite.java.internal.template.AnnotationTemplateGenerator;
import org.openrewrite.java.internal.template.BlockStatementTemplateGenerator;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

public class JavaTemplateParser {
    private static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("#{", "}", null);
    private static final Object templateCacheLock = new Object();
    private static final Map<String, List<? extends J>> templateCache = new LinkedHashMap<String, List<? extends J>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    };
    private static final String PACKAGE_STUB = "package #{}; class $Template {}";
    private static final String PARAMETER_STUB = "abstract class $Template { abstract void $template(#{}); }";
    private static final String LAMBDA_PARAMETER_STUB = "class $Template { { Object o = (#{}) -> {}; } }";
    private static final String EXPRESSION_STUB = "class $Template { { Object o = #{}; } }";
    private static final String EXTENDS_STUB = "class $Template extends #{} {}";
    private static final String IMPLEMENTS_STUB = "class $Template implements #{} {}";
    private static final String THROWS_STUB = "abstract class $Template { abstract void $template() throws #{}; }";
    private static final String TYPE_PARAMS_STUB = "class $Template<#{}> {}";
    @Language(value="java")
    private static final String SUBSTITUTED_ANNOTATION = "@java.lang.annotation.Documented public @interface SubAnnotation { int value(); }";
    private final JavaParser.Builder<?, ?> parser;
    private final Consumer<String> onAfterVariableSubstitution;
    private final Consumer<String> onBeforeParseTemplate;
    private final Set<String> imports;
    private final BlockStatementTemplateGenerator statementTemplateGenerator;
    private final AnnotationTemplateGenerator annotationTemplateGenerator;

    public JavaTemplateParser(JavaParser.Builder<?, ?> parser, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate, Set<String> imports) {
        this.parser = parser;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.onBeforeParseTemplate = onBeforeParseTemplate;
        this.imports = imports;
        this.statementTemplateGenerator = new BlockStatementTemplateGenerator(imports);
        this.annotationTemplateGenerator = new AnnotationTemplateGenerator(imports);
    }

    public List<Statement> parseParameters(String template) {
        String stub = this.addImports(this.substitute(PARAMETER_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            J.MethodDeclaration m = (J.MethodDeclaration)cu.getClasses().get(0).getBody().getStatements().get(0);
            return m.getParameters();
        });
    }

    public J.Lambda.Parameters parseLambdaParameters(String template) {
        String stub = this.addImports(this.substitute(LAMBDA_PARAMETER_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return (J.Lambda.Parameters)this.cache(stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            J.Block b = (J.Block)cu.getClasses().get(0).getBody().getStatements().get(0);
            J.VariableDeclarations v = (J.VariableDeclarations)b.getStatements().get(0);
            J.Lambda l = (J.Lambda)v.getVariables().get(0).getInitializer();
            assert (l != null);
            return Collections.singletonList(l.getParameters());
        }).get(0);
    }

    public J parseExpression(Cursor cursor, String template, Space.Location location) {
        String stub = this.statementTemplateGenerator.template(cursor, template, location, JavaCoordinates.Mode.REPLACEMENT);
        this.onBeforeParseTemplate.accept(stub);
        JavaSourceFile cu = this.compileTemplate(stub);
        return this.statementTemplateGenerator.listTemplatedTrees(cu, Expression.class).get(0);
    }

    public TypeTree parseExtends(String template) {
        String stub = this.addImports(this.substitute(EXTENDS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return (TypeTree)this.cache(stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            TypeTree anExtends = cu.getClasses().get(0).getExtends();
            assert (anExtends != null);
            return Collections.singletonList(anExtends);
        }).get(0);
    }

    public List<TypeTree> parseImplements(String template) {
        String stub = this.addImports(this.substitute(IMPLEMENTS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            List<TypeTree> anImplements = cu.getClasses().get(0).getImplements();
            assert (anImplements != null);
            return anImplements;
        });
    }

    public List<NameTree> parseThrows(String template) {
        String stub = this.addImports(this.substitute(THROWS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            J.MethodDeclaration m = (J.MethodDeclaration)cu.getClasses().get(0).getBody().getStatements().get(0);
            List<NameTree> aThrows = m.getThrows();
            assert (aThrows != null);
            return aThrows;
        });
    }

    public List<J.TypeParameter> parseTypeParameters(String template) {
        String stub = this.addImports(this.substitute(TYPE_PARAMS_STUB, template));
        this.onBeforeParseTemplate.accept(stub);
        return this.cache(stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            List<J.TypeParameter> tps = cu.getClasses().get(0).getTypeParameters();
            assert (tps != null);
            return tps;
        });
    }

    public <J2 extends J> List<J2> parseBlockStatements(Cursor cursor, Class<J2> expected, String template, Space.Location location, JavaCoordinates.Mode mode) {
        String stub = this.statementTemplateGenerator.template(cursor, template, location, mode);
        this.onBeforeParseTemplate.accept(stub);
        JavaSourceFile cu = this.compileTemplate(stub);
        return this.statementTemplateGenerator.listTemplatedTrees(cu, expected);
    }

    public J.MethodInvocation parseMethod(Cursor cursor, String template, Space.Location location) {
        J.MethodInvocation method = (J.MethodInvocation)cursor.getValue();
        String methodWithReplacedNameAndArgs = method.getSelect() == null ? template : method.getSelect().print(cursor) + "." + template;
        String stub = this.statementTemplateGenerator.template(cursor, methodWithReplacedNameAndArgs, location, JavaCoordinates.Mode.REPLACEMENT);
        this.onBeforeParseTemplate.accept(stub);
        JavaSourceFile cu = this.compileTemplate(stub);
        return (J.MethodInvocation)this.statementTemplateGenerator.listTemplatedTrees(cu, Statement.class).get(0);
    }

    public J.MethodInvocation parseMethodArguments(Cursor cursor, String template, Space.Location location) {
        J.MethodInvocation method = (J.MethodInvocation)cursor.getValue();
        String methodWithReplacementArgs = method.withArguments(Collections.emptyList()).printTrimmed(cursor.getParentOrThrow()).replaceAll("\\)$", template + ")");
        String stub = this.statementTemplateGenerator.template(cursor, methodWithReplacementArgs, location, JavaCoordinates.Mode.REPLACEMENT);
        this.onBeforeParseTemplate.accept(stub);
        JavaSourceFile cu = this.compileTemplate(stub);
        return (J.MethodInvocation)this.statementTemplateGenerator.listTemplatedTrees(cu, Statement.class).get(0);
    }

    public List<J.Annotation> parseAnnotations(Cursor cursor, String template) {
        String cacheKey = this.addImports(this.annotationTemplateGenerator.cacheKey(cursor, template));
        return this.cache(cacheKey, () -> {
            String stub = this.annotationTemplateGenerator.template(cursor, template);
            this.onBeforeParseTemplate.accept(stub);
            JavaSourceFile cu = this.compileTemplate(stub);
            return this.annotationTemplateGenerator.listAnnotations(cu);
        });
    }

    public Expression parsePackage(String template) {
        String stub = this.substitute(PACKAGE_STUB, template);
        this.onBeforeParseTemplate.accept(stub);
        return (Expression)this.cache(stub, () -> {
            JavaSourceFile cu = this.compileTemplate(stub);
            Expression expression = cu.getPackageDeclaration().getExpression();
            return Collections.singletonList(expression);
        }).get(0);
    }

    private String substitute(String stub, String template) {
        String beforeParse = placeholderHelper.replacePlaceholders(stub, k -> template);
        this.onAfterVariableSubstitution.accept(beforeParse);
        return beforeParse;
    }

    private String addImports(String stub) {
        if (!this.imports.isEmpty()) {
            StringBuilder withImports = new StringBuilder();
            for (String anImport : this.imports) {
                withImports.append(anImport);
            }
            withImports.append(stub);
            return withImports.toString();
        }
        return stub;
    }

    private JavaSourceFile compileTemplate(@Language(value="java") String stub) {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext();
        ctx.putMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)true);
        return stub.contains("@SubAnnotation") ? (JavaSourceFile)this.parser.build().reset().parse((ExecutionContext)ctx, stub, SUBSTITUTED_ANNOTATION).get(0) : (JavaSourceFile)this.parser.build().reset().parse((ExecutionContext)ctx, stub).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <J2 extends J> List<J2> cache(String stub, Supplier<List<? extends J>> ifAbsent) {
        List<? extends J> js;
        Object object = templateCacheLock;
        synchronized (object) {
            Timer.Sample sample = Timer.start();
            js = templateCache.get(stub);
            if (js == null) {
                js = ifAbsent.get();
                templateCache.put(stub, js);
                sample.stop(Timer.builder((String)"rewrite.template.cache").tag("result", "miss").register((MeterRegistry)Metrics.globalRegistry));
            } else {
                sample.stop(Timer.builder((String)"rewrite.template.cache").tag("result", "hit").register((MeterRegistry)Metrics.globalRegistry));
            }
        }
        return ListUtils.map(js, j -> (J)new RandomizeIdVisitor().visit((Tree)j, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Object object = templateCacheLock;
        synchronized (object) {
            templateCache.clear();
        }
    }
}

