/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import org.openrewrite.Applicability;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;

public class ReplaceStreamToListWithCollect
extends Recipe {
    private static final MethodMatcher STREAM_TO_LIST = new MethodMatcher("java.util.stream.Stream toList()");

    public String getDisplayName() {
        return "Replace Stream.toList() with Stream.collect(Collectors.toList())";
    }

    public String getDescription() {
        return "Replace Java 16 `Stream.toList()` with Java 11 `Stream.collect(Collectors.toList())`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return Applicability.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(16), new UsesMethod(STREAM_TO_LIST)});
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), "#{any(java.util.stream.Stream)}.collect(Collectors.toList())").imports("java.util.stream.Collectors").build();

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation result = (J.MethodInvocation)super.visitMethodInvocation(method, ctx);
                if (STREAM_TO_LIST.matches(method)) {
                    JRightPadded<Expression> select = result.getPadding().getSelect();
                    result = (J.MethodInvocation)result.withTemplate(this.template, result.getCoordinates().replace(), result.getSelect());
                    result = result.getPadding().withSelect(select);
                    this.maybeAddImport("java.util.stream.Collectors");
                }
                return result;
            }
        };
    }
}

