/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class HasJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String version;

    public String getDisplayName() {
        return "Find files compiled at a specific Java version";
    }

    public String getDescription() {
        return "Finds Java source files matching a particular language level. This is useful especially as an applicable test for other recipes.";
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)this.version, null).getValue());
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                return cu.getMarkers().findFirst(JavaVersion.class).filter(version -> versionComparator.isValid(null, Integer.toString(version.getMajorVersion()))).map(version -> (JavaSourceFile)SearchResult.found((Tree)cu)).orElse(cu);
            }
        };
    }

    public HasJavaVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "HasJavaVersion(version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasJavaVersion)) {
            return false;
        }
        HasJavaVersion other = (HasJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof HasJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

