/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindTypes
extends Recipe {
    @Option(displayName="Fully-qualified type name", description="A fully-qualified type name, that is used to find matching type references. Supports glob expressions. `java..*` finds every type from every subpackage of the `java` package.", example="java.util.List")
    private final String fullyQualifiedTypeName;
    @Option(displayName="Check for assignability", description="When enabled, find type references that are assignable to the provided type.", required=false)
    @Nullable
    private final Boolean checkAssignability;

    public String getDisplayName() {
        return "Find types";
    }

    public String getDescription() {
        return "Find type references by name.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>(this.fullyQualifiedTypeName);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern fullyQualifiedType = Pattern.compile(StringUtils.aspectjNameToPattern((String)this.fullyQualifiedTypeName));
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitIdentifier(J.Identifier ident, ExecutionContext executionContext) {
                if (ident.getType() != null && this.getCursor().firstEnclosing(J.Import.class) == null && this.getCursor().firstEnclosing(J.FieldAccess.class) == null && !(this.getCursor().getParentOrThrow().getValue() instanceof J.ParameterizedType)) {
                    JavaType.FullyQualified type = TypeUtils.asFullyQualified(ident.getType());
                    if (FindTypes.typeMatches(Boolean.TRUE.equals(FindTypes.this.checkAssignability), fullyQualifiedType, type) && ident.getSimpleName().equals(type.getClassName())) {
                        return (J)SearchResult.found((Tree)ident);
                    }
                }
                return super.visitIdentifier(ident, executionContext);
            }

            @Override
            public <N extends NameTree> N visitTypeName(N name, ExecutionContext ctx) {
                N n = super.visitTypeName(name, ctx);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(n.getType());
                if (FindTypes.typeMatches(Boolean.TRUE.equals(FindTypes.this.checkAssignability), fullyQualifiedType, type) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                    return (N)((NameTree)SearchResult.found(n));
                }
                return n;
            }

            @Override
            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                J.FieldAccess fa = (J.FieldAccess)super.visitFieldAccess(fieldAccess, ctx);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(fa.getTarget().getType());
                if (FindTypes.typeMatches(Boolean.TRUE.equals(FindTypes.this.checkAssignability), fullyQualifiedType, type) && fa.getName().getSimpleName().equals("class")) {
                    return (J)SearchResult.found((Tree)fa);
                }
                return fa;
            }
        };
    }

    public static Set<NameTree> findAssignable(J j, String fullyQualifiedClassName) {
        return FindTypes.find(true, j, fullyQualifiedClassName);
    }

    public static Set<NameTree> find(J j, String fullyQualifiedClassName) {
        return FindTypes.find(false, j, fullyQualifiedClassName);
    }

    private static Set<NameTree> find(final boolean checkAssignability, J j, String fullyQualifiedClassName) {
        final Pattern fullyQualifiedType = Pattern.compile(StringUtils.aspectjNameToPattern((String)fullyQualifiedClassName));
        JavaIsoVisitor<Set<NameTree>> findVisitor = new JavaIsoVisitor<Set<NameTree>>(){

            @Override
            public J.Identifier visitIdentifier(J.Identifier ident, Set<NameTree> ns) {
                JavaType.FullyQualified type;
                if (ident.getType() != null && FindTypes.typeMatches(checkAssignability, fullyQualifiedType, type = TypeUtils.asFullyQualified(ident.getType())) && ident.getSimpleName().equals(type.getClassName())) {
                    ns.add(ident);
                }
                return super.visitIdentifier(ident, ns);
            }

            @Override
            public <N extends NameTree> N visitTypeName(N name, Set<NameTree> ns) {
                N n = super.visitTypeName(name, ns);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(n.getType());
                if (FindTypes.typeMatches(checkAssignability, fullyQualifiedType, type) && this.getCursor().firstEnclosing(J.Import.class) == null) {
                    ns.add(name);
                }
                return n;
            }

            @Override
            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, Set<NameTree> ns) {
                J fa = super.visitFieldAccess(fieldAccess, ns);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(((J.FieldAccess)fa).getTarget().getType());
                if (FindTypes.typeMatches(checkAssignability, fullyQualifiedType, type) && ((J.FieldAccess)fa).getName().getSimpleName().equals("class")) {
                    ns.add(fieldAccess);
                }
                return fa;
            }
        };
        HashSet<NameTree> ts = new HashSet<NameTree>();
        findVisitor.visit(j, ts);
        return ts;
    }

    private static boolean typeMatches(boolean checkAssignability, Pattern pattern, @Nullable JavaType.FullyQualified test) {
        return test != null && (checkAssignability ? test.isAssignableFrom(pattern) : pattern.matcher(test.getFullyQualifiedName()).matches());
    }

    public FindTypes(String fullyQualifiedTypeName, @Nullable Boolean checkAssignability) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
        this.checkAssignability = checkAssignability;
    }

    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @Nullable
    public Boolean getCheckAssignability() {
        return this.checkAssignability;
    }

    @NonNull
    public String toString() {
        return "FindTypes(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ", checkAssignability=" + this.getCheckAssignability() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTypes)) {
            return false;
        }
        FindTypes other = (FindTypes)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$checkAssignability = this.getCheckAssignability();
        Boolean other$checkAssignability = other.getCheckAssignability();
        if (this$checkAssignability == null ? other$checkAssignability != null : !((Object)this$checkAssignability).equals(other$checkAssignability)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        return !(this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindTypes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $checkAssignability = this.getCheckAssignability();
        result = result * 59 + ($checkAssignability == null ? 43 : ((Object)$checkAssignability).hashCode());
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        return result;
    }
}

