/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.xerial.snappy.Snappy;

public class JavaTypeCache
implements Cloneable {
    Map<BytesKey, Object> typeCache = new HashMap<BytesKey, Object>();

    @Nullable
    public <T> T get(String signature) {
        return (T)this.typeCache.get(this.key(signature));
    }

    public void put(String signature, Object o) {
        this.typeCache.put(this.key(signature), o);
    }

    private BytesKey key(String signature) {
        try {
            return new BytesKey(Snappy.compress((String)signature));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void clear() {
        this.typeCache.clear();
    }

    public int size() {
        return this.typeCache.size();
    }

    public JavaTypeCache clone() {
        try {
            JavaTypeCache clone = (JavaTypeCache)super.clone();
            clone.typeCache = new HashMap<BytesKey, Object>(this.typeCache);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class BytesKey {
        private final byte[] data;

        public BytesKey(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BytesKey)) {
                return false;
            }
            BytesKey other = (BytesKey)o;
            return Arrays.equals(this.getData(), other.getData());
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getData());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaTypeCache.BytesKey(data=" + Arrays.toString(this.getData()) + ")";
        }
    }
}

