/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Autodetect
extends NamedStyles {
    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.java.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Autodetect detect(List<? extends JavaSourceFile> cus) {
        Builder builder = Autodetect.builder();
        for (JavaSourceFile javaSourceFile : cus) {
            builder.phase1(javaSourceFile);
        }
        for (JavaSourceFile javaSourceFile : cus) {
            builder.phase2(javaSourceFile);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final IndentStatistics indentStatistics = new IndentStatistics();
        private final ImportLayoutStatistics importLayoutStatistics = new ImportLayoutStatistics();
        private final SpacesStatistics spacesStatistics = new SpacesStatistics();
        private final GeneralFormatStatistics generalFormatStatistics = new GeneralFormatStatistics();
        private final NavigableSet<String> importedPackages = new TreeSet<String>();

        public void phase1(JavaSourceFile cu) {
            for (J.Import anImport : cu.getImports()) {
                this.importedPackages.add(anImport.getPackageName() + ".");
            }
            this.importLayoutStatistics.mapBlockPatterns(this.importedPackages);
        }

        public JavaSourceFile phase2(JavaSourceFile cu) {
            cu = (JavaSourceFile)new FindIndentJavaVisitor().visitNonNull(cu, this.indentStatistics);
            cu = (JavaSourceFile)new FindImportLayout().visitNonNull(cu, this.importLayoutStatistics);
            cu = (JavaSourceFile)new FindSpacesStyle().visitNonNull(cu, this.spacesStatistics);
            cu = (JavaSourceFile)new FindLineFormatJavaVisitor().visitNonNull(cu, this.generalFormatStatistics);
            return cu;
        }

        public Recipe asRecipe() {
            return new Recipe(){

                public String getDisplayName() {
                    return "Autodetect";
                }

                protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
                    for (SourceFile sourceFile : before) {
                        if (!(sourceFile instanceof J.CompilationUnit)) continue;
                        this.phase1((JavaSourceFile)sourceFile);
                    }
                    return before;
                }

                protected JavaVisitor<ExecutionContext> getVisitor() {
                    return new JavaVisitor<ExecutionContext>(){

                        @Override
                        public J visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                            return this.phase2(cu);
                        }
                    };
                }
            };
        }

        public Autodetect build() {
            return new Autodetect(Tree.randomId(), Arrays.asList(this.indentStatistics.getTabsAndIndentsStyle(), this.importLayoutStatistics.getImportLayoutStyle(), this.spacesStatistics.getSpacesStyle(), this.generalFormatStatistics.getFormatStyle()));
        }
    }

    private static class FindSpacesStyle
    extends JavaIsoVisitor<SpacesStatistics> {
        private FindSpacesStyle() {
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, SpacesStatistics stats) {
            stats.afterTypeCast += this.hasSpace(typeCast.getExpression().getPrefix());
            return super.visitTypeCast(typeCast, stats);
        }

        @Override
        public J.Try.Catch visitCatch(J.Try.Catch _catch, SpacesStatistics stats) {
            stats.beforeCatch += this.hasSpace(_catch.getParameter().getPrefix());
            return super.visitCatch(_catch, stats);
        }

        @Override
        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, SpacesStatistics stats) {
            stats.beforeWhile += this.hasSpace(doWhileLoop.getWhileCondition().getPrefix());
            return super.visitDoWhileLoop(doWhileLoop, stats);
        }

        @Override
        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, SpacesStatistics stats) {
            stats.beforeFor += this.hasSpace(forLoop.getControl().getPrefix());
            stats.beforeColonInForEach += this.hasSpace(forLoop.getControl().getPadding().getVariable().getAfter());
            return super.visitForEachLoop(forLoop, stats);
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop, SpacesStatistics stats) {
            stats.beforeFor += this.hasSpace(forLoop.getControl().getPrefix());
            stats.beforeForSemiColon += this.hasSpace(forLoop.getControl().getPadding().getInit().get(forLoop.getControl().getInit().size() - 1).getAfter());
            stats.beforeForSemiColon += this.hasSpace(forLoop.getControl().getPadding().getCondition().getAfter());
            stats.afterForSemiColon += this.hasSpace(forLoop.getControl().getInit().get(forLoop.getControl().getInit().size() - 1).getPrefix());
            stats.afterForSemiColon += this.hasSpace(forLoop.getControl().getCondition().getPrefix());
            return super.visitForLoop(forLoop, stats);
        }

        @Override
        public J.If visitIf(J.If iff, SpacesStatistics stats) {
            stats.beforeIf += this.hasSpace(iff.getIfCondition().getPrefix());
            return super.visitIf(iff, stats);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, SpacesStatistics stats) {
            stats.beforeMethodDeclaration += this.hasSpace(method.getPadding().getParameters().getBefore());
            return super.visitMethodDeclaration(method, stats);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, SpacesStatistics stats) {
            stats.beforeMethodCall += this.hasSpace(method.getPadding().getArguments().getBefore());
            if (method.getArguments().size() > 1) {
                for (JRightPadded<Expression> elem : method.getPadding().getArguments().getPadding().getElements()) {
                    stats.beforeComma += this.hasSpace(elem.getAfter());
                }
                for (Expression e : method.getArguments()) {
                    stats.afterComma += this.hasSpace(e.getPrefix());
                }
            }
            return super.visitMethodInvocation(method, stats);
        }

        @Override
        public J.NewArray visitNewArray(J.NewArray newArray, SpacesStatistics stats) {
            JContainer<Expression> initializer = newArray.getPadding().getInitializer();
            if (newArray.getInitializer() != null && initializer != null && initializer.getElements().size() > 0) {
                for (JRightPadded<Expression> elem : initializer.getPadding().getElements()) {
                    stats.beforeComma += this.hasSpace(elem.getAfter());
                }
                for (Expression e : newArray.getInitializer()) {
                    stats.afterComma += this.hasSpace(e.getPrefix());
                }
            }
            return super.visitNewArray(newArray, stats);
        }

        @Override
        public J.Switch visitSwitch(J.Switch _switch, SpacesStatistics stats) {
            stats.beforeSwitch += this.hasSpace(_switch.getSelector().getPrefix());
            return super.visitSwitch(_switch, stats);
        }

        @Override
        public J.Synchronized visitSynchronized(J.Synchronized _sync, SpacesStatistics stats) {
            stats.beforeSynchronized += this.hasSpace(_sync.getLock().getPrefix());
            return super.visitSynchronized(_sync, stats);
        }

        @Override
        public J.Try visitTry(J.Try _try, SpacesStatistics stats) {
            if (_try.getPadding().getResources() != null) {
                stats.beforeTry += this.hasSpace(_try.getPadding().getResources().getBefore());
            }
            return super.visitTry(_try, stats);
        }

        @Override
        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, SpacesStatistics stats) {
            stats.beforeWhile += this.hasSpace(whileLoop.getCondition().getPrefix());
            return super.visitWhileLoop(whileLoop, stats);
        }

        private int hasSpace(Space space) {
            return space.getWhitespace().contains(" ") ? 1 : -1;
        }
    }

    private static class SpacesStatistics {
        int beforeIf = 1;
        int beforeMethodCall = 0;
        int beforeMethodDeclaration = 0;
        int beforeFor = 1;
        int beforeWhile = 1;
        int beforeSwitch = 1;
        int beforeTry = 1;
        int beforeCatch = 1;
        int beforeSynchronized = 1;
        int beforeComma = 0;
        int afterComma = 1;
        int beforeColonInForEach = 1;
        int beforeForSemiColon = 0;
        int afterForSemiColon = 0;
        int afterTypeCast = 0;

        private SpacesStatistics() {
        }

        public SpacesStyle getSpacesStyle() {
            SpacesStyle spaces = IntelliJ.spaces();
            return spaces.withBeforeParentheses(new SpacesStyle.BeforeParentheses(this.beforeMethodDeclaration > 0, this.beforeMethodCall > 0, this.beforeIf > 0, this.beforeFor > 0 || this.beforeWhile > 0, this.beforeWhile > 0 || this.beforeFor > 0, this.beforeSwitch > 0, this.beforeTry > 0 || this.beforeCatch > 0, this.beforeTry > 0 || this.beforeCatch > 0, this.beforeSynchronized > 0, false)).withOther(new SpacesStyle.Other(this.beforeComma > 0, this.afterComma >= 1, this.beforeForSemiColon > 0, this.afterForSemiColon >= 0, this.afterTypeCast > 0, this.beforeColonInForEach > 0, false));
        }
    }

    private static class FindImportLayout
    extends JavaIsoVisitor<ImportLayoutStatistics> {
        private FindImportLayout() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ImportLayoutStatistics importLayoutStatistics) {
            LinkedHashSet<ImportLayoutStatistics.Block> blocks = new LinkedHashSet<ImportLayoutStatistics.Block>();
            importLayoutStatistics.staticAtBotCount = importLayoutStatistics.staticAtBotCount + (cu.getImports().size() > 0 && cu.getImports().get(cu.getImports().size() - 1).isStatic() ? 1 : 0);
            importLayoutStatistics.staticAtTopCount = importLayoutStatistics.staticAtTopCount + (cu.getImports().size() > 0 && cu.getImports().get(0).isStatic() ? 1 : 0);
            boolean staticBlock = false;
            int blockStart = 0;
            int i = 0;
            String previousPkg = "";
            int previousPkgCount = 1;
            int javaPos = Integer.MAX_VALUE;
            int javaxPos = Integer.MAX_VALUE;
            HashMap<ImportLayoutStatistics.Block, Integer> referenceCount = new HashMap<ImportLayoutStatistics.Block, Integer>();
            for (J.Import anImport : cu.getImports()) {
                boolean containsNewLine;
                previousPkgCount += previousPkg.equals(importLayoutStatistics.pkgToBlockPattern.get(anImport.getPackageName() + ".")) ? 1 : 0;
                boolean bl = containsNewLine = anImport.getPrefix().getWhitespace().contains("\n\n") || anImport.getPrefix().getWhitespace().contains("\r\n\r\n");
                if (containsNewLine || i > 0 && importLayoutStatistics.pkgToBlockPattern.containsKey(anImport.getPackageName() + ".") && !previousPkg.equals(importLayoutStatistics.pkgToBlockPattern.get(anImport.getPackageName() + "."))) {
                    if (i - blockStart > 0) {
                        ImportLayoutStatistics.Block block = new ImportLayoutStatistics.Block(staticBlock ? ImportLayoutStatistics.BlockType.ImportStatic : ImportLayoutStatistics.BlockType.Import, previousPkg, containsNewLine);
                        javaPos = "java.*".equals(block.pattern) && javaPos > blockStart ? blockStart : javaPos;
                        int n = javaxPos = "javax.*".equals(block.pattern) && javaxPos > blockStart ? blockStart : javaxPos;
                        if (blocks.contains(block) && previousPkgCount > (Integer)referenceCount.get(block)) {
                            blocks.remove(block);
                        }
                        blocks.add(block);
                        referenceCount.put(block, previousPkgCount + 1);
                        previousPkgCount = 1;
                    }
                    blockStart = i;
                }
                if (anImport.getQualid().getSimpleName().equals("*")) {
                    JavaType.FullyQualified fq;
                    if (anImport.isStatic()) {
                        int count = 0;
                        for (JavaType.Variable variable : cu.getTypesInUse().getVariables()) {
                            fq = TypeUtils.asFullyQualified(variable.getType());
                            if (fq == null || !anImport.getTypeName().equals(fq.getFullyQualifiedName())) continue;
                            ++count;
                        }
                        importLayoutStatistics.minimumFoldedStaticImports = Math.min(importLayoutStatistics.minimumFoldedStaticImports, count);
                    } else {
                        HashSet<String> fqns = new HashSet<String>();
                        for (JavaType type : cu.getTypesInUse().getTypesInUse()) {
                            if (!(type instanceof JavaType.FullyQualified)) continue;
                            fq = (JavaType.FullyQualified)type;
                            if (!anImport.getPackageName().equals(fq.getPackageName())) continue;
                            fqns.add(fq.getFullyQualifiedName());
                        }
                        importLayoutStatistics.minimumFoldedImports = Math.min(importLayoutStatistics.minimumFoldedImports, fqns.size());
                    }
                }
                staticBlock = anImport.isStatic();
                ++i;
                previousPkg = importLayoutStatistics.pkgToBlockPattern.get(anImport.getPackageName() + ".");
            }
            if (i - blockStart > 0) {
                ImportLayoutStatistics.Block block = new ImportLayoutStatistics.Block(staticBlock ? ImportLayoutStatistics.BlockType.ImportStatic : ImportLayoutStatistics.BlockType.Import, previousPkg, false);
                if (blocks.contains(block) && previousPkgCount > (Integer)referenceCount.get(block)) {
                    blocks.remove(block);
                }
                javaPos = "java.*".equals(block.pattern) ? blockStart : javaPos;
                javaxPos = "javax.*".equals(block.pattern) ? blockStart : javaxPos;
                blocks.add(block);
            }
            if (javaPos != Integer.MAX_VALUE && javaxPos != Integer.MAX_VALUE) {
                importLayoutStatistics.javaBeforeJavaxCount = importLayoutStatistics.javaBeforeJavaxCount + (javaPos < javaxPos ? 1 : 0);
                importLayoutStatistics.javaxBeforeJavaCount = importLayoutStatistics.javaxBeforeJavaCount + (javaxPos < javaPos ? 1 : 0);
            }
            importLayoutStatistics.blocksPerSourceFile.add(new ArrayList(blocks));
            return cu;
        }
    }

    private static class ImportLayoutStatistics {
        List<List<Block>> blocksPerSourceFile = new ArrayList<List<Block>>();
        Map<String, String> pkgToBlockPattern = new LinkedHashMap<String, String>();
        int staticAtTopCount = 0;
        int staticAtBotCount = 0;
        int javaBeforeJavaxCount = 0;
        int javaxBeforeJavaCount = 0;
        int minimumFoldedImports = Integer.MAX_VALUE;
        int minimumFoldedStaticImports = Integer.MAX_VALUE;

        private ImportLayoutStatistics() {
        }

        public boolean isStaticImportsAtBot() {
            return this.staticAtBotCount >= this.staticAtTopCount;
        }

        public boolean isJavaxBeforeJava() {
            return this.javaxBeforeJavaCount >= this.javaBeforeJavaxCount;
        }

        public ImportLayoutStyle getImportLayoutStyle() {
            return this.blocksPerSourceFile.stream().max(Comparator.comparing(List::size).thenComparing(blocks -> blocks.stream().filter(b -> "all other imports".equals(((Block)b).pattern)).count())).map(longestBlocks -> {
                Block block;
                int i;
                ImportLayoutStyle.Builder builder = ImportLayoutStyle.builder();
                boolean insertAllOthers = false;
                boolean insertStaticAllOthers = false;
                boolean containsJava = false;
                boolean containsJavax = false;
                int insertAllOtherAtIndex = 0;
                int insertStaticAllOtherAtIndex = 0;
                int nonStaticMaxCount = Integer.MIN_VALUE;
                int staticMaxCount = Integer.MIN_VALUE;
                int nonStaticCountPos = 0;
                int staticCountPos = 0;
                int nonStaticPos = 0;
                int staticPos = 0;
                ArrayList<Block> nonStaticBlocks = new ArrayList<Block>();
                ArrayList<Block> staticBlocks = new ArrayList<Block>();
                ArrayList<Integer> countOfBlocksInNonStaticGroups = new ArrayList<Integer>();
                ArrayList<Integer> countOfBlocksInStaticGroups = new ArrayList<Integer>();
                for (Block block2 : longestBlocks) {
                    if (BlockType.ImportStatic.equals((Object)block2.type)) {
                        staticBlocks.add(block2);
                        countOfBlocksInStaticGroups.add(0);
                        countOfBlocksInStaticGroups.set(staticCountPos, (Integer)countOfBlocksInStaticGroups.get(staticCountPos) + 1);
                        if (staticMaxCount < (Integer)countOfBlocksInStaticGroups.get(staticCountPos)) {
                            staticMaxCount = (Integer)countOfBlocksInStaticGroups.get(staticCountPos);
                            insertStaticAllOtherAtIndex = staticCountPos;
                            insertStaticAllOthers = true;
                        }
                        if (block2.addBlankLine) {
                            staticCountPos = staticPos + 1;
                        }
                        ++staticPos;
                        continue;
                    }
                    if (!containsJava && "java.*".equals(block2.pattern)) {
                        containsJava = true;
                    }
                    if (!containsJavax && "javax.*".equals(block2.pattern)) {
                        containsJavax = true;
                    }
                    nonStaticBlocks.add(block2);
                    countOfBlocksInNonStaticGroups.add(0);
                    countOfBlocksInNonStaticGroups.set(nonStaticCountPos, (Integer)countOfBlocksInNonStaticGroups.get(nonStaticCountPos) + 1);
                    if (nonStaticMaxCount < (Integer)countOfBlocksInNonStaticGroups.get(nonStaticCountPos)) {
                        nonStaticMaxCount = (Integer)countOfBlocksInNonStaticGroups.get(nonStaticCountPos);
                        insertAllOtherAtIndex = nonStaticCountPos;
                        insertAllOthers = true;
                    }
                    if (block2.addBlankLine) {
                        nonStaticCountPos = nonStaticPos + 1;
                    }
                    ++nonStaticPos;
                }
                boolean addNewLine = false;
                if (!this.isStaticImportsAtBot()) {
                    if (!insertStaticAllOthers) {
                        builder = builder.importStaticAllOthers();
                    }
                    for (int i2 = 0; i2 < staticBlocks.size(); ++i2) {
                        if (insertStaticAllOthers) {
                            if (i2 == insertStaticAllOtherAtIndex) {
                                builder = builder.importStaticAllOthers();
                                addNewLine = true;
                                continue;
                            }
                            if ((Integer)countOfBlocksInStaticGroups.get(i2) == 0) continue;
                            insertStaticAllOthers = false;
                        }
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        Block block3 = (Block)staticBlocks.get(i2);
                        builder.staticImportPackage(block3.pattern);
                        if (!block3.addBlankLine || i2 == staticBlocks.size() - 1) continue;
                        builder = builder.blankLine();
                    }
                }
                boolean bl = addNewLine = !this.isStaticImportsAtBot();
                if (!insertAllOthers) {
                    if (addNewLine) {
                        builder = builder.blankLine();
                    }
                    builder = builder.importAllOthers();
                    if (!containsJava && !containsJavax) {
                        builder = builder.blankLine();
                        if (this.isJavaxBeforeJava()) {
                            builder = builder.importPackage("javax.*");
                            builder = builder.importPackage("java.*");
                        } else {
                            builder = builder.importPackage("java.*");
                            builder = builder.importPackage("javax.*");
                        }
                    }
                    addNewLine = true;
                }
                boolean addJavaOrJavax = true;
                for (i = 0; i < nonStaticBlocks.size(); ++i) {
                    if (insertAllOthers) {
                        if (i == insertAllOtherAtIndex) {
                            if (addNewLine) {
                                builder = builder.blankLine();
                                addNewLine = false;
                            }
                            builder = builder.importAllOthers();
                            if (containsJava || containsJavax) continue;
                            builder = builder.blankLine();
                            if (this.isJavaxBeforeJava()) {
                                builder = builder.importPackage("javax.*");
                                builder = builder.importPackage("java.*");
                                continue;
                            }
                            builder = builder.importPackage("java.*");
                            builder = builder.importPackage("javax.*");
                            continue;
                        }
                        if (i > insertAllOtherAtIndex) {
                            if ((Integer)countOfBlocksInNonStaticGroups.get(i) == 0) continue;
                            insertAllOthers = false;
                            addNewLine = true;
                        }
                    }
                    block = (Block)nonStaticBlocks.get(i);
                    if (addJavaOrJavax && "java.*".equals(block.pattern)) {
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        if (!(i - 1 >= 0 && "javax.*".equals(((Block)nonStaticBlocks.get(i - 1)).pattern) || i + 1 < nonStaticBlocks.size() && "javax.*".equals(((Block)nonStaticBlocks.get(i + 1)).pattern))) {
                            if (this.isJavaxBeforeJava()) {
                                builder = builder.importPackage("javax.*");
                                builder = builder.importPackage("java.*");
                            } else {
                                builder = builder.importPackage("java.*");
                                builder = builder.importPackage("javax.*");
                            }
                            addNewLine = true;
                            addJavaOrJavax = false;
                        } else {
                            builder = builder.importPackage(block.pattern);
                        }
                    } else if (addJavaOrJavax && "javax.*".equals(block.pattern)) {
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        if (!(i - 1 >= 0 && "java.*".equals(((Block)nonStaticBlocks.get(i - 1)).pattern) || i + 1 < nonStaticBlocks.size() - 1 && "java.*".equals(((Block)nonStaticBlocks.get(i + 1)).pattern))) {
                            if (this.isJavaxBeforeJava()) {
                                builder = builder.importPackage("javax.*");
                                builder = builder.importPackage("java.*");
                            } else {
                                builder = builder.importPackage("java.*");
                                builder = builder.importPackage("javax.*");
                            }
                            addNewLine = true;
                            addJavaOrJavax = false;
                        } else {
                            builder = builder.importPackage(block.pattern);
                        }
                    } else {
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        builder = builder.importPackage(block.pattern);
                    }
                    if (!block.addBlankLine || i == nonStaticBlocks.size() - 1) continue;
                    builder = builder.blankLine();
                }
                if (this.isStaticImportsAtBot()) {
                    builder = builder.blankLine();
                    addNewLine = false;
                    if (!insertStaticAllOthers) {
                        builder = builder.importStaticAllOthers();
                    }
                    for (i = 0; i < staticBlocks.size(); ++i) {
                        if (insertStaticAllOthers) {
                            if (i == insertStaticAllOtherAtIndex) {
                                builder = builder.importStaticAllOthers();
                                continue;
                            }
                            if (i > insertStaticAllOtherAtIndex) {
                                if ((Integer)countOfBlocksInStaticGroups.get(i) == 0) continue;
                                insertStaticAllOthers = false;
                                addNewLine = true;
                            }
                        }
                        block = (Block)staticBlocks.get(i);
                        if (addNewLine || i > 0 && ((Block)staticBlocks.get(i - 1)).addBlankLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        builder = builder.staticImportPackage(block.pattern);
                    }
                }
                if (longestBlocks.isEmpty()) {
                    builder.importAllOthers();
                    builder.blankLine();
                    if (this.isJavaxBeforeJava()) {
                        builder = builder.importPackage("javax.*");
                        builder = builder.importPackage("java.*");
                    } else {
                        builder = builder.importPackage("java.*");
                        builder = builder.importPackage("javax.*");
                    }
                    builder.blankLine();
                    builder.importStaticAllOthers();
                }
                builder.classCountToUseStarImport(Math.max(this.minimumFoldedImports, 5));
                builder.nameCountToUseStarImport(Math.max(this.minimumFoldedStaticImports, 3));
                return builder.build();
            }).orElse(IntelliJ.importLayout());
        }

        public void mapBlockPatterns(NavigableSet<String> importedPackages) {
            String longestCommonPrefix = null;
            String prevLCP = null;
            ArrayList<String> prevPackages = new ArrayList<String>();
            for (String pkg : importedPackages) {
                longestCommonPrefix = this.longestCommonPrefix(pkg, longestCommonPrefix);
                if (!prevPackages.isEmpty() && longestCommonPrefix.chars().filter(c -> c == 46).count() <= 1L && !StringUtils.isNullOrEmpty((String)prevLCP)) {
                    for (String prev : prevPackages) {
                        if (prevLCP.startsWith("java.")) {
                            prevLCP = "java.";
                        } else if (prevLCP.startsWith("javax.")) {
                            prevLCP = "javax.";
                        }
                        this.pkgToBlockPattern.put(prev, prevLCP + "*");
                    }
                    longestCommonPrefix = pkg;
                    prevPackages.clear();
                }
                prevPackages.add(pkg);
                prevLCP = longestCommonPrefix;
            }
            for (String prev : prevPackages) {
                this.pkgToBlockPattern.put(prev, prevLCP + "*");
            }
        }

        private String longestCommonPrefix(String pkg, @Nullable String lcp) {
            int i;
            if (lcp == null) {
                return pkg;
            }
            char[] p1 = pkg.toCharArray();
            char[] p2 = lcp.toCharArray();
            for (i = 0; i < p1.length && i < p2.length && p1[i] == p2[i]; ++i) {
            }
            return lcp.substring(0, i);
        }

        static class Block {
            private final BlockType type;
            private final String pattern;
            private final boolean addBlankLine;

            Block(BlockType type, String pattern, boolean addBlankLine) {
                this.type = type;
                this.pattern = pattern;
                this.addBlankLine = addBlankLine;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Block)) {
                    return false;
                }
                Block other = (Block)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.addBlankLine != other.addBlankLine) {
                    return false;
                }
                BlockType this$type = this.type;
                BlockType other$type = other.type;
                if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                    return false;
                }
                String this$pattern = this.pattern;
                String other$pattern = other.pattern;
                return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
            }

            protected boolean canEqual(@Nullable Object other) {
                return other instanceof Block;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.addBlankLine ? 79 : 97);
                BlockType $type = this.type;
                result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
                String $pattern = this.pattern;
                result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
                return result;
            }
        }

        static enum BlockType {
            Import,
            ImportStatic;

        }
    }

    private static class FindIndentJavaVisitor
    extends JavaIsoVisitor<IndentStatistics> {
        private FindIndentJavaVisitor() {
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, IndentStatistics stats) {
            if (method.getParameters().size() > 1) {
                int alignTo;
                if (method.getParameters().get(0).getPrefix().getLastWhitespace().contains("\n")) {
                    alignTo = method.getParameters().get(0).getPrefix().getLastWhitespace().length() - 1;
                } else {
                    String source = method.print(this.getCursor());
                    alignTo = source.indexOf(method.getParameters().get(0).print(this.getCursor())) - 1;
                }
                List<Statement> parameters = method.getParameters();
                for (int i = 1; i < parameters.size(); ++i) {
                    if (!parameters.get(i).getPrefix().getLastWhitespace().contains("\n")) continue;
                    if (alignTo == parameters.get(i).getPrefix().getLastWhitespace().length()) {
                        stats.multilineAlignedToFirstArgument++;
                        continue;
                    }
                    stats.multilineNotAlignedToFirstArgument++;
                }
            }
            return super.visitMethodDeclaration(method, stats);
        }

        @Override
        public Space visitSpace(Space space, Space.Location loc, IndentStatistics stats) {
            Integer lastIndent = (Integer)this.getCursor().getNearestMessage("lastIndent");
            if (lastIndent == null) {
                lastIndent = 0;
            }
            String prefix = space.getWhitespace();
            char[] chars = prefix.toCharArray();
            int indent = 0;
            for (char c2 : chars) {
                if (c2 == '\n' || c2 == '\r') {
                    indent = 0;
                    continue;
                }
                if (!Character.isWhitespace(c2)) continue;
                ++indent;
            }
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            if (prefix.chars().filter(c -> {
                takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
                return takeWhile.get();
            }).count() > 0L) {
                stats.indentFrequencies.merge(indent - lastIndent, 1L, Long::sum);
                this.getCursor().putMessage("lastIndent", (Object)indent);
                AtomicBoolean dropWhile = new AtomicBoolean(false);
                takeWhile.set(true);
                Map indentTypeCounts = prefix.chars().filter(c -> {
                    dropWhile.set(dropWhile.get() || c != 10 && c != 13);
                    return dropWhile.get();
                }).filter(c -> {
                    takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                    return takeWhile.get();
                }).mapToObj(c -> c == 32).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                if (!indentTypeCounts.isEmpty()) {
                    if (indentTypeCounts.getOrDefault(true, 0L) >= indentTypeCounts.getOrDefault(false, 0L)) {
                        stats.linesWithSpaceIndents++;
                    } else {
                        stats.linesWithTabIndents++;
                    }
                }
            }
            return space;
        }
    }

    private static class FindLineFormatJavaVisitor
    extends JavaIsoVisitor<GeneralFormatStatistics> {
        private FindLineFormatJavaVisitor() {
        }

        @Override
        public Space visitSpace(Space space, Space.Location loc, GeneralFormatStatistics stats) {
            String prefix = space.getWhitespace();
            char[] chars = prefix.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c != '\n' && c != '\r' || c != '\n') continue;
                if (i == 0 || chars[i - 1] != '\r') {
                    stats.linesWithLFNewLines++;
                    continue;
                }
                stats.linesWithCRLFNewLines++;
            }
            return space;
        }
    }

    private static class IndentStatistics {
        private final Map<Integer, Long> indentFrequencies = new HashMap<Integer, Long>();
        private int linesWithSpaceIndents = 0;
        private int linesWithTabIndents = 0;
        private int multilineAlignedToFirstArgument = 0;
        private int multilineNotAlignedToFirstArgument = 0;

        private IndentStatistics() {
        }

        public boolean isIndentedWithSpaces() {
            return this.linesWithSpaceIndents >= this.linesWithTabIndents;
        }

        public TabsAndIndentsStyle getTabsAndIndentsStyle() {
            boolean useTabs = !this.isIndentedWithSpaces();
            Map.Entry<Integer, Long> i1 = null;
            Map.Entry<Integer, Long> i2 = null;
            for (Map.Entry<Integer, Long> sample : this.indentFrequencies.entrySet()) {
                if (sample.getKey() == 0) continue;
                if (i1 == null || (Long)i1.getValue() < sample.getValue()) {
                    i1 = sample;
                    continue;
                }
                if (i2 != null && (Long)i2.getValue() >= sample.getValue()) continue;
                i2 = sample;
            }
            int indent1 = i1 == null ? 4 : (Integer)i1.getKey();
            int indent2 = i2 == null ? indent1 : (Integer)i2.getKey();
            int indent = Math.min(indent1, indent2);
            int continuationIndent = Math.max(indent1, indent2);
            return new TabsAndIndentsStyle(useTabs, useTabs ? indent : 1, useTabs ? 1 : indent, continuationIndent, false, new TabsAndIndentsStyle.MethodDeclarationParameters(this.multilineAlignedToFirstArgument >= this.multilineNotAlignedToFirstArgument));
        }
    }

    private static class GeneralFormatStatistics {
        private int linesWithCRLFNewLines = 0;
        private int linesWithLFNewLines = 0;

        private GeneralFormatStatistics() {
        }

        public boolean isIndentedWithLFNewLines() {
            return this.linesWithLFNewLines >= this.linesWithCRLFNewLines;
        }

        public GeneralFormatStyle getFormatStyle() {
            boolean useCRLF = !this.isIndentedWithLFNewLines();
            return new GeneralFormatStyle(useCRLF);
        }
    }
}

