/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.text.PlainTextParser;

@Incubating(since="7.20.0")
public class PotentiallyDeadCode
extends Recipe {
    public String getDisplayName() {
        return "List potentially dead code by declared method";
    }

    public String getDescription() {
        return "Method definitions that are defined in this project and aren't used.";
    }

    protected List<SourceFile> visit(List<SourceFile> before, ExecutionContext ctx) {
        HashSet declared = new HashSet();
        HashSet<JavaType.Method> used = new HashSet<JavaType.Method>();
        GitProvenance gitProvenance = null;
        for (SourceFile sourceFile : before) {
            if (!(sourceFile instanceof JavaSourceFile)) continue;
            gitProvenance = sourceFile.getMarkers().findFirst(GitProvenance.class).orElse(gitProvenance);
            JavaSourceFile cu = (JavaSourceFile)sourceFile;
            declared.addAll(cu.getTypesInUse().getDeclaredMethods().stream().filter(m -> !m.hasFlags(Flag.Private) && !m.hasFlags(Flag.Protected)).filter(m -> {
                for (JavaType.FullyQualified ann : m.getAnnotations()) {
                    if (!ann.getFullyQualifiedName().equals("java.lang.Override")) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList()));
            used.addAll(cu.getTypesInUse().getUsedMethods());
        }
        HashSet<JavaType.Method> unused = new HashSet<JavaType.Method>(declared);
        unused.removeAll(used);
        declared.retainAll(used);
        String sourcePath = "methods" + (gitProvenance == null ? "" : "-" + gitProvenance.getRepositoryName()) + ".csv";
        return ListUtils.concatAll((List)ListUtils.concatAll(before, this.listMethods(unused, "unused-" + sourcePath)), this.listMethods(used, "used-" + sourcePath));
    }

    private List<SourceFile> listMethods(Set<JavaType.Method> methods, String sourcePath) {
        return new PlainTextParser().parse(new String[]{methods.stream().sorted(Comparator.comparing(JavaType.Method::toString)).map(d -> d.getDeclaringType().getFullyQualifiedName() + "," + d.getName() + "(" + d.getParameterTypes().stream().map(pt -> pt == null ? "<unknown>" : (pt instanceof JavaType.FullyQualified ? ((JavaType.FullyQualified)pt).getFullyQualifiedName() : pt.toString())).collect(Collectors.joining(",")) + ")").collect(Collectors.joining("\n", "declaring type,method\n", "\n"))}).stream().map(pt -> pt.withSourcePath(Paths.get(sourcePath, new String[0]))).collect(Collectors.toList());
    }
}

