/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dataflow.FindLocalFlowPaths;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.dataflow.LocalTaintFlowSpec;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class FindMethods
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.util.List add(..)")
    private final String methodPattern;
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean matchOverrides;
    @Option(displayName="Show flow", description="When enabled, show the data or taint flow of the method invocation.", valid={"none", "data", "taint"}, required=false)
    @Nullable
    private final String flow;

    public String getDisplayName() {
        return "Find method usages";
    }

    public String getDescription() {
        return "Find method usages by pattern.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(this.methodPattern, this.matchOverrides);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern, this.matchOverrides);
        final boolean flowEnabled = !StringUtils.isBlank((String)this.flow) && !"none".equals(this.flow);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (methodMatcher.matches(method)) {
                    if (!flowEnabled) {
                        m = ((J.MethodInvocation)m).withMarkers(((J.MethodInvocation)m).getMarkers().searchResult());
                    } else {
                        this.doAfterVisit(new FindLocalFlowPaths(this.getFlowSpec(method)));
                    }
                }
                return m;
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                J m = super.visitMemberReference(memberRef, ctx);
                if (methodMatcher.matches(((J.MemberReference)m).getMethodType())) {
                    if (!flowEnabled) {
                        m = ((J.MemberReference)m).withReference(((J.MemberReference)m).getReference().withMarkers(((J.MemberReference)m).getReference().getMarkers().searchResult()));
                    } else {
                        this.doAfterVisit(new FindLocalFlowPaths(this.getFlowSpec(memberRef)));
                    }
                }
                return m;
            }

            @Override
            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J n = super.visitNewClass(newClass, ctx);
                if (methodMatcher.matches(newClass)) {
                    if (!flowEnabled) {
                        n = ((J.NewClass)n).withMarkers(((J.NewClass)n).getMarkers().searchResult());
                    } else {
                        this.doAfterVisit(new FindLocalFlowPaths(this.getFlowSpec(newClass)));
                    }
                }
                return n;
            }

            private LocalFlowSpec<Expression, Expression> getFlowSpec(final Expression source) {
                switch (FindMethods.this.flow) {
                    case "data": {
                        return new LocalFlowSpec<Expression, Expression>(){

                            @Override
                            public boolean isSource(Expression expression, Cursor cursor) {
                                return expression == source;
                            }

                            @Override
                            public boolean isSink(Expression expression, Cursor cursor) {
                                return true;
                            }
                        };
                    }
                    case "taint": {
                        return new LocalTaintFlowSpec<Expression, Expression>(){

                            @Override
                            public boolean isSource(Expression expression, Cursor cursor) {
                                return expression == source;
                            }

                            @Override
                            public boolean isSink(Expression expression, Cursor cursor) {
                                return true;
                            }
                        };
                    }
                }
                throw new IllegalStateException("Unknown flow: " + FindMethods.this.flow);
            }
        };
    }

    public static Set<J> find(J j, String methodPattern) {
        final MethodMatcher methodMatcher = new MethodMatcher(methodPattern);
        JavaIsoVisitor<Set<J>> findVisitor = new JavaIsoVisitor<Set<J>>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Set<J> ms) {
                if (methodMatcher.matches(method)) {
                    ms.add(method);
                }
                return super.visitMethodInvocation(method, ms);
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, Set<J> ms) {
                if (methodMatcher.matches(memberRef.getMethodType())) {
                    ms.add(memberRef);
                }
                return super.visitMemberReference(memberRef, ms);
            }
        };
        HashSet<J> ms = new HashSet<J>();
        findVisitor.visit(j, ms);
        return ms;
    }

    public FindMethods(String methodPattern, @Nullable Boolean matchOverrides, @Nullable String flow) {
        this.methodPattern = methodPattern;
        this.matchOverrides = matchOverrides;
        this.flow = flow;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Nullable
    public Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @Nullable
    public String getFlow() {
        return this.flow;
    }

    @NonNull
    public String toString() {
        return "FindMethods(methodPattern=" + this.getMethodPattern() + ", matchOverrides=" + this.getMatchOverrides() + ", flow=" + this.getFlow() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMethods)) {
            return false;
        }
        FindMethods other = (FindMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        return !(this$flow == null ? other$flow != null : !this$flow.equals(other$flow));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindMethods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        return result;
    }
}

