/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

public class SpacesVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final SpacesStyle style;
    @Nullable
    private final EmptyForInitializerPadStyle emptyForInitializerPadStyle;
    @Nullable
    private final EmptyForIteratorPadStyle emptyForIteratorPadStyle;

    public SpacesVisitor(SpacesStyle style, @Nullable EmptyForInitializerPadStyle emptyForInitializerPadStyle, @Nullable EmptyForIteratorPadStyle emptyForIteratorPadStyle) {
        this(style, emptyForInitializerPadStyle, emptyForIteratorPadStyle, null);
    }

    public SpacesVisitor(SpacesStyle style, @Nullable EmptyForInitializerPadStyle emptyForInitializerPadStyle, @Nullable EmptyForIteratorPadStyle emptyForIteratorPadStyle, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
        this.emptyForInitializerPadStyle = emptyForInitializerPadStyle;
        this.emptyForIteratorPadStyle = emptyForIteratorPadStyle;
    }

    <T extends J> T spaceBefore(T j, boolean spaceBefore) {
        if (spaceBefore && StringUtils.isNullOrEmpty((String)j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(" "));
        }
        if (!spaceBefore && " ".equals(j.getPrefix().getWhitespace()) && j.getComments().isEmpty()) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(""));
        }
        return j;
    }

    <T> JContainer<T> spaceBefore(JContainer<T> container, boolean spaceBefore) {
        if (spaceBefore && StringUtils.isNullOrEmpty((String)container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(" "));
        }
        if (!spaceBefore && " ".equals(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(""));
        }
        return container;
    }

    <T extends J> JLeftPadded<T> spaceBefore(JLeftPadded<T> container, boolean spaceBefore) {
        if (spaceBefore && StringUtils.isNullOrEmpty((String)container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(" "));
        }
        if (!spaceBefore && container.getBefore().getWhitespace().equals(" ")) {
            return container.withBefore(container.getBefore().withWhitespace(""));
        }
        return container;
    }

    <T extends J> JLeftPadded<T> spaceBeforeLeftPaddedElement(JLeftPadded<T> container, boolean spaceBefore) {
        return container.withElement(this.spaceBefore((J)container.getElement(), spaceBefore));
    }

    <T extends J> JRightPadded<T> spaceBeforeRightPaddedElement(JRightPadded<T> container, boolean spaceBefore) {
        return container.withElement(this.spaceBefore((J)container.getElement(), spaceBefore));
    }

    <T extends J> JRightPadded<T> spaceAfter(JRightPadded<T> container, boolean spaceAfter) {
        if (spaceAfter && StringUtils.isNullOrEmpty((String)container.getAfter().getWhitespace())) {
            return container.withAfter(container.getAfter().withWhitespace(" "));
        }
        if (!spaceAfter && container.getAfter().getWhitespace().equals(" ") && container.getAfter().getComments().isEmpty()) {
            return container.withAfter(container.getAfter().withWhitespace(""));
        }
        return container;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J c = super.visitClassDeclaration(classDecl, (Object)p);
        if (((J.ClassDeclaration)c).getBody() != null && ((J.ClassDeclaration)(c = ((J.ClassDeclaration)c).withBody(this.spaceBefore(((J.ClassDeclaration)c).getBody(), (boolean)this.style.getBeforeLeftBrace().getClassLeftBrace())))).getBody().getStatements().isEmpty()) {
            if (((J.ClassDeclaration)c).getKind() != J.ClassDeclaration.Kind.Type.Enum) {
                boolean withinCodeBraces = this.style.getWithin().getCodeBraces();
                if (withinCodeBraces && StringUtils.isNullOrEmpty((String)((J.ClassDeclaration)c).getBody().getEnd().getWhitespace())) {
                    c = ((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withEnd(((J.ClassDeclaration)c).getBody().getEnd().withWhitespace(" ")));
                } else if (!withinCodeBraces && ((J.ClassDeclaration)c).getBody().getEnd().getWhitespace().equals(" ")) {
                    c = ((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withEnd(((J.ClassDeclaration)c).getBody().getEnd().withWhitespace("")));
                }
            } else {
                boolean spaceInsideOneLineEnumBraces = this.style.getOther().getInsideOneLineEnumBraces();
                if (spaceInsideOneLineEnumBraces && StringUtils.isNullOrEmpty((String)((J.ClassDeclaration)c).getBody().getEnd().getWhitespace())) {
                    c = ((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withEnd(((J.ClassDeclaration)c).getBody().getEnd().withWhitespace(" ")));
                } else if (!spaceInsideOneLineEnumBraces && ((J.ClassDeclaration)c).getBody().getEnd().getWhitespace().equals(" ")) {
                    c = ((J.ClassDeclaration)c).withBody(((J.ClassDeclaration)c).getBody().withEnd(((J.ClassDeclaration)c).getBody().getEnd().withWhitespace("")));
                }
            }
        }
        if (((J.ClassDeclaration)c).getPadding().getTypeParameters() != null) {
            c = ((J.ClassDeclaration)c).getPadding().withTypeParameters(this.spaceBefore(((J.ClassDeclaration)c).getPadding().getTypeParameters(), (boolean)this.style.getTypeParameters().getBeforeOpeningAngleBracket()));
        }
        if (((J.ClassDeclaration)c).getPadding().getTypeParameters() != null) {
            boolean spaceWithinAngleBrackets = this.style.getWithin().getAngleBrackets();
            int typeParametersSize = ((J.ClassDeclaration)c).getPadding().getTypeParameters().getElements().size();
            c = ((J.ClassDeclaration)c).getPadding().withTypeParameters(((J.ClassDeclaration)c).getPadding().getTypeParameters().getPadding().withElements(ListUtils.map(((J.ClassDeclaration)c).getPadding().getTypeParameters().getPadding().getElements(), (index, elemContainer) -> {
                elemContainer = index == 0 ? elemContainer.withElement(this.spaceBefore((J.TypeParameter)elemContainer.getElement(), spaceWithinAngleBrackets)) : elemContainer.withElement(this.spaceBefore((J.TypeParameter)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                if (index == typeParametersSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, spaceWithinAngleBrackets);
                }
                return elemContainer;
            })));
        }
        return c;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J m = super.visitMethodDeclaration(method, (Object)p);
        if (((J.MethodDeclaration)(m = ((J.MethodDeclaration)m).getPadding().withParameters(this.spaceBefore(((J.MethodDeclaration)m).getPadding().getParameters(), (boolean)this.style.getBeforeParentheses().getMethodDeclaration())))).getBody() != null) {
            m = ((J.MethodDeclaration)m).withBody(this.spaceBefore(((J.MethodDeclaration)m).getBody(), (boolean)this.style.getBeforeLeftBrace().getMethodLeftBrace()));
        }
        if (((J.MethodDeclaration)m).getParameters().isEmpty() || ((J.MethodDeclaration)m).getParameters().iterator().next() instanceof J.Empty) {
            boolean useSpace = this.style.getWithin().getEmptyMethodDeclarationParentheses();
            m = ((J.MethodDeclaration)m).getPadding().withParameters(((J.MethodDeclaration)m).getPadding().getParameters().getPadding().withElements(ListUtils.map(((J.MethodDeclaration)m).getPadding().getParameters().getPadding().getElements(), param -> param.withElement(this.spaceBefore((Statement)param.getElement(), useSpace)))));
        } else {
            int paramsSize = ((J.MethodDeclaration)m).getParameters().size();
            boolean useSpace = this.style.getWithin().getMethodDeclarationParentheses();
            m = ((J.MethodDeclaration)m).getPadding().withParameters(((J.MethodDeclaration)m).getPadding().getParameters().getPadding().withElements(ListUtils.map(((J.MethodDeclaration)m).getPadding().getParameters().getPadding().getElements(), (index, param) -> {
                param = index == 0 ? param.withElement(this.spaceBefore((Statement)param.getElement(), useSpace)) : param.withElement(this.spaceBefore((Statement)param.getElement(), (boolean)this.style.getOther().getAfterComma()));
                param = index == paramsSize - 1 ? this.spaceAfter((JRightPadded)param, useSpace) : this.spaceAfter((JRightPadded)param, this.style.getOther().getBeforeComma());
                return param;
            })));
        }
        if (((J.MethodDeclaration)m).getAnnotations().getTypeParameters() != null) {
            boolean spaceWithinAngleBrackets = this.style.getWithin().getAngleBrackets();
            int typeParametersSize = ((J.MethodDeclaration)m).getAnnotations().getTypeParameters().getTypeParameters().size();
            m = ((J.MethodDeclaration)m).getAnnotations().withTypeParameters(((J.MethodDeclaration)m).getAnnotations().getTypeParameters().getPadding().withTypeParameters(ListUtils.map(((J.MethodDeclaration)m).getAnnotations().getTypeParameters().getPadding().getTypeParameters(), (index, elemContainer) -> {
                elemContainer = index == 0 ? elemContainer.withElement(this.spaceBefore((J.TypeParameter)elemContainer.getElement(), spaceWithinAngleBrackets)) : elemContainer.withElement(this.spaceBefore((J.TypeParameter)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                if (index == typeParametersSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, spaceWithinAngleBrackets);
                }
                return elemContainer;
            })));
        }
        return m;
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        J m = super.visitMethodInvocation(method, (Object)p);
        if (((J.MethodInvocation)(m = ((J.MethodInvocation)m).getPadding().withArguments(this.spaceBefore(((J.MethodInvocation)m).getPadding().getArguments(), (boolean)this.style.getBeforeParentheses().getMethodCall())))).getArguments().isEmpty() || ((J.MethodInvocation)m).getArguments().iterator().next() instanceof J.Empty) {
            boolean useSpace = this.style.getWithin().getEmptyMethodCallParentheses();
            m = ((J.MethodInvocation)m).getPadding().withArguments(((J.MethodInvocation)m).getPadding().getArguments().getPadding().withElements(ListUtils.map(((J.MethodInvocation)m).getPadding().getArguments().getPadding().getElements(), arg -> arg.withElement(this.spaceBefore((Expression)arg.getElement(), useSpace)))));
        } else {
            int argsSize = ((J.MethodInvocation)m).getArguments().size();
            boolean useSpace = this.style.getWithin().getMethodCallParentheses();
            m = ((J.MethodInvocation)m).getPadding().withArguments(((J.MethodInvocation)m).getPadding().getArguments().getPadding().withElements(ListUtils.map(((J.MethodInvocation)m).getPadding().getArguments().getPadding().getElements(), (index, arg) -> {
                arg = index == 0 ? arg.withElement(this.spaceBefore((Expression)arg.getElement(), useSpace)) : arg.withElement(this.spaceBefore((Expression)arg.getElement(), (boolean)this.style.getOther().getAfterComma()));
                arg = index == argsSize - 1 ? this.spaceAfter((JRightPadded)arg, useSpace) : this.spaceAfter((JRightPadded)arg, this.style.getOther().getBeforeComma());
                return arg;
            })));
        }
        if (((J.MethodInvocation)m).getPadding().getTypeParameters() != null) {
            m = ((J.MethodInvocation)m).getPadding().withTypeParameters(this.spaceBefore(((J.MethodInvocation)m).getPadding().getTypeParameters(), (boolean)this.style.getTypeArguments().getBeforeOpeningAngleBracket()));
            m = ((J.MethodInvocation)m).withName(this.spaceBefore(((J.MethodInvocation)m).getName(), (boolean)this.style.getTypeArguments().getAfterClosingAngleBracket()));
        }
        if (((J.MethodInvocation)m).getPadding().getTypeParameters() != null) {
            m = ((J.MethodInvocation)m).getPadding().withTypeParameters(((J.MethodInvocation)m).getPadding().getTypeParameters().getPadding().withElements(ListUtils.map(((J.MethodInvocation)m).getPadding().getTypeParameters().getPadding().getElements(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement(this.spaceBefore((Expression)elemContainer.getElement(), (boolean)this.style.getTypeArguments().getAfterComma()));
                }
                return elemContainer;
            })));
        }
        return m;
    }

    @Override
    public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, P p) {
        J mc = super.visitMultiCatch(multiCatch, (Object)p);
        int argsSize = ((J.MultiCatch)mc).getAlternatives().size();
        mc = ((J.MultiCatch)mc).getPadding().withAlternatives(ListUtils.map(((J.MultiCatch)mc).getPadding().getAlternatives(), (index, arg) -> {
            if (index > 0) {
                arg = arg.withElement(this.spaceBefore((NameTree)arg.getElement(), (boolean)this.style.getAroundOperators().getBitwise()));
            }
            if (index != argsSize - 1) {
                arg = this.spaceAfter((JRightPadded)arg, this.style.getAroundOperators().getBitwise());
            }
            return arg;
        }));
        return mc;
    }

    @Override
    public J.If visitIf(J.If iff, P p) {
        J i = super.visitIf(iff, (Object)p);
        i = ((J.If)i).withIfCondition(this.spaceBefore(((J.If)i).getIfCondition(), (boolean)this.style.getBeforeParentheses().getIfParentheses()));
        i = ((J.If)i).getPadding().withThenPart(this.spaceBeforeRightPaddedElement(((J.If)i).getPadding().getThenPart(), this.style.getBeforeLeftBrace().getIfLeftBrace()));
        boolean useSpaceWithinIfParentheses = this.style.getWithin().getIfParentheses();
        i = ((J.If)i).withIfCondition(((J.If)i).getIfCondition().getPadding().withTree(this.spaceAfter(((J.If)i).getIfCondition().getPadding().getTree().withElement(this.spaceBefore(((J.If)i).getIfCondition().getPadding().getTree().getElement(), useSpaceWithinIfParentheses)), useSpaceWithinIfParentheses)));
        return i;
    }

    @Override
    public J.If.Else visitElse(J.If.Else elze, P p) {
        J e = super.visitElse(elze, (Object)p);
        e = ((J.If.Else)e).getPadding().withBody(this.spaceBeforeRightPaddedElement(((J.If.Else)e).getPadding().getBody(), this.style.getBeforeLeftBrace().getElseLeftBrace()));
        e = (J.If.Else)this.spaceBefore(e, (boolean)this.style.getBeforeKeywords().getElseKeyword());
        return e;
    }

    @Override
    public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
        J f = super.visitForLoop(forLoop, (Object)p);
        J.ForLoop.Control control = ((J.ForLoop)f).getControl();
        control = this.spaceBefore(control, (boolean)this.style.getBeforeParentheses().getForParentheses());
        Boolean padEmptyForInitializer = null;
        if (this.emptyForInitializerPadStyle != null) {
            padEmptyForInitializer = this.emptyForInitializerPadStyle.getSpace();
        }
        boolean spaceWithinForParens = this.style.getWithin().getForParentheses();
        boolean shouldPutSpaceOnInit = padEmptyForInitializer != null && ((J.ForLoop)f).getControl().getInit().get(0) instanceof J.Empty ? padEmptyForInitializer : spaceWithinForParens;
        control = control.withInit(ListUtils.mapFirst(((J.ForLoop)f).getControl().getInit(), i -> this.spaceBefore(i, shouldPutSpaceOnInit)));
        boolean spaceBeforeSemicolon = this.style.getOther().getBeforeForSemicolon();
        boolean spaceAfterSemicolon = this.style.getOther().getAfterForSemicolon();
        control = control.getPadding().withInit(ListUtils.mapFirst(control.getPadding().getInit(), i -> this.spaceAfter((JRightPadded)i, spaceBeforeSemicolon)));
        control = control.getPadding().withCondition(this.spaceAfter(control.getPadding().getCondition(), spaceBeforeSemicolon));
        control = control.getPadding().withCondition(control.getPadding().getCondition().withElement(this.spaceBefore(control.getPadding().getCondition().getElement(), spaceAfterSemicolon)));
        int updateStatementsSize = ((J.ForLoop)f).getControl().getUpdate().size();
        Boolean padEmptyForIterator = this.emptyForIteratorPadStyle == null ? null : this.emptyForIteratorPadStyle.getSpace();
        control = padEmptyForIterator != null && updateStatementsSize == 1 && ((J.ForLoop)f).getControl().getUpdate().get(0) instanceof J.Empty ? control.getPadding().withUpdate(ListUtils.map(control.getPadding().getUpdate(), (index, elemContainer) -> {
            elemContainer = elemContainer.withElement(this.spaceBefore((Statement)elemContainer.getElement(), (boolean)padEmptyForIterator));
            return elemContainer;
        })) : control.getPadding().withUpdate(ListUtils.map(control.getPadding().getUpdate(), (index, elemContainer) -> {
            elemContainer = index == 0 ? elemContainer.withElement(this.spaceBefore((Statement)elemContainer.getElement(), spaceAfterSemicolon)) : elemContainer.withElement(this.spaceBefore((Statement)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
            elemContainer = index == updateStatementsSize - 1 ? this.spaceAfter((JRightPadded)elemContainer, spaceWithinForParens) : this.spaceAfter((JRightPadded)elemContainer, this.style.getOther().getBeforeComma());
            return elemContainer;
        }));
        f = ((J.ForLoop)f).withControl(control);
        f = ((J.ForLoop)f).getPadding().withBody(this.spaceBeforeRightPaddedElement(((J.ForLoop)f).getPadding().getBody(), this.style.getBeforeLeftBrace().getForLeftBrace()));
        return f;
    }

    @Override
    public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, P p) {
        J f = super.visitForEachLoop(forLoop, (Object)p);
        f = ((J.ForEachLoop)f).withControl(this.spaceBefore(((J.ForEachLoop)f).getControl(), (boolean)this.style.getBeforeParentheses().getForParentheses()));
        f = ((J.ForEachLoop)f).getPadding().withBody(this.spaceBeforeRightPaddedElement(((J.ForEachLoop)f).getPadding().getBody(), this.style.getBeforeLeftBrace().getForLeftBrace()));
        boolean spaceWithinForParens = this.style.getWithin().getForParentheses();
        f = ((J.ForEachLoop)f).withControl(((J.ForEachLoop)f).getControl().withVariable(this.spaceBefore(((J.ForEachLoop)f).getControl().getVariable(), spaceWithinForParens)));
        f = ((J.ForEachLoop)f).withControl(((J.ForEachLoop)f).getControl().getPadding().withIterable(this.spaceAfter(((J.ForEachLoop)f).getControl().getPadding().getIterable(), spaceWithinForParens)));
        f = ((J.ForEachLoop)f).withControl(((J.ForEachLoop)f).getControl().getPadding().withVariable(this.spaceAfter(((J.ForEachLoop)f).getControl().getPadding().getVariable(), this.style.getOther().getBeforeColonInForEach())));
        return f;
    }

    @Override
    public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
        J w = super.visitWhileLoop(whileLoop, (Object)p);
        w = ((J.WhileLoop)w).withCondition(this.spaceBefore(((J.WhileLoop)w).getCondition(), (boolean)this.style.getBeforeParentheses().getWhileParentheses()));
        w = ((J.WhileLoop)w).getPadding().withBody(this.spaceBeforeRightPaddedElement(((J.WhileLoop)w).getPadding().getBody(), this.style.getBeforeLeftBrace().getWhileLeftBrace()));
        boolean spaceWithinWhileParens = this.style.getWithin().getWhileParentheses();
        w = ((J.WhileLoop)w).withCondition(((J.WhileLoop)w).getCondition().withTree(this.spaceBefore(((J.WhileLoop)w).getCondition().getTree(), spaceWithinWhileParens)));
        w = ((J.WhileLoop)w).withCondition(((J.WhileLoop)w).getCondition().getPadding().withTree(this.spaceAfter(((J.WhileLoop)w).getCondition().getPadding().getTree(), spaceWithinWhileParens)));
        return w;
    }

    @Override
    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J d = super.visitDoWhileLoop(doWhileLoop, (Object)p);
        d = ((J.DoWhileLoop)d).getPadding().withWhileCondition(this.spaceBefore(((J.DoWhileLoop)d).getPadding().getWhileCondition(), (boolean)this.style.getBeforeKeywords().getWhileKeyword()));
        d = ((J.DoWhileLoop)d).getPadding().withWhileCondition(this.spaceBeforeLeftPaddedElement(((J.DoWhileLoop)d).getPadding().getWhileCondition(), this.style.getBeforeParentheses().getWhileParentheses()));
        d = ((J.DoWhileLoop)d).getPadding().withBody(this.spaceBeforeRightPaddedElement(((J.DoWhileLoop)d).getPadding().getBody(), this.style.getBeforeLeftBrace().getDoLeftBrace()));
        boolean spaceWithinWhileParens = this.style.getWithin().getWhileParentheses();
        d = ((J.DoWhileLoop)d).withWhileCondition(((J.DoWhileLoop)d).getWhileCondition().withTree(this.spaceBefore(((J.DoWhileLoop)d).getWhileCondition().getTree(), spaceWithinWhileParens)));
        d = ((J.DoWhileLoop)d).withWhileCondition(((J.DoWhileLoop)d).getWhileCondition().getPadding().withTree(this.spaceAfter(((J.DoWhileLoop)d).getWhileCondition().getPadding().getTree(), spaceWithinWhileParens)));
        return d;
    }

    @Override
    public J.Switch visitSwitch(J.Switch _switch, P p) {
        J s = super.visitSwitch(_switch, (Object)p);
        s = ((J.Switch)s).withSelector(this.spaceBefore(((J.Switch)s).getSelector(), (boolean)this.style.getBeforeParentheses().getSwitchParentheses()));
        s = ((J.Switch)s).withCases(this.spaceBefore(((J.Switch)s).getCases(), (boolean)this.style.getBeforeLeftBrace().getSwitchLeftBrace()));
        boolean spaceWithinSwitchParens = this.style.getWithin().getSwitchParentheses();
        s = ((J.Switch)s).withSelector(((J.Switch)s).getSelector().withTree(this.spaceBefore(((J.Switch)s).getSelector().getTree(), spaceWithinSwitchParens)));
        s = ((J.Switch)s).withSelector(((J.Switch)s).getSelector().getPadding().withTree(this.spaceAfter(((J.Switch)s).getSelector().getPadding().getTree(), spaceWithinSwitchParens)));
        return s;
    }

    @Override
    public J.Try visitTry(J.Try _try, P p) {
        J t = super.visitTry(_try, (Object)p);
        if (((J.Try)t).getPadding().getResources() != null) {
            t = ((J.Try)t).getPadding().withResources(this.spaceBefore(((J.Try)t).getPadding().getResources(), (boolean)this.style.getBeforeParentheses().getTryParentheses()));
        }
        if (((J.Try)(t = ((J.Try)t).withBody(this.spaceBefore(((J.Try)t).getBody(), (boolean)this.style.getBeforeLeftBrace().getTryLeftBrace())))).getPadding().getFinally() != null) {
            JLeftPadded<J.Block> f = this.spaceBefore(((J.Try)t).getPadding().getFinally(), (boolean)this.style.getBeforeKeywords().getFinallyKeyword());
            f = this.spaceBeforeLeftPaddedElement(f, this.style.getBeforeLeftBrace().getFinallyLeftBrace());
            t = ((J.Try)t).getPadding().withFinally(f);
        }
        boolean spaceWithinTryParentheses = this.style.getWithin().getTryParentheses();
        if (((J.Try)t).getResources() != null) {
            t = ((J.Try)t).withResources(ListUtils.mapFirst(((J.Try)t).getResources(), res -> this.spaceBefore(res, spaceWithinTryParentheses)));
        }
        if (((J.Try)t).getPadding().getResources() != null) {
            t = ((J.Try)t).getPadding().withResources(((J.Try)t).getPadding().getResources().getPadding().withElements(ListUtils.mapLast(((J.Try)t).getPadding().getResources().getPadding().getElements(), res -> this.spaceAfter((JRightPadded)res, spaceWithinTryParentheses))));
        }
        return t;
    }

    @Override
    public J.Try.Catch visitCatch(J.Try.Catch _catch, P p) {
        J c = super.visitCatch(_catch, (Object)p);
        c = (J.Try.Catch)this.spaceBefore(c, (boolean)this.style.getBeforeKeywords().getCatchKeyword());
        c = ((J.Try.Catch)c).withParameter(this.spaceBefore(((J.Try.Catch)c).getParameter(), (boolean)this.style.getBeforeParentheses().getCatchParentheses()));
        c = ((J.Try.Catch)c).withBody(this.spaceBefore(((J.Try.Catch)c).getBody(), (boolean)this.style.getBeforeLeftBrace().getCatchLeftBrace()));
        boolean spaceWithinCatchParens = this.style.getWithin().getCatchParentheses();
        c = ((J.Try.Catch)c).withParameter(((J.Try.Catch)c).getParameter().withTree(this.spaceBefore(((J.Try.Catch)c).getParameter().getTree(), spaceWithinCatchParens)));
        c = ((J.Try.Catch)c).withParameter(((J.Try.Catch)c).getParameter().getPadding().withTree(this.spaceAfter(((J.Try.Catch)c).getParameter().getPadding().getTree(), spaceWithinCatchParens)));
        return c;
    }

    @Override
    public J.Synchronized visitSynchronized(J.Synchronized sync, P p) {
        J s = super.visitSynchronized(sync, (Object)p);
        s = ((J.Synchronized)s).withLock(this.spaceBefore(((J.Synchronized)s).getLock(), (boolean)this.style.getBeforeParentheses().getSynchronizedParentheses()));
        s = ((J.Synchronized)s).withBody(this.spaceBefore(((J.Synchronized)s).getBody(), (boolean)this.style.getBeforeLeftBrace().getSynchronizedLeftBrace()));
        boolean spaceWithinSynchronizedParens = this.style.getWithin().getSynchronizedParentheses();
        s = ((J.Synchronized)s).withLock(((J.Synchronized)s).getLock().withTree(this.spaceBefore(((J.Synchronized)s).getLock().getTree(), spaceWithinSynchronizedParens)));
        s = ((J.Synchronized)s).withLock(((J.Synchronized)s).getLock().getPadding().withTree(this.spaceAfter(((J.Synchronized)s).getLock().getPadding().getTree(), spaceWithinSynchronizedParens)));
        return s;
    }

    @Override
    public J.Annotation visitAnnotation(J.Annotation annotation, P p) {
        J a = super.visitAnnotation(annotation, (Object)p);
        if (((J.Annotation)a).getPadding().getArguments() != null) {
            a = ((J.Annotation)a).getPadding().withArguments(this.spaceBefore(((J.Annotation)a).getPadding().getArguments(), (boolean)this.style.getBeforeParentheses().getAnnotationParameters()));
        }
        boolean spaceWithinAnnotationParentheses = this.style.getWithin().getAnnotationParentheses();
        if (((J.Annotation)a).getPadding().getArguments() != null) {
            int argsSize = ((J.Annotation)a).getPadding().getArguments().getElements().size();
            a = ((J.Annotation)a).getPadding().withArguments(((J.Annotation)a).getPadding().getArguments().getPadding().withElements(ListUtils.map(((J.Annotation)a).getPadding().getArguments().getPadding().getElements(), (index, arg) -> {
                if (index == 0) {
                    if (spaceWithinAnnotationParentheses || !this.style.getBeforeLeftBrace().getAnnotationArrayInitializerLeftBrace().booleanValue()) {
                        arg = arg.withElement(this.spaceBefore((Expression)arg.getElement(), spaceWithinAnnotationParentheses));
                    }
                } else {
                    arg = arg.withElement(this.spaceBefore((Expression)arg.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                if (index == argsSize - 1) {
                    arg = this.spaceAfter((JRightPadded)arg, spaceWithinAnnotationParentheses);
                }
                return arg;
            })));
        }
        return a;
    }

    @Override
    public J.Assignment visitAssignment(J.Assignment assignment, P p) {
        J a = super.visitAssignment(assignment, (Object)p);
        a = ((J.Assignment)a).getPadding().withAssignment(this.spaceBefore(((J.Assignment)a).getPadding().getAssignment(), (boolean)this.style.getAroundOperators().getAssignment()));
        a = ((J.Assignment)a).getPadding().withAssignment(((J.Assignment)a).getPadding().getAssignment().withElement(this.spaceBefore(((J.Assignment)a).getPadding().getAssignment().getElement(), (boolean)this.style.getAroundOperators().getAssignment())));
        return a;
    }

    @Override
    public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, P p) {
        J a = super.visitAssignmentOperation(assignOp, (Object)p);
        J.AssignmentOperation.Padding padding = ((J.AssignmentOperation)a).getPadding();
        JLeftPadded<J.AssignmentOperation.Type> operator = padding.getOperator();
        String operatorBeforeWhitespace = operator.getBefore().getWhitespace();
        if (this.style.getAroundOperators().getAssignment().booleanValue() && StringUtils.isNullOrEmpty((String)operatorBeforeWhitespace)) {
            a = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace(" ")));
        } else if (!this.style.getAroundOperators().getAssignment().booleanValue() && " ".equals(operatorBeforeWhitespace)) {
            a = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace("")));
        }
        a = ((J.AssignmentOperation)a).withAssignment(this.spaceBefore(((J.AssignmentOperation)a).getAssignment(), (boolean)this.style.getAroundOperators().getAssignment()));
        return a;
    }

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J v = super.visitVariable(variable, (Object)p);
        if (((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer() != null) {
            v = ((J.VariableDeclarations.NamedVariable)v).getPadding().withInitializer(this.spaceBefore(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer(), (boolean)this.style.getAroundOperators().getAssignment()));
        }
        if (((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer() != null && ((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getElement() != null) {
            v = ((J.VariableDeclarations.NamedVariable)v).getPadding().withInitializer(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().withElement(this.spaceBefore(((J.VariableDeclarations.NamedVariable)v).getPadding().getInitializer().getElement(), (boolean)this.style.getAroundOperators().getAssignment())));
        }
        return v;
    }

    @Override
    public J.Binary visitBinary(J.Binary binary, P p) {
        J b = super.visitBinary(binary, (Object)p);
        J.Binary.Type operator = ((J.Binary)b).getOperator();
        switch (operator) {
            case And: 
            case Or: {
                b = this.applyBinarySpaceAround((J.Binary)b, this.style.getAroundOperators().getLogical());
                break;
            }
            case Equal: 
            case NotEqual: {
                b = this.applyBinarySpaceAround((J.Binary)b, this.style.getAroundOperators().getEquality());
                break;
            }
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: {
                b = this.applyBinarySpaceAround((J.Binary)b, this.style.getAroundOperators().getRelational());
                break;
            }
            case BitAnd: 
            case BitOr: 
            case BitXor: {
                b = this.applyBinarySpaceAround((J.Binary)b, this.style.getAroundOperators().getBitwise());
                break;
            }
            case Addition: 
            case Subtraction: {
                b = this.applyBinarySpaceAround((J.Binary)b, this.style.getAroundOperators().getAdditive());
                break;
            }
            case Multiplication: 
            case Division: 
            case Modulo: {
                b = this.applyBinarySpaceAround((J.Binary)b, this.style.getAroundOperators().getMultiplicative());
                break;
            }
            case LeftShift: 
            case RightShift: 
            case UnsignedRightShift: {
                b = this.applyBinarySpaceAround((J.Binary)b, this.style.getAroundOperators().getShift());
            }
        }
        return b;
    }

    private J.Binary applyBinarySpaceAround(J.Binary binary, boolean useSpaceAround) {
        J.Binary.Padding padding = binary.getPadding();
        JLeftPadded<J.Binary.Type> operator = padding.getOperator();
        if (useSpaceAround) {
            if (StringUtils.isNullOrEmpty((String)operator.getBefore().getWhitespace())) {
                binary = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace(" ")));
            }
            if (StringUtils.isNullOrEmpty((String)binary.getRight().getPrefix().getWhitespace())) {
                binary = binary.withRight((Expression)binary.getRight().withPrefix(binary.getRight().getPrefix().withWhitespace(" ")));
            }
        } else {
            if (operator.getBefore().getWhitespace().equals(" ")) {
                binary = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace("")));
            }
            if (binary.getRight().getPrefix().getWhitespace().equals(" ")) {
                binary = binary.withRight((Expression)binary.getRight().withPrefix(binary.getRight().getPrefix().withWhitespace("")));
            }
        }
        return binary;
    }

    @Override
    public J.Unary visitUnary(J.Unary unary, P p) {
        J u = super.visitUnary(unary, (Object)p);
        switch (((J.Unary)u).getOperator()) {
            case PostIncrement: 
            case PostDecrement: {
                u = this.applyUnaryOperatorBeforeSpace((J.Unary)u, this.style.getAroundOperators().getUnary());
                break;
            }
            case PreIncrement: 
            case PreDecrement: 
            case Negative: 
            case Positive: 
            case Not: 
            case Complement: {
                u = this.applyUnaryOperatorBeforeSpace((J.Unary)u, this.style.getAroundOperators().getUnary());
                u = this.applyUnaryOperatorExprSpace((J.Unary)u, this.style.getAroundOperators().getUnary());
            }
        }
        return u;
    }

    private J.Unary applyUnaryOperatorExprSpace(J.Unary unary, boolean useAroundUnaryOperatorSpace) {
        if (useAroundUnaryOperatorSpace && StringUtils.isNullOrEmpty((String)unary.getExpression().getPrefix().getWhitespace())) {
            unary = unary.withExpression((Expression)unary.getExpression().withPrefix(unary.getExpression().getPrefix().withWhitespace(" ")));
        } else if (!useAroundUnaryOperatorSpace && unary.getExpression().getPrefix().getWhitespace().equals(" ")) {
            unary = unary.withExpression((Expression)unary.getExpression().withPrefix(unary.getExpression().getPrefix().withWhitespace("")));
        }
        return unary;
    }

    private J.Unary applyUnaryOperatorBeforeSpace(J.Unary u, boolean useAroundUnaryOperatorSpace) {
        J.Unary.Padding padding = u.getPadding();
        JLeftPadded<J.Unary.Type> operator = padding.getOperator();
        if (useAroundUnaryOperatorSpace && StringUtils.isNullOrEmpty((String)operator.getBefore().getWhitespace())) {
            u = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace(" ")));
        } else if (!useAroundUnaryOperatorSpace && operator.getBefore().getWhitespace().equals(" ")) {
            u = padding.withOperator(operator.withBefore(operator.getBefore().withWhitespace("")));
        }
        return u;
    }

    @Override
    public J.Lambda visitLambda(J.Lambda lambda, P p) {
        J l = super.visitLambda(lambda, (Object)p);
        boolean useSpaceAroundLambdaArrow = this.style.getAroundOperators().getLambdaArrow();
        if (useSpaceAroundLambdaArrow && StringUtils.isNullOrEmpty((String)((J.Lambda)l).getArrow().getWhitespace())) {
            l = ((J.Lambda)l).withArrow(((J.Lambda)l).getArrow().withWhitespace(" "));
        } else if (!useSpaceAroundLambdaArrow && ((J.Lambda)l).getArrow().getWhitespace().equals(" ")) {
            l = ((J.Lambda)l).withArrow(((J.Lambda)l).getArrow().withWhitespace(""));
        }
        l = ((J.Lambda)l).withBody(this.spaceBefore(((J.Lambda)l).getBody(), (boolean)this.style.getAroundOperators().getLambdaArrow()));
        if (!((J.Lambda)l).getParameters().getParameters().isEmpty() && !(((J.Lambda)l).getParameters().getParameters().iterator().next() instanceof J.Empty)) {
            int parametersSize = ((J.Lambda)l).getParameters().getParameters().size();
            l = ((J.Lambda)l).withParameters(((J.Lambda)l).getParameters().getPadding().withParams(ListUtils.map(((J.Lambda)l).getParameters().getPadding().getParams(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement(this.spaceBefore((J)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                if (index != parametersSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, this.style.getOther().getBeforeComma());
                }
                return elemContainer;
            })));
        }
        return l;
    }

    @Override
    public J.MemberReference visitMemberReference(J.MemberReference memberRef, P p) {
        J m = super.visitMemberReference(memberRef, (Object)p);
        if (((J.MemberReference)(m = ((J.MemberReference)m).getPadding().withContaining(this.spaceAfter(((J.MemberReference)m).getPadding().getContaining(), this.style.getAroundOperators().getMethodReferenceDoubleColon())))).getPadding().getTypeParameters() != null) {
            ((J.MemberReference)m).getPadding().withTypeParameters(this.spaceBefore(((J.MemberReference)m).getPadding().getTypeParameters(), (boolean)this.style.getAroundOperators().getMethodReferenceDoubleColon()));
        } else {
            m = ((J.MemberReference)m).getPadding().withReference(this.spaceBefore(((J.MemberReference)m).getPadding().getReference(), (boolean)this.style.getAroundOperators().getMethodReferenceDoubleColon()));
        }
        return m;
    }

    @Override
    public J.NewArray visitNewArray(J.NewArray newArray, P p) {
        J n = super.visitNewArray(newArray, (Object)p);
        if (this.getCursor().getParent() != null && this.getCursor().getParent().firstEnclosing(J.class) instanceof J.Annotation) {
            if (!this.style.getWithin().getAnnotationParentheses().booleanValue()) {
                n = (J.NewArray)this.spaceBefore(n, (boolean)this.style.getBeforeLeftBrace().getAnnotationArrayInitializerLeftBrace());
            }
        } else if (((J.NewArray)n).getPadding().getInitializer() != null) {
            JContainer<Expression> initializer = this.spaceBefore(((J.NewArray)n).getPadding().getInitializer(), (boolean)this.style.getBeforeLeftBrace().getArrayInitializerLeftBrace());
            n = ((J.NewArray)n).getPadding().withInitializer(initializer);
        }
        if (((J.NewArray)n).getPadding().getInitializer() != null) {
            JContainer<Expression> i = ((J.NewArray)n).getPadding().getInitializer();
            if (this.style.getOther().getAfterComma().booleanValue()) {
                i = JContainer.withElements(i, ListUtils.map(i.getElements(), (idx, elem) -> idx == 0 ? elem : this.spaceBefore(elem, true)));
            }
            if (i.getElements().isEmpty() || i.getElements().iterator().next() instanceof J.Empty) {
                boolean useSpaceWithinEmptyArrayInitializerBraces = this.style.getWithin().getEmptyArrayInitializerBraces();
                i = i.map(expr -> this.spaceBefore(expr, useSpaceWithinEmptyArrayInitializerBraces));
            } else {
                boolean useSpaceWithinArrayInitializerBraces = this.style.getWithin().getArrayInitializerBraces();
                int initializerElementsSize = i.getElements().size();
                i = i.getPadding().withElements(ListUtils.map(i.getPadding().getElements(), (index, elemContainer) -> {
                    elemContainer = index == 0 ? elemContainer.withElement(this.spaceBefore((Expression)elemContainer.getElement(), useSpaceWithinArrayInitializerBraces)) : elemContainer.withElement(this.spaceBefore((Expression)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                    elemContainer = index == initializerElementsSize - 1 ? this.spaceAfter((JRightPadded)elemContainer, useSpaceWithinArrayInitializerBraces) : this.spaceAfter((JRightPadded)elemContainer, this.style.getOther().getBeforeComma());
                    return elemContainer;
                }));
            }
            n = ((J.NewArray)n).getPadding().withInitializer(i);
        }
        return n;
    }

    @Override
    public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        J a = super.visitArrayAccess(arrayAccess, (Object)p);
        boolean useSpaceWithinBrackets = this.style.getWithin().getBrackets();
        if (useSpaceWithinBrackets) {
            if (StringUtils.isNullOrEmpty((String)((J.ArrayAccess)a).getDimension().getPadding().getIndex().getElement().getPrefix().getWhitespace())) {
                a = ((J.ArrayAccess)a).withDimension(((J.ArrayAccess)a).getDimension().getPadding().withIndex(((J.ArrayAccess)a).getDimension().getPadding().getIndex().withElement((Expression)((J.ArrayAccess)a).getDimension().getPadding().getIndex().getElement().withPrefix(((J.ArrayAccess)a).getDimension().getPadding().getIndex().getElement().getPrefix().withWhitespace(" ")))));
            }
            if (StringUtils.isNullOrEmpty((String)((J.ArrayAccess)a).getDimension().getPadding().getIndex().getAfter().getWhitespace())) {
                a = ((J.ArrayAccess)a).withDimension(((J.ArrayAccess)a).getDimension().getPadding().withIndex(((J.ArrayAccess)a).getDimension().getPadding().getIndex().withAfter(((J.ArrayAccess)a).getDimension().getPadding().getIndex().getAfter().withWhitespace(" "))));
            }
        } else {
            if (((J.ArrayAccess)a).getDimension().getPadding().getIndex().getElement().getPrefix().getWhitespace().equals(" ")) {
                a = ((J.ArrayAccess)a).withDimension(((J.ArrayAccess)a).getDimension().getPadding().withIndex(((J.ArrayAccess)a).getDimension().getPadding().getIndex().withElement((Expression)((J.ArrayAccess)a).getDimension().getPadding().getIndex().getElement().withPrefix(((J.ArrayAccess)a).getDimension().getPadding().getIndex().getElement().getPrefix().withWhitespace("")))));
            }
            if (((J.ArrayAccess)a).getDimension().getPadding().getIndex().getAfter().getWhitespace().equals(" ")) {
                a = ((J.ArrayAccess)a).withDimension(((J.ArrayAccess)a).getDimension().getPadding().withIndex(((J.ArrayAccess)a).getDimension().getPadding().getIndex().withAfter(((J.ArrayAccess)a).getDimension().getPadding().getIndex().getAfter().withWhitespace(""))));
            }
        }
        return a;
    }

    @Override
    public <T extends J> J.Parentheses<T> visitParentheses(J.Parentheses<T> parens, P p) {
        J.Parentheses p2 = super.visitParentheses((J.Parentheses)parens, (Object)p);
        if (this.style.getWithin().getGroupingParentheses().booleanValue()) {
            if (StringUtils.isNullOrEmpty((String)((J)p2.getPadding().getTree().getElement()).getPrefix().getWhitespace())) {
                p2 = p2.getPadding().withTree(p2.getPadding().getTree().withElement(((J)p2.getPadding().getTree().getElement()).withPrefix(((J)p2.getPadding().getTree().getElement()).getPrefix().withWhitespace(" "))));
            }
            if (StringUtils.isNullOrEmpty((String)p2.getPadding().getTree().getAfter().getWhitespace())) {
                p2 = p2.getPadding().withTree(p2.getPadding().getTree().withAfter(p2.getPadding().getTree().getAfter().withWhitespace(" ")));
            }
        } else {
            if (((J)p2.getPadding().getTree().getElement()).getPrefix().getWhitespace().equals(" ")) {
                p2 = p2.getPadding().withTree(p2.getPadding().getTree().withElement(((J)p2.getPadding().getTree().getElement()).withPrefix(((J)p2.getPadding().getTree().getElement()).getPrefix().withWhitespace(""))));
            }
            if (p2.getPadding().getTree().getAfter().getWhitespace().equals(" ")) {
                p2 = p2.getPadding().withTree(p2.getPadding().getTree().withAfter(p2.getPadding().getTree().getAfter().withWhitespace("")));
            }
        }
        return p2;
    }

    @Override
    public J.TypeCast visitTypeCast(J.TypeCast typeCast, P p) {
        J tc = super.visitTypeCast(typeCast, (Object)p);
        boolean spaceWithinTypeCastParens = this.style.getWithin().getTypeCastParentheses();
        tc = ((J.TypeCast)tc).withClazz(((J.TypeCast)tc).getClazz().withTree(this.spaceBefore(((J.TypeCast)tc).getClazz().getTree(), spaceWithinTypeCastParens)));
        tc = ((J.TypeCast)tc).withClazz(((J.TypeCast)tc).getClazz().getPadding().withTree(this.spaceAfter(((J.TypeCast)tc).getClazz().getPadding().getTree(), spaceWithinTypeCastParens)));
        tc = ((J.TypeCast)tc).withExpression(this.spaceBefore(((J.TypeCast)tc).getExpression(), (boolean)this.style.getOther().getAfterTypeCast()));
        return tc;
    }

    @Override
    public J.ParameterizedType visitParameterizedType(J.ParameterizedType type, P p) {
        J pt = super.visitParameterizedType(type, (Object)p);
        boolean spaceWithinAngleBrackets = this.style.getWithin().getAngleBrackets();
        if (((J.ParameterizedType)pt).getPadding().getTypeParameters() != null) {
            pt = ((J.ParameterizedType)pt).getPadding().withTypeParameters(this.spaceBefore(((J.ParameterizedType)pt).getPadding().getTypeParameters(), (boolean)this.style.getTypeArguments().getBeforeOpeningAngleBracket()));
        }
        if (((J.ParameterizedType)pt).getPadding().getTypeParameters() != null && !((J.ParameterizedType)pt).getPadding().getTypeParameters().getElements().isEmpty() && !(((J.ParameterizedType)pt).getPadding().getTypeParameters().getElements().iterator().next() instanceof J.Empty)) {
            int typeParametersSize = ((J.ParameterizedType)pt).getPadding().getTypeParameters().getElements().size();
            pt = ((J.ParameterizedType)pt).getPadding().withTypeParameters(((J.ParameterizedType)pt).getPadding().getTypeParameters().getPadding().withElements(ListUtils.map(((J.ParameterizedType)pt).getPadding().getTypeParameters().getPadding().getElements(), (index, elemContainer) -> {
                elemContainer = index == 0 ? elemContainer.withElement(this.spaceBefore((Expression)elemContainer.getElement(), spaceWithinAngleBrackets)) : elemContainer.withElement(this.spaceBefore((Expression)elemContainer.getElement(), (boolean)this.style.getTypeArguments().getAfterComma()));
                if (index == typeParametersSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, spaceWithinAngleBrackets);
                }
                return elemContainer;
            })));
        }
        return pt;
    }

    @Override
    public J.Ternary visitTernary(J.Ternary ternary, P p) {
        J t = super.visitTernary(ternary, (Object)p);
        SpacesStyle.TernaryOperator ternaryOperatorSettings = this.style.getTernaryOperator();
        t = ((J.Ternary)t).getPadding().withTruePart(this.spaceBefore(((J.Ternary)t).getPadding().getTruePart(), (boolean)ternaryOperatorSettings.getBeforeQuestionMark()));
        t = ((J.Ternary)t).withTruePart(this.spaceBefore(((J.Ternary)t).getTruePart(), (boolean)ternaryOperatorSettings.getAfterQuestionMark()));
        t = ((J.Ternary)t).getPadding().withFalsePart(this.spaceBefore(((J.Ternary)t).getPadding().getFalsePart(), (boolean)ternaryOperatorSettings.getBeforeColon()));
        t = ((J.Ternary)t).withFalsePart(this.spaceBefore(((J.Ternary)t).getFalsePart(), (boolean)ternaryOperatorSettings.getAfterColon()));
        return t;
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        J nc = super.visitNewClass(newClass, (Object)p);
        if (((J.NewClass)nc).getPadding().getArguments() != null) {
            nc = ((J.NewClass)nc).getPadding().withArguments(this.spaceBefore(((J.NewClass)nc).getPadding().getArguments(), (boolean)this.style.getBeforeParentheses().getMethodCall()));
            int argsSize = ((J.NewClass)nc).getPadding().getArguments().getElements().size();
            nc = ((J.NewClass)nc).getPadding().withArguments(((J.NewClass)nc).getPadding().getArguments().getPadding().withElements(ListUtils.map(((J.NewClass)nc).getPadding().getArguments().getPadding().getElements(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement(this.spaceBefore((Expression)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                if (index != argsSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, this.style.getOther().getBeforeComma());
                }
                return elemContainer;
            })));
        }
        return nc;
    }

    @Override
    public J.EnumValue visitEnumValue(J.EnumValue _enum, P p) {
        J e = super.visitEnumValue(_enum, (Object)p);
        if (((J.EnumValue)e).getInitializer() != null && ((J.EnumValue)e).getInitializer().getPadding().getArguments() != null) {
            int initializerArgumentsSize = ((J.EnumValue)e).getInitializer().getPadding().getArguments().getPadding().getElements().size();
            e = ((J.EnumValue)e).withInitializer(((J.EnumValue)e).getInitializer().getPadding().withArguments(((J.EnumValue)e).getInitializer().getPadding().getArguments().getPadding().withElements(ListUtils.map(((J.EnumValue)e).getInitializer().getPadding().getArguments().getPadding().getElements(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement(this.spaceBefore((Expression)elemContainer.getElement(), (boolean)this.style.getOther().getAfterComma()));
                }
                if (index != initializerArgumentsSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, this.style.getOther().getBeforeComma());
                }
                return elemContainer;
            }))));
        }
        return e;
    }

    @Override
    public J.TypeParameter visitTypeParameter(J.TypeParameter typeParam, P p) {
        J tp = super.visitTypeParameter(typeParam, (Object)p);
        if (((J.TypeParameter)tp).getPadding().getBounds() != null) {
            boolean spaceAroundTypeBounds = this.style.getTypeParameters().getAroundTypeBounds();
            int typeBoundsSize = ((J.TypeParameter)tp).getPadding().getBounds().getPadding().getElements().size();
            tp = ((J.TypeParameter)tp).getPadding().withBounds(((J.TypeParameter)tp).getPadding().getBounds().getPadding().withElements(ListUtils.map(((J.TypeParameter)tp).getPadding().getBounds().getPadding().getElements(), (index, elemContainer) -> {
                if (index != 0) {
                    elemContainer = elemContainer.withElement(this.spaceBefore((TypeTree)elemContainer.getElement(), spaceAroundTypeBounds));
                }
                if (index != typeBoundsSize - 1) {
                    elemContainer = this.spaceAfter((JRightPadded)elemContainer, spaceAroundTypeBounds);
                }
                return elemContainer;
            })));
        }
        return tp;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

