/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.EmptyBlockVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.EmptyBlockStyle;
import org.openrewrite.java.tree.JavaSourceFile;

public class EmptyBlock
extends Recipe {
    public String getDisplayName() {
        return "Remove empty blocks";
    }

    public String getDescription() {
        return "Remove empty blocks that effectively do nothing.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-108");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new EmptyBlockFromCompilationUnitStyle();
    }

    private static class EmptyBlockFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private EmptyBlockFromCompilationUnitStyle() {
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            EmptyBlockStyle style = (EmptyBlockStyle)((SourceFile)cu).getStyle(EmptyBlockStyle.class);
            if (style == null) {
                style = Checkstyle.emptyBlock();
            }
            this.doAfterVisit(new EmptyBlockVisitor(style));
            return cu;
        }
    }
}

