/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Font;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Node;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrewrite.java.controlflow.ControlFlowNode;
import org.openrewrite.java.controlflow.ControlFlowSummary;

final class ControlFlowVisualizer {
    static String visualizeAsDotfile(String name, ControlFlowSummary summary) {
        Graph graph = ControlFlowVisualizer.createGraph(name, summary);
        return Graphviz.fromGraph((Graph)graph).render(Format.DOT).toString();
    }

    static Graph createGraph(String name, ControlFlowSummary summary) {
        Set<ControlFlowNode> all = summary.getAllNodes();
        HashMap<ControlFlowNode, Integer> nodeToIndex = new HashMap<ControlFlowNode, Integer>(all.size());
        int index = 0;
        for (ControlFlowNode node : all) {
            nodeToIndex.put(node, index);
            ++index;
        }
        return ControlFlowVisualizer.createGraph(name, nodeToIndex);
    }

    private static Graph createGraph(String name, Map<ControlFlowNode, Integer> nodeToIndex) {
        HashMap<ControlFlowNode, Node> abstractToVisualNodeMapping = new HashMap<ControlFlowNode, Node>(nodeToIndex.size());
        Graph g = (Graph)((Graph)((Graph)((Graph)Factory.graph((String)name).directed().graphAttr().with((Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.TOP_TO_BOTTOM))).nodeAttr().with(Font.name((String)"courier"))).linkAttr().with("class", (Object)"link-class")).linkAttr().with(Font.name((String)"arial"));
        for (ControlFlowNode node : nodeToIndex.keySet()) {
            Node n;
            String lbl = nodeToIndex.get(node).toString();
            if (node instanceof ControlFlowNode.BasicBlock) {
                ControlFlowNode.BasicBlock bb = (ControlFlowNode.BasicBlock)node;
                n = (Node)Factory.node((String)lbl).with((Attributes)Shape.RECTANGLE, (Attributes)Label.of((String)(bb.getStatementsWithinBlock().replace("\n", "\\l") + "\\l")));
                abstractToVisualNodeMapping.put(bb, n);
                continue;
            }
            if (node instanceof ControlFlowNode.ConditionNode) {
                ControlFlowNode.ConditionNode cn = (ControlFlowNode.ConditionNode)node;
                n = (Node)Factory.node((String)lbl).with((Attributes)Shape.DIAMOND, (Attributes)Label.of((String)cn.getCondition().toString()));
                abstractToVisualNodeMapping.put(cn, n);
                continue;
            }
            if (node instanceof ControlFlowNode.Start) {
                ControlFlowNode.Start start = (ControlFlowNode.Start)node;
                n = (Node)Factory.node((String)lbl).with((Attributes)Shape.CIRCLE, (Attributes)Label.of((String)start.toString()), Font.name((String)"arial"));
                abstractToVisualNodeMapping.put(start, n);
                continue;
            }
            if (!(node instanceof ControlFlowNode.End)) continue;
            ControlFlowNode.End end = (ControlFlowNode.End)node;
            n = (Node)Factory.node((String)lbl).with((Attributes)Shape.CIRCLE, (Attributes)Label.of((String)end.toString()), Font.name((String)"arial"));
            abstractToVisualNodeMapping.put(end, n);
        }
        for (ControlFlowNode node : nodeToIndex.keySet()) {
            if (node instanceof ControlFlowNode.ConditionNode) {
                ControlFlowNode.ConditionNode cn = (ControlFlowNode.ConditionNode)node;
                g = g.with(new LinkSource[]{((Node)abstractToVisualNodeMapping.get(node)).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)((Node)abstractToVisualNodeMapping.get(cn.getTruthySuccessor()))).with((Attributes)Color.GREEN).with((Attributes)Label.html((String)"True"), (Attributes)Color.rgb((String)"006400").font())})});
                g = g.with(new LinkSource[]{((Node)abstractToVisualNodeMapping.get(node)).link(new LinkTarget[]{(LinkTarget)Factory.to((Node)((Node)abstractToVisualNodeMapping.get(cn.getFalsySuccessor()))).with((Attributes)Color.RED).with((Attributes)Label.html((String)"False"), (Attributes)Color.rgb((String)"FF0000").font())})});
                continue;
            }
            for (ControlFlowNode successor : node.getSuccessors()) {
                g = g.with(new LinkSource[]{((Node)abstractToVisualNodeMapping.get(node)).link(new LinkTarget[]{Factory.to((Node)((Node)abstractToVisualNodeMapping.get(successor)))})});
            }
        }
        return g;
    }

    public static void renderGraphToFile(String name, Graph graph) {
        try {
            Graphviz.useEngine((GraphvizEngine)new GraphvizV8Engine(), (GraphvizEngine[])new GraphvizEngine[0]);
            Graphviz.fromGraph((Graph)graph).render(Format.DOT).toFile(new File("example/", name + ".dot"));
            Graphviz.fromGraph((Graph)graph).render(Format.SVG).toFile(new File("example/", name + ".svg"));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to render graph!", e);
        }
    }

    private ControlFlowVisualizer() {
    }

    static {
        Graphviz.useEngine((GraphvizEngine)new GraphvizV8Engine(), (GraphvizEngine[])new GraphvizEngine[0]);
    }
}

