/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.dataflow.analysis.ForwardFlow;
import org.openrewrite.java.dataflow.analysis.SinkFlow;
import org.openrewrite.java.dataflow.analysis.SourceFlow;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Incubating(since="7.24.0")
public class Dataflow {
    final Cursor start;

    public <Source extends Expression, Sink extends J> Optional<SinkFlow<Source, Sink>> findSinks(LocalFlowSpec<Source, Sink> spec) {
        Object value = this.start.getValue();
        if (spec.getSourceType().isAssignableFrom(value.getClass())) {
            Expression source = (Expression)value;
            if (!spec.isSource(source, this.start)) {
                return Optional.empty();
            }
            SinkFlow<Source, Sink> flow = new SinkFlow<Source, Sink>(this.start, spec);
            ForwardFlow.findSinks(flow);
            if (flow.isNotEmpty()) {
                return Optional.of(flow);
            }
        }
        return Optional.empty();
    }

    public <E extends Expression> SourceFlow<E> findSources(LocalFlowSpec<E, ?> spec) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Dataflow(Cursor start) {
        this.start = start;
    }
}

