/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Marker;

public final class FindText
extends Recipe {
    @Option(displayName="Text patterns", description="A list of regular expressions to search for.", example="-----BEGIN RSA PRIVATE KEY-----")
    private final List<String> patterns;
    private final UUID id = Tree.randomId();

    public String getDisplayName() {
        return "Find text";
    }

    public String getDescription() {
        return "Find occurrences of regular expression based patterns in comments and literals";
    }

    public Validated validate() {
        return super.validate().and(Validated.test((String)"patterns", (String)"Patterns must be compilable regular expressions", this.patterns, ps -> {
            for (String p : ps) {
                try {
                    Pattern.compile(p);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
            return true;
        }));
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final List compiledPatterns = this.patterns.stream().map(Pattern::compile).collect(Collectors.toList());
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, ExecutionContext context) {
                return space.withComments(ListUtils.map(space.getComments(), comment -> {
                    if (compiledPatterns.stream().anyMatch(p -> p.matcher(comment.getText()).find())) {
                        return comment.withMarkers(comment.getMarkers().addOrUpdate((Marker)new JavaSearchResult(FindText.this.id, FindText.this)));
                    }
                    return comment;
                }));
            }

            @Override
            public J.Literal visitLiteral(J.Literal literal, ExecutionContext context) {
                if (literal.getType() == JavaType.Primitive.Null) {
                    return literal;
                }
                assert (literal.getValue() != null);
                if (compiledPatterns.stream().anyMatch(p -> p.matcher(literal.getValue().toString()).find())) {
                    return literal.withMarkers(literal.getMarkers().addOrUpdate((Marker)new JavaSearchResult(FindText.this.id, FindText.this)));
                }
                return literal;
            }
        };
    }

    public FindText(List<String> patterns) {
        this.patterns = patterns;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public UUID getId() {
        return this.id;
    }

    @NonNull
    public String toString() {
        return "FindText(patterns=" + this.getPatterns() + ", id=" + this.getId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindText)) {
            return false;
        }
        FindText other = (FindText)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$patterns = this.getPatterns();
        List<String> other$patterns = other.getPatterns();
        if (this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindText;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $patterns = this.getPatterns();
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

