/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.0.0")
public class SimplifyBooleanReturnVisitor<P>
extends JavaVisitor<P> {
    private final JavaTemplate notIfConditionReturn = this.template("return !(#{});").build();

    @Override
    public J visitIf(J.If iff, P p) {
        J.If i = (J.If)this.visitAndCast(iff, p, (x$0, x$1) -> super.visitIf((J.If)x$0, x$1));
        Cursor parent = this.getCursor().dropParentUntil(J.class::isInstance);
        if (parent.getValue() instanceof J.Block && parent.getParentOrThrow().getValue() instanceof J.MethodDeclaration && this.thenHasOnlyReturnStatement(iff) && this.elseWithOnlyReturn(i)) {
            List<Statement> followingStatements = this.followingStatements();
            Optional<Expression> singleFollowingStatement = Optional.ofNullable(followingStatements.isEmpty() ? null : followingStatements.get(0)).flatMap(stat -> Optional.ofNullable(stat instanceof J.Return ? (J.Return)stat : null)).map(J.Return::getExpression);
            if (followingStatements.isEmpty() || singleFollowingStatement.map(r -> this.isLiteralFalse((J)r) || this.isLiteralTrue((J)r)).orElse(false).booleanValue()) {
                J.Return retrn = this.getReturnIfOnlyStatementInThen(iff).orElse(null);
                assert (retrn != null);
                Expression ifCondition = i.getIfCondition().getTree();
                if (this.isLiteralTrue(retrn.getExpression())) {
                    if (singleFollowingStatement.map(this::isLiteralFalse).orElse(false).booleanValue() && i.getElsePart() == null) {
                        this.doAfterVisit(new DeleteStatement(this.followingStatements().get(0)));
                        return this.maybeAutoFormat(retrn, retrn.withExpression(ifCondition), p, parent);
                    }
                    if (!singleFollowingStatement.isPresent() && this.getReturnExprIfOnlyStatementInElseThen(i).map(this::isLiteralFalse).orElse(false).booleanValue()) {
                        if (i.getElsePart() != null) {
                            this.doAfterVisit(new DeleteStatement(i.getElsePart().getBody()));
                        }
                        return this.maybeAutoFormat(retrn, retrn.withExpression(ifCondition), p, parent);
                    }
                } else if (this.isLiteralFalse(retrn.getExpression())) {
                    boolean returnThenPart = false;
                    if (singleFollowingStatement.map(this::isLiteralTrue).orElse(false).booleanValue() && i.getElsePart() == null) {
                        this.doAfterVisit(new DeleteStatement(this.followingStatements().get(0)));
                        returnThenPart = true;
                    } else if (!singleFollowingStatement.isPresent() && this.getReturnExprIfOnlyStatementInElseThen(i).map(this::isLiteralTrue).orElse(false).booleanValue()) {
                        if (i.getElsePart() != null) {
                            this.doAfterVisit(new DeleteStatement(i.getElsePart().getBody()));
                        }
                        returnThenPart = true;
                    }
                    if (returnThenPart) {
                        return i.withTemplate(this.notIfConditionReturn, i.getCoordinates().replace(), ifCondition);
                    }
                }
            }
        }
        return i;
    }

    private boolean elseWithOnlyReturn(J.If i) {
        return i.getElsePart() == null || !(i.getElsePart().getBody() instanceof J.If);
    }

    private boolean thenHasOnlyReturnStatement(J.If iff) {
        return this.getReturnIfOnlyStatementInThen(iff).map(retrn -> this.isLiteralFalse(retrn.getExpression()) || this.isLiteralTrue(retrn.getExpression())).orElse(false);
    }

    private List<Statement> followingStatements() {
        J.Block block = (J.Block)this.getCursor().dropParentUntil(J.class::isInstance).getValue();
        AtomicBoolean dropWhile = new AtomicBoolean(false);
        return block.getStatements().stream().filter(s -> {
            dropWhile.set(dropWhile.get() || s == this.getCursor().getValue());
            return dropWhile.get();
        }).skip(1L).collect(Collectors.toList());
    }

    private boolean isLiteralTrue(@Nullable J tree) {
        return tree instanceof J.Literal && ((J.Literal)tree).getValue() == Boolean.valueOf(true);
    }

    private boolean isLiteralFalse(@Nullable J tree) {
        return tree instanceof J.Literal && ((J.Literal)tree).getValue() == Boolean.valueOf(false);
    }

    private Optional<J.Return> getReturnIfOnlyStatementInThen(J.If iff) {
        J.Block then;
        if (iff.getThenPart() instanceof J.Return) {
            return Optional.of((J.Return)iff.getThenPart());
        }
        if (iff.getThenPart() instanceof J.Block && (then = (J.Block)iff.getThenPart()).getStatements().size() == 1 && then.getStatements().get(0) instanceof J.Return) {
            return Optional.of((J.Return)then.getStatements().get(0));
        }
        return Optional.empty();
    }

    private Optional<Expression> getReturnExprIfOnlyStatementInElseThen(J.If iff2) {
        J statement;
        List<Statement> statements;
        if (iff2.getElsePart() == null) {
            return Optional.empty();
        }
        Statement elze = iff2.getElsePart().getBody();
        if (elze instanceof J.Return) {
            return Optional.ofNullable(((J.Return)elze).getExpression());
        }
        if (elze instanceof J.Block && (statements = ((J.Block)elze).getStatements()).size() == 1 && (statement = (J)statements.get(0)) instanceof J.Return) {
            return Optional.ofNullable(((J.Return)statement).getExpression());
        }
        return Optional.empty();
    }
}

