/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;

public class BlockStatementTemplateGenerator {
    private static final String TEMPLATE_COMMENT = "__TEMPLATE__";
    private final Set<String> imports;

    public String template(Cursor cursor, String template, Space.Location location) {
        return (String)Timer.builder((String)"rewrite.template.generate.statement").register((MeterRegistry)Metrics.globalRegistry).record(() -> {
            StringBuilder before = new StringBuilder();
            StringBuilder after = new StringBuilder();
            if (cursor.getValue() instanceof J.MethodDeclaration && location.equals((Object)Space.Location.BLOCK_PREFIX)) {
                J.MethodDeclaration method = (J.MethodDeclaration)cursor.getValue();
                J.MethodDeclaration m = method.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY);
                before.insert(0, m.printTrimmed().trim() + '{');
                after.append('}');
            }
            this.template(this.next(cursor), (J)cursor.getValue(), before, after, Collections.newSetFromMap(new IdentityHashMap()));
            return before.toString().trim() + "\n/*" + TEMPLATE_COMMENT + "*/" + template + "\n" + after;
        });
    }

    public List<Statement> listTemplatedStatements(J.CompilationUnit cu) {
        final ArrayList<Statement> statements = new ArrayList<Statement>();
        new JavaIsoVisitor<Integer>(){
            boolean done = false;
            @Nullable
            J.Block blockEnclosingTemplateComment;

            @Override
            public Statement visitStatement(Statement statement, Integer integer) {
                return statement;
            }

            @Override
            public J.Block visitBlock(J.Block block, Integer integer) {
                J b = super.visitBlock(block, integer);
                if (b == this.blockEnclosingTemplateComment) {
                    this.done = true;
                }
                return b;
            }

            @Nullable
            public J visit(@Nullable Tree tree, Integer integer) {
                if (this.done) {
                    return (J)tree;
                }
                if (tree instanceof Statement) {
                    Statement statement = (Statement)tree;
                    if (this.blockEnclosingTemplateComment != null) {
                        statements.add(statement);
                        return statement;
                    }
                    for (Comment comment : statement.getPrefix().getComments()) {
                        if (!(comment instanceof TextComment) || !((TextComment)comment).getText().equals(BlockStatementTemplateGenerator.TEMPLATE_COMMENT)) continue;
                        this.blockEnclosingTemplateComment = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
                        statements.add((Statement)statement.withPrefix(Space.EMPTY));
                        return statement;
                    }
                }
                return (J)super.visit(tree, (Object)integer);
            }
        }.visit(cu, 0);
        return statements;
    }

    private void template(Cursor cursor, J prior, StringBuilder before, StringBuilder after, Set<J> templated) {
        templated.add((J)cursor.getValue());
        J j = (J)cursor.getValue();
        if (j instanceof J.CompilationUnit) {
            J.CompilationUnit cu = (J.CompilationUnit)j;
            for (J.Import import_ : cu.getImports()) {
                before.insert(0, import_.withPrefix(Space.EMPTY).printTrimmed() + ";\n");
            }
            for (String string : this.imports) {
                before.insert(0, string);
            }
            if (cu.getPackageDeclaration() != null) {
                before.insert(0, cu.getPackageDeclaration().withPrefix(Space.EMPTY).printTrimmed() + ";\n");
            }
            return;
        }
        if (j instanceof J.Block) {
            J parent = (J)this.next(cursor).getValue();
            if (parent instanceof J.ClassDeclaration) {
                this.classDeclaration(prior, before, (J.ClassDeclaration)parent, templated);
            } else if (parent instanceof J.MethodDeclaration) {
                J.MethodDeclaration m = (J.MethodDeclaration)parent;
                assert (m.getBody() != null);
                for (Statement statement : m.getBody().getStatements()) {
                    if (statement == prior) break;
                    if (!(statement instanceof J.VariableDeclarations)) continue;
                    before.insert(0, "\n" + this.variable((J.VariableDeclarations)statement, true) + ";\n");
                }
                if (m.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(m.getReturnTypeExpression().getType())) {
                    before.insert(0, "if(true) {");
                    after.append("}\nreturn ").append(this.valueOfType(m.getReturnTypeExpression().getType())).append(";\n");
                }
                before.insert(0, m.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY).printTrimmed().trim() + '{');
            } else if (parent instanceof J.Block) {
                J.Block b = (J.Block)j;
                for (Statement statement : b.getStatements()) {
                    if (statement == prior) break;
                    if (!(statement instanceof J.VariableDeclarations)) continue;
                    before.insert(0, "\n" + this.variable((J.VariableDeclarations)statement, true) + ";\n");
                }
                before.insert(0, "{\n");
                if (b.isStatic()) {
                    before.insert(0, "static");
                }
            } else if (parent instanceof J.Lambda) {
                before.insert(0, "{\n");
            } else {
                before.insert(0, "{\n");
            }
            after.append('}');
            if (parent instanceof J.Lambda) {
                after.append(';');
            }
        } else if (j instanceof J.NewClass) {
            J.NewClass n = (J.NewClass)j;
            if (n.getArguments() != null && n.getArguments().stream().noneMatch(arg -> arg == prior)) {
                n = n.withBody(null).withPrefix(Space.EMPTY);
                before.insert(0, n.printTrimmed().trim());
                after.append(';');
            }
        } else if (j instanceof J.ForLoop) {
            J.ForLoop f = (J.ForLoop)j;
            f = f.withBody(null).withPrefix(Space.EMPTY).withControl(f.getControl().withCondition(null).withUpdate(Collections.emptyList()));
            before.insert(0, f.printTrimmed().trim());
        } else if (j instanceof J.ForEachLoop) {
            J.ForEachLoop f = (J.ForEachLoop)j;
            f = f.withBody(null).withPrefix(Space.EMPTY);
            before.insert(0, f.printTrimmed().trim());
        } else if (j instanceof J.Try) {
            J.Try t = (J.Try)j;
            if (t.getResources() != null) {
                before.insert(0, ")");
                for (J.Try.Resource resource : t.getResources()) {
                    before.insert(0, resource.withPrefix(Space.EMPTY).printTrimmed().trim() + ';');
                }
                before.insert(0, "try(");
                after.append("catch(Throwable t) { throw new RuntimeException(t); }");
            }
        } else if (j instanceof J.Lambda) {
            J.Lambda l = (J.Lambda)j;
            before.insert(0, "{ if(true) {");
            after.append("}\nreturn ").append(this.valueOfType(l.getType())).append(";\n};\n");
            before.insert(0, l.withBody(null).withPrefix(Space.EMPTY).printTrimmed().trim());
        } else if (j instanceof J.VariableDeclarations) {
            before.insert(0, this.variable((J.VariableDeclarations)j, false) + '=');
        }
        this.template(this.next(cursor), j, before, after, templated);
    }

    private void classDeclaration(@Nullable J prior, StringBuilder before, J.ClassDeclaration parent, Set<J> templated) {
        J.ClassDeclaration c = parent;
        for (Statement statement : c.getBody().getStatements()) {
            if (templated.contains(statement)) continue;
            if (statement instanceof J.VariableDeclarations) {
                before.insert(0, this.variable((J.VariableDeclarations)statement, false) + ";\n");
                continue;
            }
            if (statement instanceof J.MethodDeclaration) {
                if (statement == prior) continue;
                before.insert(0, this.method((J.MethodDeclaration)statement));
                continue;
            }
            if (!(statement instanceof J.ClassDeclaration)) continue;
            before.insert(0, '}');
            this.classDeclaration(null, before, (J.ClassDeclaration)statement, templated);
        }
        c = c.withBody(null).withLeadingAnnotations(null).withPrefix(Space.EMPTY);
        before.insert(0, c.printTrimmed().trim() + '{');
    }

    private String method(J.MethodDeclaration method) {
        if (method.isAbstract()) {
            return "\n" + method.withPrefix(Space.EMPTY).printTrimmed().trim() + ";\n";
        }
        StringBuilder methodBuilder = new StringBuilder("\n");
        J.MethodDeclaration m = method.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY);
        methodBuilder.append(m.printTrimmed().trim()).append('{');
        if (method.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(method.getReturnTypeExpression().getType())) {
            methodBuilder.append("\nreturn ").append(this.valueOfType(method.getReturnTypeExpression().getType())).append(";\n");
        }
        methodBuilder.append("}\n");
        return methodBuilder.toString();
    }

    private String variable(J.VariableDeclarations variable, boolean initializer) {
        StringBuilder varBuilder = new StringBuilder();
        for (J.Modifier modifier : variable.getModifiers()) {
            varBuilder.append(modifier.getType().toString().toLowerCase()).append(' ');
        }
        List<J.VariableDeclarations.NamedVariable> variables = variable.getVariables();
        int variablesSize = variables.size();
        for (int i = 0; i < variablesSize; ++i) {
            J.VariableDeclarations.NamedVariable nv = variables.get(i);
            if (i == 0) {
                if (variable.getTypeExpression() != null) {
                    varBuilder.append(variable.getTypeExpression().withPrefix(Space.EMPTY).printTrimmed());
                }
                if (nv.getType() instanceof JavaType.Array) {
                    varBuilder.append("[]");
                }
                varBuilder.append(" ");
            }
            varBuilder.append(nv.getSimpleName());
            JavaType type = nv.getType();
            if (initializer && type != null) {
                varBuilder.append('=').append(this.valueOfType(type));
            }
            if (i >= variables.size() - 1) continue;
            varBuilder.append(',');
        }
        return varBuilder.toString();
    }

    private String valueOfType(@Nullable JavaType type) {
        JavaType.Primitive primitive = TypeUtils.asPrimitive(type);
        if (primitive != null) {
            switch (primitive) {
                case Boolean: {
                    return "true";
                }
                case Byte: 
                case Char: 
                case Int: 
                case Double: 
                case Float: 
                case Long: 
                case Short: {
                    return "0";
                }
                case String: 
                case Null: {
                    return "null";
                }
            }
            return "";
        }
        return "null";
    }

    private Cursor next(Cursor c) {
        return c.dropParentUntil(J.class::isInstance);
    }

    public BlockStatementTemplateGenerator(Set<String> imports) {
        this.imports = imports;
    }
}

