/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesStyle;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.tree.J;

public class UnnecessaryParentheses
extends Recipe {
    public String getDisplayName() {
        return "Remove unnecessary parentheses";
    }

    public String getDescription() {
        return "Removes unnecessary parentheses from code where extra parentheses pairs are redundant.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1110");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                UnnecessaryParenthesesStyle style = (UnnecessaryParenthesesStyle)cu.getStyle(UnnecessaryParenthesesStyle.class);
                if (style == null) {
                    style = Checkstyle.unnecessaryParentheses();
                }
                this.doAfterVisit(new UnnecessaryParenthesesVisitor(style));
                return cu;
            }
        };
    }

    public boolean causesAnotherCycle() {
        return true;
    }
}

