/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

public class TabsAndIndentsVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final TabsAndIndentsStyle style;
    private final String spacesForTab;

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style) {
        this(style, null);
    }

    public TabsAndIndentsVisitor(TabsAndIndentsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < style.getTabSize(); ++i) {
            s.append(' ');
        }
        this.spacesForTab = s.toString();
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p, Cursor parent) {
        this.setCursor(parent);
        for (Cursor c = parent; c != null; c = c.getParent()) {
            int indent;
            Object v = c.getValue();
            Space space = null;
            if (v instanceof J) {
                space = ((J)v).getPrefix();
            } else if (v instanceof JRightPadded) {
                space = ((JRightPadded)v).getAfter();
            } else if (v instanceof JLeftPadded) {
                space = ((JLeftPadded)v).getBefore();
            } else if (v instanceof JContainer) {
                space = ((JContainer)v).getBefore();
            }
            if (space == null || !space.getLastWhitespace().contains("\n") || (indent = this.findIndent(space)) == 0) continue;
            c.putMessage("lastIndent", (Object)indent);
        }
        this.preVisit((J)parent.getPath(J.class::isInstance).next(), p);
        return this.visit(tree, (Object)p);
    }

    @Nullable
    public J preVisit(J tree, P p) {
        if (tree instanceof J.CompilationUnit || tree instanceof J.Package || tree instanceof J.Import || tree instanceof J.Label || tree instanceof J.DoWhileLoop || tree instanceof J.ArrayDimension || tree instanceof J.ClassDeclaration) {
            this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
        } else if (tree instanceof J.Block || tree instanceof J.If || tree instanceof J.If.Else || tree instanceof J.ForLoop || tree instanceof J.ForEachLoop || tree instanceof J.WhileLoop || tree instanceof J.Case || tree instanceof J.EnumValueSet) {
            this.getCursor().putMessage("indentType", (Object)IndentType.INDENT);
        } else {
            this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
        }
        return (J)super.preVisit((Tree)tree, p);
    }

    @Override
    public J visitForControl(J.ForLoop.Control control, P p) {
        return control;
    }

    @Override
    public J visitForEachControl(J.ForEachLoop.Control control, P p) {
        return control;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        alignToAnnotation = false;
        parent = this.getCursor().getParent();
        if (parent != null && parent.getValue() instanceof J.Annotation) {
            parent.getParentOrThrow().putMessage("afterAnnotation", (Object)true);
        } else if (parent != null) {
            if (!this.getCursor().getParentOrThrow().getPath((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(J.Annotation.class)).hasNext()) {
                v0 = alignToAnnotation = this.getCursor().pollNearestMessage("afterAnnotation") != null && this.getCursor().getParentOrThrow().getValue() instanceof J.Annotation == false;
            }
        }
        if (space.getComments().isEmpty() && !space.getLastWhitespace().contains("\n") || parent == null) {
            return space;
        }
        indent = Optional.ofNullable((Integer)this.getCursor().getNearestMessage("lastIndent")).orElse(0);
        indentType = Optional.ofNullable((IndentType)this.getCursor().getParentOrThrow().getNearestMessage("indentType")).orElse(IndentType.ALIGN);
        if (!loc.equals((Object)Space.Location.BLOCK_PREFIX) || !space.getWhitespace().contains("\n") || !(this.getCursor().getValue() instanceof J.Block)) ** GOTO lbl-1000
        if (!(this.getCursor().dropParentUntil((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(J.class)).getValue() instanceof J.Block)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        alignBlockPrefixToParent = v1;
        v2 = alignBlockToParent = loc.equals((Object)Space.Location.BLOCK_END) != false || loc.equals((Object)Space.Location.NEW_ARRAY_INITIALIZER_SUFFIX) != false || loc.equals((Object)Space.Location.CATCH_PREFIX) != false || loc.equals((Object)Space.Location.TRY_FINALLY) != false || loc.equals((Object)Space.Location.ELSE_PREFIX) != false;
        if (loc.equals((Object)Space.Location.EXTENDS) && space.getWhitespace().contains("\n")) {
            indentType = IndentType.CONTINUATION_INDENT;
        }
        if (alignBlockPrefixToParent || alignBlockToParent || alignToAnnotation) {
            indentType = IndentType.ALIGN;
        }
        switch (1.$SwitchMap$org$openrewrite$java$format$TabsAndIndentsVisitor$IndentType[indentType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                indent += this.style.getIndentSize().intValue();
                break;
            }
            case 3: {
                indent += this.style.getContinuationIndent().intValue();
            }
        }
        s = this.indentTo(space, indent, loc);
        if (!(this.getCursor().getValue() instanceof JLeftPadded) && !(this.getCursor().getValue() instanceof J.EnumValueSet)) {
            this.getCursor().putMessage("lastIndent", (Object)indent);
        }
        return s;
    }

    @Override
    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, P p) {
        Space after;
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        int indent = Optional.ofNullable((Integer)this.getCursor().getNearestMessage("lastIndent")).orElse(0);
        if (right.getElement() instanceof J) {
            J elem = (J)right.getElement();
            if (right.getAfter().getLastWhitespace().contains("\n") || elem.getPrefix().getLastWhitespace().contains("\n")) {
                switch (loc) {
                    case FOR_CONDITION: 
                    case FOR_UPDATE: {
                        J.ForLoop.Control control = (J.ForLoop.Control)this.getCursor().getParentOrThrow().getValue();
                        Space initPrefix = Space.firstPrefix(control.getInit());
                        if (!initPrefix.getLastWhitespace().contains("\n")) {
                            int initIndent = this.forInitColumn();
                            this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(initIndent - this.style.getContinuationIndent()));
                            elem = (J)this.visitAndCast(elem, p);
                            this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                            after = this.indentTo(right.getAfter(), initIndent, loc.getAfterLocation());
                            break;
                        }
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                    case METHOD_DECLARATION_PARAMETER: {
                        JContainer container = (JContainer)this.getCursor().getParentOrThrow().getValue();
                        J firstArg = (J)container.getElements().iterator().next();
                        if (firstArg.getPrefix().getWhitespace().isEmpty()) {
                            after = right.getAfter();
                            break;
                        }
                        if (firstArg.getPrefix().getLastWhitespace().contains("\n")) {
                            elem = (J)this.visitAndCast(elem, p);
                            after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                            break;
                        }
                        int firstArgIndent = this.findIndent(firstArg.getPrefix());
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)firstArgIndent);
                        elem = (J)this.visitAndCast(elem, p);
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                        after = this.indentTo(right.getAfter(), firstArgIndent, loc.getAfterLocation());
                        break;
                    }
                    case METHOD_INVOCATION_ARGUMENT: {
                        J body;
                        if (!elem.getPrefix().getLastWhitespace().contains("\n") && elem instanceof J.Lambda && !((body = ((J.Lambda)elem).getBody()) instanceof J.Binary) && !body.getPrefix().getLastWhitespace().contains("\n")) {
                            this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                        }
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                        break;
                    }
                    case NEW_CLASS_ARGUMENTS: 
                    case ARRAY_INDEX: 
                    case PARENTHESES: 
                    case TYPE_PARAMETER: {
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                        break;
                    }
                    case METHOD_SELECT: {
                        Cursor cursor = this.getCursor();
                        while (true) {
                            if (cursor.getValue() instanceof JRightPadded) {
                                cursor = cursor.getParentOrThrow();
                            }
                            if (!(cursor.getValue() instanceof J.MethodInvocation)) break;
                            Integer methodIndent = (Integer)cursor.getNearestMessage("lastIndent");
                            if (methodIndent != null) {
                                indent = methodIndent;
                            }
                            cursor = cursor.getParentOrThrow();
                        }
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)indent);
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        this.getCursor().getParentOrThrow().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                        break;
                    }
                    case ANNOTATION_ARGUMENT: {
                        JContainer args = (JContainer)this.getCursor().getParentOrThrow().getValue();
                        elem = (J)this.visitAndCast(elem, p);
                        if (args.getPadding().getElements().get(args.getElements().size() - 1) == right) {
                            this.getCursor().getParentOrThrow().putMessage("indentType", (Object)IndentType.ALIGN);
                        }
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                    default: {
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                }
            } else {
                switch (loc) {
                    case METHOD_INVOCATION_ARGUMENT: 
                    case NEW_CLASS_ARGUMENTS: {
                        if (!elem.getPrefix().getLastWhitespace().contains("\n")) {
                            JContainer args = (JContainer)this.getCursor().getParentOrThrow().getValue();
                            boolean seenArg = false;
                            boolean anyOtherArgOnOwnLine = false;
                            for (JRightPadded arg : args.getPadding().getElements()) {
                                if (arg == this.getCursor().getValue()) {
                                    seenArg = true;
                                    continue;
                                }
                                if (!seenArg || !((J)arg.getElement()).getPrefix().getLastWhitespace().contains("\n")) continue;
                                anyOtherArgOnOwnLine = true;
                                break;
                            }
                            if (!anyOtherArgOnOwnLine) {
                                elem = (J)this.visitAndCast(elem, p);
                                after = this.indentTo(right.getAfter(), indent, loc.getAfterLocation());
                                break;
                            }
                        }
                        if (!(elem instanceof J.Binary)) {
                            if (!(elem instanceof J.MethodInvocation)) {
                                this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                            } else if (elem.getPrefix().getLastWhitespace().contains("\n")) {
                                this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                            } else {
                                J.MethodInvocation methodInvocation = (J.MethodInvocation)elem;
                                Expression select = methodInvocation.getSelect();
                                if (select instanceof J.FieldAccess || select instanceof J.Identifier || select instanceof J.MethodInvocation) {
                                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                                }
                            }
                        }
                        elem = (J)this.visitAndCast(elem, p);
                        after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
                        break;
                    }
                    default: {
                        elem = (J)this.visitAndCast(elem, p);
                        after = right.getAfter();
                    }
                }
            }
            t = elem;
        } else {
            after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        }
        this.setCursor(this.getCursor().getParent());
        return after == right.getAfter() && t == right.getElement() ? right : new JRightPadded<T>(t, after, right.getMarkers());
    }

    @Override
    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, JContainer.Location loc, P p) {
        List js;
        Space before;
        this.setCursor(new Cursor(this.getCursor(), container));
        int indent = Optional.ofNullable((Integer)this.getCursor().getNearestMessage("lastIndent")).orElse(0);
        if (container.getBefore().getLastWhitespace().contains("\n")) {
            switch (loc) {
                case TYPE_PARAMETERS: 
                case IMPLEMENTS: 
                case THROWS: 
                case NEW_CLASS_ARGUMENTS: {
                    before = this.indentTo(container.getBefore(), indent + this.style.getContinuationIndent(), loc.getBeforeLocation());
                    this.getCursor().putMessage("indentType", (Object)IndentType.ALIGN);
                    this.getCursor().putMessage("lastIndent", (Object)(indent + this.style.getContinuationIndent()));
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
                default: {
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
            }
        } else {
            switch (loc) {
                case TYPE_PARAMETERS: 
                case IMPLEMENTS: 
                case THROWS: 
                case NEW_CLASS_ARGUMENTS: 
                case METHOD_INVOCATION_ARGUMENTS: {
                    this.getCursor().putMessage("indentType", (Object)IndentType.CONTINUATION_INDENT);
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                    break;
                }
                default: {
                    before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
                    js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
                }
            }
        }
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build(before, js, container.getMarkers());
    }

    private Space indentTo(Space space, int column, Space.Location spaceLocation) {
        if (space.getComments().isEmpty() && !space.getLastWhitespace().contains("\n")) {
            return space;
        }
        if (space.getComments().isEmpty()) {
            int indent;
            if (!StringUtils.isNullOrEmpty((String)space.getWhitespace())) {
                space = this.style.getUseTabCharacter() != false ? space.withWhitespace(space.getWhitespace().replaceAll(" ", "")) : space.withWhitespace(space.getWhitespace().replaceAll("\t", ""));
            }
            if ((indent = this.findIndent(space)) != column) {
                int shift = column - indent;
                space = space.withWhitespace(this.indent(space.getWhitespace(), shift));
            }
        } else {
            if (!StringUtils.isNullOrEmpty((String)space.getWhitespace()) && (Space.Location.COMPILATION_UNIT_PREFIX.equals((Object)spaceLocation) || !Comment.Style.LINE.equals((Object)space.getComments().get(0).getStyle()) || Comment.Style.LINE.equals((Object)space.getComments().get(0).getStyle()) && (space.getWhitespace().contains("\n") || space.getWhitespace().contains("\r")))) {
                space = this.style.getUseTabCharacter() != false ? space.withWhitespace(space.getWhitespace().replaceAll(" ", "")) : space.withWhitespace(space.getWhitespace().replaceAll("\t", ""));
            }
            Comment lastElement = space.getComments().get(space.getComments().size() - 1);
            if ((space = space.withComments(ListUtils.map(space.getComments(), c -> {
                int incrementBy = spaceLocation.equals((Object)Space.Location.BLOCK_END) && !c.equals(lastElement) ? this.style.getIndentSize() : 0;
                switch (c.getStyle()) {
                    case JAVADOC: 
                    case BLOCK: {
                        return this.indentMultilineComment((Comment)c, column + incrementBy);
                    }
                }
                return this.indentSingleLineComment((Comment)c, column + incrementBy);
            }))).getWhitespace().contains("\n") || Space.Location.COMPILATION_UNIT_PREFIX.equals((Object)spaceLocation)) {
                int incrementBy = spaceLocation.equals((Object)Space.Location.BLOCK_END) ? this.style.getIndentSize() : 0;
                int indent = this.getLengthOfWhitespace(space.getWhitespace());
                if (indent != column + incrementBy) {
                    int shift = column + incrementBy - indent;
                    space = space.withWhitespace(this.indent(space.getWhitespace(), shift));
                }
            }
        }
        return space;
    }

    private Comment indentSingleLineComment(Comment comment, int column) {
        String suffix;
        int indent;
        String normalizedSuffix = null;
        if (!StringUtils.isNullOrEmpty((String)comment.getSuffix())) {
            if (this.style.getUseTabCharacter().booleanValue()) {
                if (comment.getSuffix().contains(" ")) {
                    normalizedSuffix = comment.getSuffix().replaceAll(" ", "");
                }
            } else if (comment.getSuffix().contains("\t")) {
                normalizedSuffix = comment.getSuffix().replaceAll("\t", this.spacesForTab);
            }
        }
        if (column == (indent = this.getLengthOfWhitespace(suffix = normalizedSuffix == null ? comment.getSuffix() : normalizedSuffix)) && normalizedSuffix == null) {
            return comment;
        }
        StringBuilder newSuffix = new StringBuilder(suffix);
        int shift = column - indent;
        this.shift(newSuffix, shift);
        return comment.withSuffix(newSuffix.toString());
    }

    private Comment indentMultilineComment(Comment comment, int column) {
        StringBuilder newSuffix;
        int shift;
        StringBuilder newTextBuilder = new StringBuilder();
        StringBuilder currentText = new StringBuilder();
        StringBuilder whitespace = new StringBuilder();
        boolean hasChanged = false;
        boolean isWhitespace = true;
        boolean isFirstLine = true;
        int indent = 0;
        int tabLength = 0;
        boolean alignToColumn = Comment.Style.JAVADOC.equals((Object)comment.getStyle()) || this.shouldAlignBlockComment(comment);
        int prev = 36;
        block7: for (int i = 0; i < comment.getText().length(); ++i) {
            char c = comment.getText().charAt(i);
            switch (c) {
                case '\t': {
                    if (!isFirstLine && isWhitespace) {
                        if (this.style.getUseTabCharacter().booleanValue()) {
                            whitespace.append(c);
                            indent += this.style.getTabSize().intValue();
                        } else {
                            for (int j = tabLength % this.style.getIndentSize(); j < this.style.getIndentSize(); ++j) {
                                whitespace.append(' ');
                                ++indent;
                                hasChanged = true;
                            }
                        }
                        tabLength = 0;
                        break;
                    }
                    currentText.append(c);
                    break;
                }
                case ' ': {
                    if (!isFirstLine && isWhitespace) {
                        if (this.style.getUseTabCharacter().booleanValue()) {
                            if (++tabLength == this.style.getTabSize() && (!alignToColumn || i + 1 < comment.getText().length() - 1 && comment.getText().charAt(i + 1) != '*')) {
                                whitespace.append('\t');
                                indent += this.style.getTabSize().intValue();
                                tabLength = 0;
                                hasChanged = true;
                            }
                        } else {
                            whitespace.append(c);
                            ++indent;
                            ++tabLength;
                        }
                        if (tabLength != (this.style.getUseTabCharacter() != false ? this.style.getTabSize() : this.style.getIndentSize())) break;
                        tabLength = 0;
                        break;
                    }
                    currentText.append(c);
                    break;
                }
                case '\r': {
                    if (i + 1 <= comment.getText().length() - 1 && comment.getText().charAt(i + 1) == '\n') continue block7;
                }
                case '\n': {
                    if (isFirstLine) {
                        isFirstLine = false;
                    } else if (alignToColumn && indent != column) {
                        shift = column - indent;
                        this.shift(whitespace, shift);
                        hasChanged = true;
                    }
                    newTextBuilder.append((CharSequence)whitespace.append((CharSequence)currentText));
                    whitespace.setLength(0);
                    currentText.setLength(0);
                    indent = 0;
                    tabLength = 0;
                    if (i - 1 >= 0 && comment.getText().charAt(i - 1) == '\r' && c == '\n') {
                        whitespace.append(comment.getText().charAt(i - 1));
                    }
                    whitespace.append(c);
                    isWhitespace = true;
                    break;
                }
                case '*': {
                    if (alignToColumn && !isFirstLine && isWhitespace) {
                        if (this.style.getUseTabCharacter().booleanValue()) {
                            if (prev != 32) {
                                hasChanged = true;
                            }
                        } else if (whitespace.length() <= 1) {
                            hasChanged = true;
                        } else {
                            whitespace.setLength(whitespace.length() - 1);
                            --indent;
                        }
                        currentText.append(' ');
                    }
                }
                default: {
                    if (!isFirstLine && isWhitespace) {
                        isWhitespace = false;
                        if (Comment.Style.JAVADOC.equals((Object)comment.getStyle()) && currentText.length() == 0) {
                            currentText.append(' ');
                            currentText.append('*');
                            currentText.append(' ');
                            hasChanged = true;
                        }
                    }
                    currentText.append(c);
                }
            }
            prev = c;
        }
        if (!isFirstLine) {
            int incrementBy;
            int n = incrementBy = this.style.getUseTabCharacter() == false && currentText.length() == 0 ? 1 : 0;
            if (alignToColumn && indent != column + incrementBy) {
                int shift2 = column - indent;
                this.shift(whitespace, shift2);
                hasChanged = true;
            }
            if (currentText.length() == 0) {
                if (this.style.getUseTabCharacter().booleanValue()) {
                    if (whitespace.charAt(whitespace.length() - 1) != ' ') {
                        whitespace.append(' ');
                        if (!hasChanged && prev != 32) {
                            hasChanged = true;
                        }
                    }
                } else if (whitespace.length() - 1 == column) {
                    whitespace.append(' ');
                    hasChanged = true;
                }
            }
        }
        String suffix = null;
        if (this.style.getUseTabCharacter().booleanValue()) {
            if (comment.getSuffix().contains(" ")) {
                suffix = comment.getSuffix().replace(" ", "\t");
                hasChanged = true;
            }
        } else if (comment.getSuffix().contains("\t")) {
            suffix = comment.getSuffix().replace("\t", " ");
            hasChanged = true;
        }
        if ((indent = this.getLengthOfWhitespace((newSuffix = new StringBuilder(suffix = suffix == null ? comment.getSuffix() : suffix)).toString())) != column && newSuffix.toString().contains("\n")) {
            shift = column - indent;
            this.shift(newSuffix, shift);
            hasChanged = true;
        }
        if (!hasChanged) {
            return comment;
        }
        String newText = newTextBuilder.append((CharSequence)whitespace.append((CharSequence)currentText)).toString();
        return comment.withText(newText).withSuffix(newSuffix.toString());
    }

    private boolean shouldAlignBlockComment(Comment comment) {
        boolean alignComment = true;
        boolean isFirstLine = true;
        boolean isWhitespace = true;
        block4: for (char c : comment.getText().toCharArray()) {
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    if (isFirstLine) {
                        isFirstLine = false;
                    }
                    isWhitespace = true;
                    continue block4;
                }
                default: {
                    if (isFirstLine || !isWhitespace) continue block4;
                    isWhitespace = false;
                    if (c == '*') continue block4;
                    alignComment = false;
                    break block4;
                }
            }
        }
        return alignComment;
    }

    private String indent(String whitespace, int shift) {
        if (!this.style.getUseTabCharacter().booleanValue() && whitespace.contains("\t")) {
            whitespace = whitespace.replaceAll("\t", this.spacesForTab);
        }
        StringBuilder newWhitespace = new StringBuilder(whitespace);
        this.shift(newWhitespace, shift);
        return newWhitespace.toString();
    }

    private void shift(StringBuilder text, int shift) {
        int tabIndent = this.style.getTabSize();
        if (!this.style.getUseTabCharacter().booleanValue()) {
            tabIndent = Integer.MAX_VALUE;
        }
        if (shift > 0) {
            int i;
            for (i = 0; i < shift / tabIndent; ++i) {
                text.append('\t');
            }
            for (i = 0; i < shift % tabIndent; ++i) {
                text.append(' ');
            }
        } else {
            int len = this.style.getUseTabCharacter() != false ? text.length() + shift / tabIndent : text.length() + shift;
            if (len >= 0) {
                text.delete(len, text.length());
            }
        }
    }

    private int findIndent(Space space) {
        String indent = space.getIndent();
        return this.getLengthOfWhitespace(indent);
    }

    private int getLengthOfWhitespace(@Nullable String whitespace) {
        if (whitespace == null) {
            return 0;
        }
        int size = 0;
        for (char c : whitespace.toCharArray()) {
            size += c == '\t' ? this.style.getTabSize() : 1;
            if (c != '\n' && c != '\r') continue;
            size = 0;
        }
        return size;
    }

    private int forInitColumn() {
        Cursor forCursor = this.getCursor().dropParentUntil(J.ForLoop.class::isInstance);
        J.ForLoop forLoop = (J.ForLoop)forCursor.getValue();
        Object parent = forCursor.getParentOrThrow().getValue();
        J.ForLoop alignTo = parent instanceof J.Label ? ((J.Label)parent).withStatement(forLoop.withBody(null)) : forLoop.withBody(null);
        int column = 0;
        boolean afterInitStart = false;
        for (char c : alignTo.print().toCharArray()) {
            if (c == '(') {
                afterInitStart = true;
            } else if (afterInitStart && !Character.isWhitespace(c)) {
                return column - 1;
            }
            ++column;
        }
        throw new IllegalStateException("For loops must have a control section");
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    private static enum IndentType {
        ALIGN,
        INDENT,
        CONTINUATION_INDENT;

    }
}

