/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class EmptyNewlineAtEndOfFile
extends Recipe {
    public String getDisplayName() {
        return "End files with a single newline";
    }

    public String getDescription() {
        return "Some tools work better when files end with an empty line.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-113");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                Space eof = cu.getEof();
                if (eof.getLastWhitespace().chars().filter(c -> c == 10).count() != 1L) {
                    if (eof.getComments().isEmpty()) {
                        return cu.withEof(Space.format("\n"));
                    }
                    List<Comment> comments = cu.getEof().getComments();
                    return cu.withEof(cu.getEof().withComments(ListUtils.map(comments, (i, comment) -> i == comments.size() - 1 ? comment.withSuffix("\n") : comment)));
                }
                return cu;
            }
        };
    }
}

