/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;

public class UnnecessaryExplicitTypeArguments
extends Recipe {
    public String getDisplayName() {
        return "Unnecessary explicit type arguments";
    }

    public String getDescription() {
        return "When explicit type arguments are inferrable by the compiler, they may be removed.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (((J.MethodInvocation)m).getType() != null) {
                    Object enclosing = this.getCursor().dropParentUntil(J.class::isInstance).getValue();
                    JavaType enclosingType = null;
                    if (enclosing instanceof Expression) {
                        enclosingType = ((Expression)enclosing).getType();
                    } else if (enclosing instanceof NameTree) {
                        enclosingType = ((NameTree)enclosing).getType();
                    } else if (enclosing instanceof J.Return) {
                        J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).getValue();
                        if (methodDeclaration.getReturnTypeExpression() != null) {
                            enclosingType = methodDeclaration.getReturnTypeExpression().getType();
                        }
                    }
                    if (enclosingType != null && enclosingType.equals(((J.MethodInvocation)m).getType().getResolvedSignature().getReturnType())) {
                        m = ((J.MethodInvocation)m).withTypeParameters(null);
                    }
                }
                return m;
            }
        };
    }
}

