/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.EmptyForInitializerPadStyle;
import org.openrewrite.java.cleanup.EmptyForIteratorPadStyle;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Marker;

public class PadEmptyForLoopComponents
extends Recipe {
    public String getDisplayName() {
        return "Pad empty `for` loop components";
    }

    public String getDescription() {
        return "Fixes padding on empty `for` loop iterators and initializers to match Checkstyle policies.";
    }

    @Nullable
    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                if (cu.getStyle(EmptyForIteratorPadStyle.class) != null || cu.getStyle(EmptyForInitializerPadStyle.class) != null) {
                    return cu.withMarkers(cu.getMarkers().add((Marker)new JavaSearchResult(Tree.randomId(), PadEmptyForLoopComponents.this, null)));
                }
                return cu;
            }
        };
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            @Nullable
            EmptyForIteratorPadStyle emptyForIteratorPadStyle;
            @Nullable
            EmptyForInitializerPadStyle emptyForInitializerPadStyle;

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.emptyForInitializerPadStyle = (EmptyForInitializerPadStyle)cu.getStyle(EmptyForInitializerPadStyle.class);
                this.emptyForIteratorPadStyle = (EmptyForIteratorPadStyle)cu.getStyle(EmptyForIteratorPadStyle.class);
                return super.visitCompilationUnit(cu, executionContext);
            }

            @Override
            public J.ForLoop visitForLoop(J.ForLoop forLoop, ExecutionContext executionContext) {
                J fl = super.visitForLoop(forLoop, executionContext);
                List<Statement> updates = forLoop.getControl().getUpdate();
                if (this.emptyForIteratorPadStyle != null && updates.size() == 1 && updates.get(0) instanceof J.Empty) {
                    Statement update = updates.get(0);
                    if (this.emptyForIteratorPadStyle.getSpace().booleanValue() && update.getPrefix().getWhitespace().isEmpty()) {
                        update = (Statement)update.withPrefix(update.getPrefix().withWhitespace(" "));
                    } else if (!this.emptyForIteratorPadStyle.getSpace().booleanValue() && !update.getPrefix().getWhitespace().isEmpty()) {
                        update = (Statement)update.withPrefix(update.getPrefix().withWhitespace(""));
                    }
                    fl = ((J.ForLoop)fl).withControl(((J.ForLoop)fl).getControl().withUpdate(Collections.singletonList(update)));
                }
                List init = forLoop.getControl().getInit();
                if (this.emptyForInitializerPadStyle != null && init.get(0) instanceof J.Empty) {
                    if (this.emptyForInitializerPadStyle.getSpace().booleanValue() && init.get(0).getPrefix().getWhitespace().isEmpty()) {
                        init = ListUtils.mapFirst(init, i -> (Statement)i.withPrefix(i.getPrefix().withWhitespace(" ")));
                    } else if (!this.emptyForInitializerPadStyle.getSpace().booleanValue() && !init.get(0).getPrefix().getWhitespace().isEmpty()) {
                        init = ListUtils.mapFirst((List)init, i -> (Statement)i.withPrefix(i.getPrefix().withWhitespace("")));
                    }
                    fl = ((J.ForLoop)fl).withControl(((J.ForLoop)fl).getControl().withInit(init));
                }
                return fl;
            }
        };
    }
}

