/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.Statement;

public class ControlFlowIndentation
extends Recipe {
    public String getDisplayName() {
        return "Control flow statement indentation";
    }

    public String getDescription() {
        return "Program flow control statements like `if`, `while`, and `for` can omit curly braces when they apply to only a single statement. This recipe ensures that any statements which follow that statement are correctly indented to show they are not part of the flow control statement.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2681");
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            TabsAndIndentsStyle tabsAndIndentsStyle;

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                TabsAndIndentsStyle style = (TabsAndIndentsStyle)cu.getStyle(TabsAndIndentsStyle.class);
                if (style == null) {
                    style = IntelliJ.tabsAndIndents();
                }
                this.tabsAndIndentsStyle = style;
                return super.visitCompilationUnit(cu, executionContext);
            }

            @Override
            public J.Block visitBlock(J.Block block, ExecutionContext executionContext) {
                J b = super.visitBlock(block, executionContext);
                for (Statement s : ((J.Block)b).getStatements()) {
                    Loop loop;
                    Statement body;
                    if (s instanceof J.If) {
                        J.If ifs = (J.If)s;
                        if (!this.shouldReformat(ifs)) continue;
                        this.doAfterVisit(new TabsAndIndentsVisitor(this.tabsAndIndentsStyle, b));
                        return b;
                    }
                    if (!(s instanceof Loop) || (body = (loop = (Loop)s).getBody()) instanceof J.Block) continue;
                    this.doAfterVisit(new TabsAndIndentsVisitor(this.tabsAndIndentsStyle, b));
                    return b;
                }
                return b;
            }

            boolean shouldReformat(J.If s) {
                Statement thenPart = s.getThenPart();
                if (!(thenPart instanceof J.Block)) {
                    return true;
                }
                return this.shouldReformat(s.getElsePart());
            }

            boolean shouldReformat(@Nullable J.If.Else s) {
                if (s == null) {
                    return false;
                }
                Statement body = s.getBody();
                if (body instanceof J.If) {
                    return this.shouldReformat((J.If)body);
                }
                return !(body instanceof J.Block);
            }
        };
    }
}

