/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.RecipeSearchResult;

public final class FindMethods
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern, expressed as a pointcut expression, that is used to find matching method invocations.", example="java.util.List add(..)")
    private final String methodPattern;

    public String getDisplayName() {
        return "Find methods";
    }

    public String getDescription() {
        return "Find methods by pattern.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J m = super.visitMethodInvocation(method, ctx);
                if (methodMatcher.matches(method)) {
                    if (method.getType() != null && method.getType().hasFlags(Flag.Static)) {
                        ctx.putMessageInSet("org.openrewrite.java.FoundType", (Object)method.getType().getDeclaringType());
                    }
                    m = (J.MethodInvocation)m.withMarker(new Marker[]{new RecipeSearchResult((Recipe)FindMethods.this)});
                }
                return m;
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                J m = super.visitMemberReference(memberRef, ctx);
                if (methodMatcher.matches(((J.MemberReference)m).getReferenceType())) {
                    if (((J.MemberReference)m).getType() != null) {
                        ctx.putMessageInSet("org.openrewrite.java.FoundType", (Object)((J.MemberReference)m).getType());
                    }
                    m = ((J.MemberReference)m).withReference((J.Identifier)((J.MemberReference)m).getReference().withMarker(new Marker[]{new RecipeSearchResult((Recipe)FindMethods.this)}));
                }
                return m;
            }
        };
    }

    public static Set<J> find(J j, String methodPattern) {
        final MethodMatcher methodMatcher = new MethodMatcher(methodPattern);
        JavaIsoVisitor<Set<J>> findVisitor = new JavaIsoVisitor<Set<J>>(){

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Set<J> ms) {
                if (methodMatcher.matches(method)) {
                    ms.add(method);
                }
                return super.visitMethodInvocation(method, ms);
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, Set<J> ms) {
                if (methodMatcher.matches(memberRef.getReferenceType())) {
                    ms.add(memberRef);
                }
                return super.visitMemberReference(memberRef, ms);
            }
        };
        HashSet<J> ms = new HashSet<J>();
        findVisitor.visit(j, ms);
        return ms;
    }

    public FindMethods(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    @NonNull
    public String toString() {
        return "FindMethods(methodPattern=" + this.getMethodPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMethods)) {
            return false;
        }
        FindMethods other = (FindMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindMethods;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }
}

