/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public class JavaTemplatePrinter
extends JavaPrinter<Cursor> {
    private static final J.Block EMPTY_BLOCK = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded<Boolean>(false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.EMPTY);
    static final String SNIPPET_MARKER_START = "<<<<START>>>>";
    static final String SNIPPET_MARKER_END = "<<<<END>>>>";
    private final JavaCoordinates coordinates;
    private final Tree changing;
    private final Set<String> imports;
    private final String code;

    public JavaTemplatePrinter(String code, Tree changing, JavaCoordinates coordinates, Set<String> imports) {
        super(TreePrinter.identity());
        this.code = "/*<<<<START>>>>*/" + code + "/*" + SNIPPET_MARKER_END + "*/";
        this.coordinates = coordinates;
        this.changing = changing;
        this.imports = imports;
    }

    @Override
    @Nullable
    public J visit(@Nullable Tree tree, Cursor insertionScope) {
        if (this.coordinates.isReplaceWholeCursorValue() && tree != null && tree.getId().equals(this.coordinates.getTree().getId())) {
            this.printTemplate();
            return (J)tree;
        }
        if (tree != null && tree.getId().equals(this.changing.getId())) {
            return super.visit(this.changing, insertionScope);
        }
        return super.visit(tree, insertionScope);
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, Cursor insertionScope) {
        this.visitSpace(cu.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, insertionScope);
        this.visitRightPadded(cu.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, ";", insertionScope);
        if (!this.imports.isEmpty()) {
            this.getPrinter().append("\n\n");
            for (String impoort : this.imports) {
                this.getPrinter().append(impoort);
            }
        }
        this.visitRightPadded(cu.getPadding().getImports(), JRightPadded.Location.IMPORT, ";", insertionScope);
        StringBuilder acc = this.getPrinter();
        if (!cu.getImports().isEmpty()) {
            acc.append(";");
        }
        this.visit(cu.getClasses(), insertionScope);
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, insertionScope);
        return cu;
    }

    @Override
    public J visitBlock(J.Block block, Cursor insertionScope) {
        Cursor parent = this.getCursor().dropParentUntil(J.class::isInstance);
        if (!insertionScope.isScopeInPath((Tree)block) && !(parent.getValue() instanceof J.ClassDeclaration)) {
            J.Block b = block.withStatements(Collections.emptyList());
            return super.visitBlock(b, insertionScope);
        }
        if (this.coordinates.getTree().getId().equals(block.getId()) && Space.Location.BLOCK_PREFIX.equals((Object)this.coordinates.getSpaceLocation())) {
            J.Block b = block.withStatements(Collections.emptyList());
            return super.visitBlock(b, insertionScope);
        }
        J.Block b = block;
        if (!(parent.getValue() instanceof J.ClassDeclaration)) {
            if (b.getStatements().stream().anyMatch(arg_0 -> ((Cursor)insertionScope).isScopeInPath(arg_0))) {
                ArrayList<Statement> statementsInScope = new ArrayList<Statement>();
                for (Statement statement : b.getStatements()) {
                    statementsInScope.add(statement);
                    if (!insertionScope.isScopeInPath((Tree)statement)) continue;
                    break;
                }
                b = b.withStatements(statementsInScope);
            }
        }
        return super.visitBlock(b, insertionScope);
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, Cursor cursor) {
        J j = (J)this.getCursor().firstEnclosing(J.class);
        if (loc == this.coordinates.getSpaceLocation() && j != null && this.coordinates.getTree().getId().equals(j.getId())) {
            this.printTemplate();
        }
        return super.visitSpace(space, loc, cursor);
    }

    @Override
    public J visitClassDeclaration(J.ClassDeclaration classDecl, Cursor insertionScope) {
        if (!insertionScope.isScopeInPath((Tree)classDecl)) {
            return super.visitClassDeclaration(classDecl.withLeadingAnnotations(Collections.emptyList()), insertionScope);
        }
        if (!classDecl.getId().equals(this.coordinates.getTree().getId())) {
            return super.visitClassDeclaration(classDecl, insertionScope);
        }
        String kind = "";
        switch (classDecl.getKind()) {
            case Class: {
                kind = "class";
                break;
            }
            case Enum: {
                kind = "enum";
                break;
            }
            case Interface: {
                kind = "interface";
                break;
            }
            case Annotation: {
                kind = "@interface";
            }
        }
        this.visitSpace(classDecl.getPrefix(), Space.Location.CLASS_DECLARATION_PREFIX, insertionScope);
        if (Space.Location.ANNOTATIONS.equals((Object)this.coordinates.getSpaceLocation())) {
            if (this.coordinates.isReplacement()) {
                this.printTemplate();
            } else {
                this.printTemplate();
                this.visit(classDecl.getLeadingAnnotations(), insertionScope);
            }
        } else {
            this.visit(classDecl.getLeadingAnnotations(), insertionScope);
        }
        this.visitModifiers(classDecl.getModifiers(), insertionScope);
        this.visitSpace(classDecl.getAnnotations().getKind().getPrefix(), Space.Location.CLASS_KIND, insertionScope);
        StringBuilder acc = this.getPrinter();
        acc.append(kind);
        this.visit((Tree)classDecl.getName(), insertionScope);
        if (this.coordinates.isReplacement() && Space.Location.TYPE_PARAMETERS.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            this.visitContainer("<", classDecl.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", insertionScope);
        }
        if (this.coordinates.isReplacement() && Space.Location.EXTENDS.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            this.visitLeftPadded("extends", classDecl.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, insertionScope);
        }
        if (this.coordinates.isReplacement() && Space.Location.IMPLEMENTS.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            this.visitContainer(classDecl.getKind().equals((Object)J.ClassDeclaration.Kind.Type.Interface) ? "extends" : "implements", classDecl.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, ",", null, insertionScope);
        }
        if (this.coordinates.isReplacement() && Space.Location.BLOCK_PREFIX.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            this.visit((Tree)classDecl.getBody(), insertionScope);
        }
        return classDecl;
    }

    @Override
    public J visitMethodDeclaration(J.MethodDeclaration method, Cursor insertionScope) {
        if (!insertionScope.isScopeInPath((Tree)method)) {
            return super.visitMethodDeclaration(method.withLeadingAnnotations(Collections.emptyList()).withBody(EMPTY_BLOCK), insertionScope);
        }
        this.visitSpace(method.getPrefix(), Space.Location.METHOD_DECLARATION_PREFIX, insertionScope);
        if (Space.Location.ANNOTATIONS.equals((Object)this.coordinates.getSpaceLocation())) {
            if (this.coordinates.isReplacement()) {
                this.printTemplate();
            } else {
                this.printTemplate();
                this.visit(method.getLeadingAnnotations(), insertionScope);
            }
        } else {
            this.visit(method.getLeadingAnnotations(), insertionScope);
        }
        this.visitModifiers(method.getModifiers(), insertionScope);
        if (this.coordinates.isReplacement() && Space.Location.TYPE_PARAMETERS.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
            if (typeParameters != null) {
                this.visit(typeParameters.getAnnotations(), insertionScope);
                this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, insertionScope);
                StringBuilder acc = this.getPrinter();
                acc.append("<");
                this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", insertionScope);
                acc.append(">");
            }
        }
        this.visit((Tree)method.getReturnTypeExpression(), insertionScope);
        this.visit((Tree)method.getName(), insertionScope);
        if (this.coordinates.isReplacement() && Space.Location.METHOD_DECLARATION_PARAMETERS.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", insertionScope);
        }
        if (this.coordinates.isReplacement() && Space.Location.THROWS.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            this.visitContainer("throws", method.getPadding().getThrows(), JContainer.Location.THROWS, ",", null, insertionScope);
        }
        if (this.coordinates.isReplacement() && Space.Location.BLOCK_PREFIX.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            this.visit((Tree)method.getBody(), insertionScope);
        }
        this.visitLeftPadded("default", method.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, insertionScope);
        return method;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, Cursor insertionScope) {
        if (!insertionScope.isScopeInPath((Tree)method)) {
            return super.visitMethodInvocation(method, insertionScope);
        }
        this.visitSpace(method.getPrefix(), Space.Location.METHOD_INVOCATION_PREFIX, insertionScope);
        this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, ".", insertionScope);
        if (this.coordinates.isReplacement() && Space.Location.TYPE_PARAMETERS.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", insertionScope);
        }
        this.visit((Tree)method.getName(), insertionScope);
        if (this.coordinates.isReplacement() && Space.Location.METHOD_INVOCATION_ARGUMENTS.equals((Object)this.coordinates.getSpaceLocation())) {
            this.printTemplate();
        } else {
            this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", insertionScope);
        }
        return method;
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, Cursor insertionScope) {
        if (!insertionScope.isScopeInPath((Tree)multiVariable)) {
            return super.visitVariableDeclarations(multiVariable.withLeadingAnnotations(Collections.emptyList()), insertionScope);
        }
        if (!multiVariable.getId().equals(this.coordinates.getTree().getId())) {
            return super.visitVariableDeclarations(multiVariable.withLeadingAnnotations(Collections.emptyList()), insertionScope);
        }
        StringBuilder acc = this.getPrinter();
        this.visitSpace(multiVariable.getPrefix(), Space.Location.VARIABLE_DECLARATIONS_PREFIX, insertionScope);
        if (Space.Location.ANNOTATIONS.equals((Object)this.coordinates.getSpaceLocation())) {
            if (this.coordinates.isReplacement()) {
                this.printTemplate();
            } else {
                this.printTemplate();
                this.visit(multiVariable.getLeadingAnnotations(), insertionScope);
            }
        } else {
            this.visit(multiVariable.getLeadingAnnotations(), insertionScope);
        }
        this.visitModifiers(multiVariable.getModifiers(), insertionScope);
        this.visit((Tree)multiVariable.getTypeExpression(), insertionScope);
        for (JLeftPadded<Space> dim : multiVariable.getDimensionsBeforeName()) {
            this.visitSpace(dim.getBefore(), Space.Location.DIMENSION_PREFIX, insertionScope);
            acc.append('[');
            this.visitSpace(dim.getElement(), Space.Location.DIMENSION, insertionScope);
            acc.append(']');
        }
        if (multiVariable.getVarargs() != null) {
            this.visitSpace(multiVariable.getVarargs(), Space.Location.VARARGS, insertionScope);
            acc.append("...");
        }
        this.visitRightPadded(multiVariable.getPadding().getVariables(), JRightPadded.Location.NAMED_VARIABLE, ",", insertionScope);
        return multiVariable;
    }

    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Cursor insertionScope) {
        if (!insertionScope.isScopeInPath((Tree)variable)) {
            return (J.VariableDeclarations.NamedVariable)super.visitVariable(variable.withInitializer(null), insertionScope);
        }
        return (J.VariableDeclarations.NamedVariable)super.visitVariable(variable, insertionScope);
    }

    public static Cursor findCoordinateCursor(Cursor parentScope, Tree changing, JavaCoordinates coordinates) {
        AtomicReference<Cursor> cursorReference = new AtomicReference<Cursor>(parentScope);
        new ExtractInsertionCursor(coordinates, parentScope).visit(changing, cursorReference);
        return cursorReference.get();
    }

    private void printTemplate() {
        this.getPrinter().append(this.code);
    }

    private static class ExtractInsertionCursor
    extends JavaVisitor<AtomicReference<Cursor>> {
        private final UUID insertionId;

        private ExtractInsertionCursor(JavaCoordinates coordinates, Cursor parent) {
            this.insertionId = coordinates.getTree().getId();
            this.setCursor(parent);
        }

        @Nullable
        public J visit(@Nullable Tree tree, AtomicReference<Cursor> cursorReference) {
            if (tree != null && tree.getId().equals(this.insertionId)) {
                cursorReference.set(this.getCursor());
            }
            return (J)super.visit(tree, cursorReference);
        }
    }
}

