/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class ChangePackage
extends Recipe {
    private final String oldFullyQualifiedPackageName;
    private final String newFullyQualifiedPackageName;
    private final boolean recursive;

    @JsonCreator
    public ChangePackage(String oldFullyQualifiedPackageName, String newFullyQualifiedPackageName, boolean recursive) {
        this.oldFullyQualifiedPackageName = oldFullyQualifiedPackageName;
        this.newFullyQualifiedPackageName = newFullyQualifiedPackageName;
        this.recursive = recursive;
    }

    public ChangePackage(String oldFullyQualifiedPackageName, String newFullyQualifiedPackageName) {
        this(oldFullyQualifiedPackageName, newFullyQualifiedPackageName, true);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTemplate newPackageExpr = this.template("package #{}").build();

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext context) {
                J c = super.visitCompilationUnit(cu, context);
                String changingTo = (String)this.getCursor().getMessage("changingTo");
                if (changingTo != null) {
                    String path = ((J.CompilationUnit)c).getSourcePath().toString();
                    c = ((J.CompilationUnit)c).withSourcePath(Paths.get(path.replaceFirst(ChangePackage.this.oldFullyQualifiedPackageName.replace('.', '/'), changingTo.replace('.', '/')), new String[0]));
                }
                return c;
            }

            @Override
            public J.Package visitPackage(J.Package pkg, ExecutionContext context) {
                String original = pkg.getExpression().printTrimmed().replaceAll("\\s", "");
                if (original.equals(ChangePackage.this.oldFullyQualifiedPackageName)) {
                    this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "changingTo", (Object)ChangePackage.this.newFullyQualifiedPackageName);
                    return (J.Package)pkg.withTemplate(this.newPackageExpr, pkg.getCoordinates().replace(), ChangePackage.this.newFullyQualifiedPackageName);
                }
                if (ChangePackage.this.recursive && original.startsWith(ChangePackage.this.oldFullyQualifiedPackageName)) {
                    String changingTo = ChangePackage.this.newFullyQualifiedPackageName + original.substring(ChangePackage.this.oldFullyQualifiedPackageName.length());
                    this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "changingTo", (Object)changingTo);
                    return (J.Package)pkg.withTemplate(this.newPackageExpr, pkg.getCoordinates().replace(), changingTo);
                }
                return pkg;
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext context) {
                String changingTo = (String)this.getCursor().getNearestMessage("changingTo");
                JavaType.Class classType = classDecl.getType();
                if (changingTo != null && classType != null) {
                    String fqn = classType.getFullyQualifiedName();
                    ChangePackage.this.doNext(new ChangeType(fqn, changingTo + '.' + classType.getClassName()));
                }
                return super.visitClassDeclaration(classDecl, context);
            }
        };
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackage)) {
            return false;
        }
        ChangePackage other = (ChangePackage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isRecursive() != other.isRecursive()) {
            return false;
        }
        String this$oldFullyQualifiedPackageName = this.getOldFullyQualifiedPackageName();
        String other$oldFullyQualifiedPackageName = other.getOldFullyQualifiedPackageName();
        if (this$oldFullyQualifiedPackageName == null ? other$oldFullyQualifiedPackageName != null : !this$oldFullyQualifiedPackageName.equals(other$oldFullyQualifiedPackageName)) {
            return false;
        }
        String this$newFullyQualifiedPackageName = this.getNewFullyQualifiedPackageName();
        String other$newFullyQualifiedPackageName = other.getNewFullyQualifiedPackageName();
        return !(this$newFullyQualifiedPackageName == null ? other$newFullyQualifiedPackageName != null : !this$newFullyQualifiedPackageName.equals(other$newFullyQualifiedPackageName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRecursive() ? 79 : 97);
        String $oldFullyQualifiedPackageName = this.getOldFullyQualifiedPackageName();
        result = result * 59 + ($oldFullyQualifiedPackageName == null ? 43 : $oldFullyQualifiedPackageName.hashCode());
        String $newFullyQualifiedPackageName = this.getNewFullyQualifiedPackageName();
        result = result * 59 + ($newFullyQualifiedPackageName == null ? 43 : $newFullyQualifiedPackageName.hashCode());
        return result;
    }

    public String getOldFullyQualifiedPackageName() {
        return this.oldFullyQualifiedPackageName;
    }

    public String getNewFullyQualifiedPackageName() {
        return this.newFullyQualifiedPackageName;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @NonNull
    public String toString() {
        return "ChangePackage(oldFullyQualifiedPackageName=" + this.getOldFullyQualifiedPackageName() + ", newFullyQualifiedPackageName=" + this.getNewFullyQualifiedPackageName() + ", recursive=" + this.isRecursive() + ")";
    }
}

