/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.LinkedHashSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ChangeMethodTargetToStatic
extends Recipe {
    private final String methodPattern;
    private final String fullyQualifiedTargetTypeName;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangeMethodTargetToStaticVisitor(new MethodMatcher(this.methodPattern));
    }

    public ChangeMethodTargetToStatic(String methodPattern, String fullyQualifiedTargetTypeName) {
        this.methodPattern = methodPattern;
        this.fullyQualifiedTargetTypeName = fullyQualifiedTargetTypeName;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getFullyQualifiedTargetTypeName() {
        return this.fullyQualifiedTargetTypeName;
    }

    @NonNull
    public String toString() {
        return "ChangeMethodTargetToStatic(methodPattern=" + this.getMethodPattern() + ", fullyQualifiedTargetTypeName=" + this.getFullyQualifiedTargetTypeName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeMethodTargetToStatic)) {
            return false;
        }
        ChangeMethodTargetToStatic other = (ChangeMethodTargetToStatic)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$fullyQualifiedTargetTypeName = this.getFullyQualifiedTargetTypeName();
        String other$fullyQualifiedTargetTypeName = other.getFullyQualifiedTargetTypeName();
        return !(this$fullyQualifiedTargetTypeName == null ? other$fullyQualifiedTargetTypeName != null : !this$fullyQualifiedTargetTypeName.equals(other$fullyQualifiedTargetTypeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeMethodTargetToStatic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $fullyQualifiedTargetTypeName = this.getFullyQualifiedTargetTypeName();
        result = result * 59 + ($fullyQualifiedTargetTypeName == null ? 43 : $fullyQualifiedTargetTypeName.hashCode());
        return result;
    }

    private class ChangeMethodTargetToStaticVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        public ChangeMethodTargetToStaticVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches(method)) {
                JavaType.Class classType = JavaType.Class.build(ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName);
                m = method.withSelect(J.Identifier.build(Tree.randomId(), method.getSelect() == null ? Space.EMPTY : method.getSelect().getPrefix(), Markers.EMPTY, classType.getClassName(), classType));
                this.maybeAddImport(ChangeMethodTargetToStatic.this.fullyQualifiedTargetTypeName);
                JavaType.Method transformedType = null;
                if (method.getType() != null) {
                    this.maybeRemoveImport(method.getType().getDeclaringType());
                    transformedType = method.getType().withDeclaringType(classType);
                    if (!method.getType().hasFlags(Flag.Static)) {
                        LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(method.getType().getFlags());
                        flags.add(Flag.Static);
                        transformedType = transformedType.withFlags(flags);
                    }
                }
                m = ((J.MethodInvocation)m).withType(transformedType);
            }
            return m;
        }
    }
}

