/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class RemoveImport<P>
extends JavaIsoVisitor<P> {
    private static final J.Block EMPTY_BLOCK = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded<Boolean>(false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.EMPTY);
    private final String type;
    private final JavaType.Class classType;
    private final MethodMatcher methodMatcher;
    @Nullable
    private J.Import namedImport;
    @Nullable
    private J.Import starImport;
    @Nullable
    private J.Import staticStarImport;
    private final Set<String> referencedTypes = new HashSet<String>();
    private final Set<J.Identifier> referencedMethods = new HashSet<J.Identifier>();
    private final Set<String> referencedFields = new HashSet<String>();
    private final Set<J.Import> staticNamedImports = Collections.newSetFromMap(new IdentityHashMap());

    public RemoveImport(String type) {
        this.type = type;
        this.methodMatcher = new MethodMatcher(type + " *(..)");
        this.classType = JavaType.Class.build(type);
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        this.namedImport = null;
        this.starImport = null;
        this.staticStarImport = null;
        this.referencedTypes.clear();
        this.referencedMethods.clear();
        this.referencedFields.clear();
        this.staticNamedImports.clear();
        J c = super.visitCompilationUnit(cu, (Object)p);
        J.CompilationUnit temp = this.staticImportDeletions(this.classImportDeletions((J.CompilationUnit)c));
        if (temp != c) {
            Cursor cursor = new Cursor(null, (Object)temp);
            if (!(temp = temp.withImports(ListUtils.map(temp.getImports(), i -> this.autoFormat(i, p, cursor)))).getClasses().isEmpty()) {
                temp = temp.withClasses(ListUtils.mapFirst(temp.getClasses(), firstClass -> {
                    J.ClassDeclaration tempClass = this.autoFormat(firstClass.withBody(EMPTY_BLOCK), p, cursor);
                    return firstClass.withPrefix(tempClass.getPrefix());
                }));
            }
            c = temp;
        }
        return c;
    }

    @Override
    public J.Import visitImport(J.Import impoort, P p) {
        if (impoort.isStatic()) {
            if (impoort.getQualid().getTarget().printTrimmed().equals(this.type) || impoort.getQualid().printTrimmed().equals(this.type)) {
                if ("*".equals(impoort.getQualid().getSimpleName())) {
                    this.staticStarImport = impoort;
                } else {
                    this.staticNamedImports.add(impoort);
                }
            }
        } else if (impoort.getQualid().printTrimmed().equals(this.type)) {
            this.namedImport = impoort;
        } else if ("*".equals(impoort.getQualid().getSimpleName()) && this.type.startsWith(impoort.getQualid().getTarget().printTrimmed())) {
            this.starImport = impoort;
        }
        return super.visitImport(impoort, (Object)p);
    }

    @Override
    public <N extends NameTree> N visitTypeName(N name, P p) {
        JavaType.Class asClass = TypeUtils.asClass(name.getType());
        if (asClass != null && asClass.getPackageName().equals(this.classType.getPackageName())) {
            if (this.getCursor().getPathAsStream().noneMatch(J.Import.class::isInstance)) {
                this.referencedTypes.add(asClass.getFullyQualifiedName());
            }
        }
        return super.visitTypeName(name, p);
    }

    @Override
    public J.Identifier visitIdentifier(J.Identifier ident, P p) {
        if (this.getCursor().getPathAsStream().noneMatch(J.Import.class::isInstance)) {
            this.referencedFields.add(ident.getSimpleName());
        }
        return super.visitIdentifier(ident, (Object)p);
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        if (this.methodMatcher.matches(method) && method.getType() != null && method.getType().getDeclaringType().getFullyQualifiedName().equals(this.type)) {
            this.referencedMethods.add(method.getName());
        }
        return super.visitMethodInvocation(method, (Object)p);
    }

    private J.CompilationUnit classImportDeletions(J.CompilationUnit cu) {
        if (this.namedImport != null && this.referencedTypes.stream().noneMatch(t -> t.equals(this.type))) {
            return this.delete(cu, this.namedImport);
        }
        if (this.starImport != null && this.referencedTypes.isEmpty()) {
            return this.delete(cu, this.starImport);
        }
        if (this.starImport != null && this.referencedTypes.size() == 1) {
            return cu.getPadding().withImports(ListUtils.map(cu.getPadding().getImports(), im -> im.map(i -> i == this.starImport ? new J.Import(Tree.randomId(), i.getPrefix(), Markers.EMPTY, new JLeftPadded<Boolean>(Space.EMPTY, false, Markers.EMPTY), (J.FieldAccess)TypeTree.build(this.referencedTypes.iterator().next()).withPrefix(Space.format(" "))) : i)));
        }
        return cu;
    }

    private J.CompilationUnit staticImportDeletions(J.CompilationUnit cu) {
        if (this.staticStarImport != null) {
            JavaType.Class qualidType = TypeUtils.asClass(this.staticStarImport.getQualid().getTarget().getType());
            if (this.referencedMethods.isEmpty() && this.noFieldReferences(qualidType, null)) {
                cu = this.delete(cu, this.staticStarImport);
            }
        }
        for (J.Import staticImport : this.staticNamedImports) {
            String methodOrField = staticImport.getQualid().getSimpleName();
            JavaType.Class qualidType = TypeUtils.asClass(staticImport.getQualid().getTarget().getType());
            if (!this.referencedMethods.stream().noneMatch(m -> m.getSimpleName().equals(methodOrField)) || !this.noFieldReferences(qualidType, methodOrField)) continue;
            cu = this.delete(cu, staticImport);
        }
        return cu;
    }

    private boolean noFieldReferences(@Nullable JavaType.Class qualidType, @Nullable String fieldName) {
        return qualidType == null || (fieldName != null ? !this.referencedFields.contains(fieldName) : this.referencedFields.stream().noneMatch(f -> qualidType.getMembers().stream().anyMatch(v -> f.equals(v.getName())) || qualidType.getVisibleSupertypeMembers().stream().anyMatch(v -> f.equals(v.getName()))));
    }

    private J.CompilationUnit delete(J.CompilationUnit cu, J.Import impoort) {
        return cu.getPadding().withImports(ListUtils.map(cu.getPadding().getImports(), i -> i.getElement() == impoort ? null : i));
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveImport)) {
            return false;
        }
        RemoveImport other = (RemoveImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

