/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.TypeUtils;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, property="@c")
public interface JavaType
extends Serializable {
    public boolean deepEquals(@Nullable JavaType var1);

    public static JavaType buildType(String typeName) {
        Primitive primitive = Primitive.fromKeyword(typeName);
        if (primitive != null) {
            return primitive;
        }
        return Class.build(typeName);
    }

    public static enum Primitive implements JavaType
    {
        Boolean("boolean"),
        Byte("byte"),
        Char("char"),
        Double("double"),
        Float("float"),
        Int("int"),
        Long("long"),
        Short("short"),
        Void("void"),
        String("String"),
        None(""),
        Wildcard("*"),
        Null("null");

        private final String keyword;

        private Primitive(String keyword) {
            this.keyword = keyword;
        }

        @Nullable
        public static Primitive fromKeyword(String keyword) {
            for (Primitive p : Primitive.values()) {
                if (!p.keyword.equals(keyword)) continue;
                return p;
            }
            return null;
        }

        public String getKeyword() {
            return this.keyword;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return this == type;
        }
    }

    public static class Array
    implements JavaType {
        @Nullable
        private final JavaType elemType;

        public Array(@Nullable JavaType elemType) {
            this.elemType = elemType;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return type instanceof Array && (this == type || this.elemType != null && this.elemType.deepEquals(((Array)type).elemType));
        }

        public JavaType getElemType() {
            return this.elemType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Array)) {
                return false;
            }
            Array other = (Array)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JavaType this$elemType = this.getElemType();
            JavaType other$elemType = other.getElemType();
            return !(this$elemType == null ? other$elemType != null : !this$elemType.equals(other$elemType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Array;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JavaType $elemType = this.getElemType();
            result = result * 59 + ($elemType == null ? 43 : $elemType.hashCode());
            return result;
        }

        public String toString() {
            return "JavaType.Array(elemType=" + this.getElemType() + ")";
        }
    }

    public static class GenericTypeVariable
    extends FullyQualified {
        private final String fullyQualifiedName;
        @Nullable
        private final Class bound;

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof GenericTypeVariable)) {
                return false;
            }
            GenericTypeVariable generic = (GenericTypeVariable)type;
            return this == generic || this.fullyQualifiedName.equals(generic.fullyQualifiedName) && TypeUtils.deepEquals(this.bound, generic.bound);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericTypeVariable)) {
                return false;
            }
            GenericTypeVariable other = (GenericTypeVariable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) {
                return false;
            }
            Class this$bound = this.getBound();
            Class other$bound = other.getBound();
            return !(this$bound == null ? other$bound != null : !this$bound.equals(other$bound));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenericTypeVariable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            Class $bound = this.getBound();
            result = result * 59 + ($bound == null ? 43 : $bound.hashCode());
            return result;
        }

        public GenericTypeVariable(String fullyQualifiedName, Class bound) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.bound = bound;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public Class getBound() {
            return this.bound;
        }

        public String toString() {
            return "JavaType.GenericTypeVariable(fullyQualifiedName=" + this.getFullyQualifiedName() + ", bound=" + this.getBound() + ")";
        }
    }

    public static class Method
    implements JavaType {
        private static final Map<FullyQualified, Map<String, Set<Method>>> flyweights = new WeakHashMap<FullyQualified, Map<String, Set<Method>>>();
        private final FullyQualified declaringType;
        private final String name;
        private final Signature genericSignature;
        private final Signature resolvedSignature;
        private final List<String> paramNames;
        private final Set<Flag> flags;

        private Method(FullyQualified declaringType, String name, Signature genericSignature, Signature resolvedSignature, List<String> paramNames, Set<Flag> flags) {
            this.declaringType = declaringType;
            this.name = name;
            this.genericSignature = genericSignature;
            this.resolvedSignature = resolvedSignature;
            this.paramNames = paramNames;
            this.flags = flags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JsonCreator
        public static Method build(FullyQualified declaringType, String name, Signature genericSignature, Signature resolvedSignature, List<String> paramNames, Set<Flag> flags) {
            Method test = new Method(declaringType, name, genericSignature, resolvedSignature, paramNames, flags);
            Map<FullyQualified, Map<String, Set<Method>>> map = flyweights;
            synchronized (map) {
                Set methods = flyweights.computeIfAbsent(declaringType, dt -> new HashMap()).computeIfAbsent(name, n -> new HashSet());
                return methods.stream().filter(m -> m.deepEquals(test)).findAny().orElseGet(() -> {
                    methods.add(test);
                    return test;
                });
            }
        }

        private static boolean signatureDeepEquals(@Nullable Signature s1, @Nullable Signature s2) {
            return s1 == null ? s2 == null : s1 == s2 || s2 != null && TypeUtils.deepEquals(s1.returnType, s2.returnType) && TypeUtils.deepEquals(s1.paramTypes, s2.paramTypes);
        }

        public boolean hasFlags(Flag ... test) {
            for (Flag flag : test) {
                if (this.flags.contains((Object)flag)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof Method)) {
                return false;
            }
            Method m = (Method)type;
            return this == m || this.paramNames.equals(m.paramNames) && this.flags.equals(m.flags) && this.declaringType.deepEquals(m.declaringType) && Method.signatureDeepEquals(this.genericSignature, m.genericSignature) && Method.signatureDeepEquals(this.resolvedSignature, m.resolvedSignature);
        }

        public FullyQualified getDeclaringType() {
            return this.declaringType;
        }

        public String getName() {
            return this.name;
        }

        public Signature getGenericSignature() {
            return this.genericSignature;
        }

        public Signature getResolvedSignature() {
            return this.resolvedSignature;
        }

        public List<String> getParamNames() {
            return this.paramNames;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        public Method withDeclaringType(FullyQualified declaringType) {
            return this.declaringType == declaringType ? this : new Method(declaringType, this.name, this.genericSignature, this.resolvedSignature, this.paramNames, this.flags);
        }

        public Method withFlags(Set<Flag> flags) {
            return this.flags == flags ? this : new Method(this.declaringType, this.name, this.genericSignature, this.resolvedSignature, this.paramNames, flags);
        }

        public static class Signature
        implements Serializable {
            @Nullable
            private final JavaType returnType;
            private final List<JavaType> paramTypes;

            public Signature(JavaType returnType, List<JavaType> paramTypes) {
                this.returnType = returnType;
                this.paramTypes = paramTypes;
            }

            public JavaType getReturnType() {
                return this.returnType;
            }

            public List<JavaType> getParamTypes() {
                return this.paramTypes;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Signature)) {
                    return false;
                }
                Signature other = (Signature)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                JavaType this$returnType = this.getReturnType();
                JavaType other$returnType = other.getReturnType();
                if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
                    return false;
                }
                List<JavaType> this$paramTypes = this.getParamTypes();
                List<JavaType> other$paramTypes = other.getParamTypes();
                return !(this$paramTypes == null ? other$paramTypes != null : !((Object)this$paramTypes).equals(other$paramTypes));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Signature;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                JavaType $returnType = this.getReturnType();
                result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
                List<JavaType> $paramTypes = this.getParamTypes();
                result = result * 59 + ($paramTypes == null ? 43 : ((Object)$paramTypes).hashCode());
                return result;
            }

            public String toString() {
                return "JavaType.Method.Signature(returnType=" + this.getReturnType() + ", paramTypes=" + this.getParamTypes() + ")";
            }
        }
    }

    public static class Var
    implements JavaType {
        private final String name;
        @Nullable
        private final JavaType type;
        private final Set<Flag> flags;

        public boolean hasFlags(Flag ... test) {
            for (Flag flag : test) {
                if (this.flags.contains((Object)flag)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof Var)) {
                return false;
            }
            Var v = (Var)type;
            return this == v || this.name.equals(v.name) && TypeUtils.deepEquals(this.type, v.type) && this.flags.equals(v.flags);
        }

        public Var(String name, JavaType type, Set<Flag> flags) {
            this.name = name;
            this.type = type;
            this.flags = flags;
        }

        public String getName() {
            return this.name;
        }

        public JavaType getType() {
            return this.type;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Var)) {
                return false;
            }
            Var other = (Var)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Set<Flag> this$flags = this.getFlags();
            Set<Flag> other$flags = other.getFlags();
            return !(this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Var;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Set<Flag> $flags = this.getFlags();
            result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
            return result;
        }

        public String toString() {
            return "JavaType.Var(name=" + this.getName() + ", type=" + this.getType() + ", flags=" + this.getFlags() + ")";
        }
    }

    public static class Cyclic
    extends FullyQualified {
        private final String fullyQualifiedName;

        public Cyclic(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return this.equals(type);
        }

        public String toString() {
            return "Cyclic{" + this.fullyQualifiedName + '}';
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cyclic)) {
                return false;
            }
            Cyclic other = (Cyclic)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            return !(this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cyclic;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            return result;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }
    }

    public static class Class
    extends FullyQualified {
        private static final Map<String, Set<Class>> flyweights = new WeakHashMap<String, Set<Class>>();
        public static final Class OBJECT = Class.build("java.lang.Object");
        private final String fullyQualifiedName;
        private final List<Var> members;
        private final List<JavaType> typeParameters;
        private final List<JavaType> interfaces;
        @Nullable
        private volatile List<Method> constructors;
        @Nullable
        private final Class supertype;
        private final String flyweightId;

        private Class(String fullyQualifiedName, List<Var> members, List<JavaType> typeParameters, List<JavaType> interfaces, @Nullable List<Method> constructors, @Nullable Class supertype) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.members = members;
            this.typeParameters = typeParameters;
            this.interfaces = interfaces;
            this.constructors = constructors;
            this.supertype = supertype;
            StringBuilder tag = new StringBuilder(fullyQualifiedName);
            if (!typeParameters.isEmpty()) {
                tag.append("<").append(typeParameters.stream().map(Object::toString).collect(Collectors.joining(","))).append(">");
            }
            this.flyweightId = tag.toString();
        }

        public static Class build(String fullyQualifiedName) {
            return Class.build(fullyQualifiedName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, true);
        }

        @JsonCreator
        public static Class build(String fullyQualifiedName, List<Var> members, List<JavaType> typeParameters, List<JavaType> interfaces, List<Method> constructors, @Nullable Class supertype) {
            return Class.build(fullyQualifiedName, members, typeParameters, interfaces, constructors, supertype, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Class build(String fullyQualifiedName, List<Var> members, List<JavaType> typeParameters, List<JavaType> interfaces, @Nullable List<Method> constructors, @Nullable Class supertype, boolean relaxedClassTypeMatching) {
            List<Var> sortedMembers = fullyQualifiedName.equals("java.lang.String") ? members.stream().filter(m -> !m.getName().equals("serialPersistentFields")).collect(Collectors.toList()) : new ArrayList<Var>(members);
            sortedMembers.sort(Comparator.comparing(Var::getName));
            Class candidate = new Class(fullyQualifiedName, sortedMembers, typeParameters, interfaces, constructors, supertype);
            Map<String, Set<Class>> map = flyweights;
            synchronized (map) {
                Set variants = flyweights.computeIfAbsent(candidate.flyweightId, fqn -> new HashSet());
                if (relaxedClassTypeMatching) {
                    if (variants.isEmpty()) {
                        variants.add(candidate);
                        return candidate;
                    }
                    return (Class)variants.iterator().next();
                }
                for (Class v2 : variants) {
                    if (!v2.deepEquals(candidate)) continue;
                    return v2;
                }
                if (candidate.supertype == null) {
                    return variants.stream().filter(v -> v.supertype != null).findFirst().orElseGet(() -> {
                        variants.add(candidate);
                        return candidate;
                    });
                }
                variants.add(candidate);
                return candidate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Method> getConstructors() {
            List<Method> constructorsTemp = this.constructors;
            if (constructorsTemp != null) {
                return constructorsTemp;
            }
            Map<String, Set<Class>> map = flyweights;
            synchronized (map) {
                constructorsTemp = this.constructors;
                if (constructorsTemp != null) {
                    return constructorsTemp;
                }
                ArrayList<Method> reflectedConstructors = new ArrayList<Method>();
                try {
                    java.lang.Class<?> reflectionClass = java.lang.Class.forName(this.fullyQualifiedName, false, JavaType.class.getClassLoader());
                    for (Constructor<?> constructor : reflectionClass.getConstructors()) {
                        ShallowClass selfType = new ShallowClass(this.fullyQualifiedName);
                        Method.Signature resolvedSignature = new Method.Signature(selfType, Arrays.stream(constructor.getParameterTypes()).map(Class::resolveTypeFromClass).collect(Collectors.toList()));
                        List<String> parameterNames = Arrays.stream(constructor.getParameters()).map(Parameter::getName).collect(Collectors.toList());
                        reflectedConstructors.add(Method.build(selfType, "<reflection_constructor>", resolvedSignature, resolvedSignature, parameterNames, Collections.singleton(Flag.Public)));
                    }
                    this.constructors = reflectedConstructors;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return reflectedConstructors;
            }
        }

        private static JavaType resolveTypeFromClass(java.lang.Class<?> _class) {
            if (!_class.isPrimitive() && !_class.isArray()) {
                return Class.build(_class.getName());
            }
            if (_class.isPrimitive()) {
                if (_class == Boolean.TYPE) {
                    return Primitive.Boolean;
                }
                if (_class == String.class) {
                    return Primitive.String;
                }
                if (_class == Integer.TYPE) {
                    return Primitive.Int;
                }
                if (_class == Long.TYPE) {
                    return Primitive.Long;
                }
                if (_class == Double.TYPE) {
                    return Primitive.Double;
                }
                if (_class == Character.TYPE) {
                    return Primitive.Char;
                }
                if (_class == Byte.TYPE) {
                    return Primitive.Byte;
                }
                if (_class == Float.TYPE) {
                    return Primitive.Float;
                }
                if (_class == Short.TYPE) {
                    return Primitive.Short;
                }
                throw new IllegalArgumentException("Unknown primitive argument");
            }
            return new Array(Class.resolveTypeFromClass(_class.getComponentType()));
        }

        public List<Var> getVisibleSupertypeMembers() {
            ArrayList<Var> members = new ArrayList<Var>();
            if (this.supertype != null) {
                for (Var member : this.supertype.getMembers()) {
                    if (member.hasFlags(Flag.Private)) continue;
                    members.add(member);
                }
                members.addAll(this.supertype.getVisibleSupertypeMembers());
            }
            return members;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof Class)) {
                return false;
            }
            Class c = (Class)type;
            return this == c || this.fullyQualifiedName.equals(c.fullyQualifiedName) && TypeUtils.deepEquals(this.members, c.members) && TypeUtils.deepEquals(this.supertype, c.supertype) && TypeUtils.deepEquals(this.typeParameters, c.typeParameters);
        }

        public String toString() {
            return "Class{" + this.fullyQualifiedName + '}';
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public List<Var> getMembers() {
            return this.members;
        }

        public List<JavaType> getTypeParameters() {
            return this.typeParameters;
        }

        public List<JavaType> getInterfaces() {
            return this.interfaces;
        }

        public Class getSupertype() {
            return this.supertype;
        }

        public String getFlyweightId() {
            return this.flyweightId;
        }
    }

    public static class ShallowClass
    extends FullyQualified {
        private final String fullyQualifiedName;

        public ShallowClass(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return this == type || type instanceof ShallowClass && this.fullyQualifiedName.equals(((ShallowClass)type).fullyQualifiedName);
        }

        public String toString() {
            return "ShallowClass(" + this.fullyQualifiedName + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShallowClass)) {
                return false;
            }
            ShallowClass other = (ShallowClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            return !(this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ShallowClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            return result;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }
    }

    public static abstract class FullyQualified
    implements JavaType {
        public abstract String getFullyQualifiedName();

        public String getClassName() {
            AtomicBoolean dropWhile = new AtomicBoolean(false);
            return Arrays.stream(this.getFullyQualifiedName().split("\\.")).filter(part -> {
                dropWhile.set(dropWhile.get() || !Character.isLowerCase(part.charAt(0)));
                return dropWhile.get();
            }).collect(Collectors.joining("."));
        }

        public String getPackageName() {
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            return Arrays.stream(this.getFullyQualifiedName().split("\\.")).filter(part -> {
                takeWhile.set(takeWhile.get() && !Character.isUpperCase(part.charAt(0)));
                return takeWhile.get();
            }).collect(Collectors.joining("."));
        }

        public boolean isAssignableFrom(@Nullable Class clazz) {
            return clazz != null && (this == Class.OBJECT || this.getFullyQualifiedName().equals(clazz.fullyQualifiedName) || this.isAssignableFrom(clazz.getSupertype()) || clazz.getInterfaces().stream().anyMatch(i -> i instanceof Class && this.isAssignableFrom((Class)i)));
        }
    }

    public static class MultiCatch
    implements JavaType {
        private final List<JavaType> throwableTypes;

        public MultiCatch(List<JavaType> throwableTypes) {
            this.throwableTypes = throwableTypes;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return this == type || type instanceof MultiCatch && TypeUtils.deepEquals(this.throwableTypes, ((MultiCatch)type).throwableTypes);
        }

        public List<JavaType> getThrowableTypes() {
            return this.throwableTypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiCatch)) {
                return false;
            }
            MultiCatch other = (MultiCatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<JavaType> this$throwableTypes = this.getThrowableTypes();
            List<JavaType> other$throwableTypes = other.getThrowableTypes();
            return !(this$throwableTypes == null ? other$throwableTypes != null : !((Object)this$throwableTypes).equals(other$throwableTypes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MultiCatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<JavaType> $throwableTypes = this.getThrowableTypes();
            result = result * 59 + ($throwableTypes == null ? 43 : ((Object)$throwableTypes).hashCode());
            return result;
        }

        public String toString() {
            return "JavaType.MultiCatch(throwableTypes=" + this.getThrowableTypes() + ")";
        }
    }
}

