/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

public class ImportLayoutStyle
implements JavaStyle {
    private final int classCountToUseStarImport;
    private final int nameCountToUseStarImport;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonDeserialize(using=BlockDeserializer.class)
    @JsonSerialize(using=BlockSerializer.class)
    private final List<Block> layout;

    public ImportLayoutStyle(@JsonProperty(value="classCountToUseStarImport") int classCountToUseStarImport, @JsonProperty(value="nameCountToUseStarImport") int nameCountToUseStarImport, @JsonProperty(value="layout") List<Block> layout) {
        this.classCountToUseStarImport = classCountToUseStarImport;
        this.nameCountToUseStarImport = nameCountToUseStarImport;
        this.layout = layout;
    }

    public List<JRightPadded<J.Import>> orderImports(List<JRightPadded<J.Import>> originalImports) {
        ArrayList<JRightPadded<J.Import>> orderedImports = new ArrayList<JRightPadded<J.Import>>();
        assert (this.layout.stream().anyMatch(it -> it instanceof Block.AllOthers && ((Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all static imports, but no such block was found in the specified layout";
        assert (this.layout.stream().anyMatch(it -> it instanceof Block.AllOthers && !((Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all non-static imports, but no such block was found in the specified layout";
        Map<Boolean, List<Block>> blockGroups = this.layout.stream().collect(Collectors.partitioningBy(block -> block instanceof Block.AllOthers));
        List<Block> blocksNoCatchalls = blockGroups.get(false);
        List<Block> blocksOnlyCatchalls = blockGroups.get(true);
        for (JRightPadded<J.Import> anImport : originalImports) {
            boolean accepted = false;
            for (Block block2 : blocksNoCatchalls) {
                if (!block2.accept(anImport)) continue;
                accepted = true;
                break;
            }
            if (accepted) continue;
            for (Block block2 : blocksOnlyCatchalls) {
                if (block2.accept(anImport)) break;
            }
        }
        int importIndex = 0;
        String extraLineSpace = "";
        for (Block block3 : this.layout) {
            if (block3 instanceof Block.BlankLines) {
                extraLineSpace = "";
                for (int i = 0; i < ((Block.BlankLines)block3).getCount(); ++i) {
                    extraLineSpace = extraLineSpace + "\n";
                }
                continue;
            }
            for (JRightPadded<J.Import> orderedImport : block3.orderedImports()) {
                Space prefix;
                Space space = prefix = importIndex == 0 ? originalImports.get(0).getElement().getPrefix() : orderedImport.getElement().getPrefix().withWhitespace(extraLineSpace + "\n");
                if (!orderedImport.getElement().getPrefix().equals(prefix)) {
                    orderedImports.add(orderedImport.withElement(orderedImport.getElement().withPrefix(prefix)));
                } else {
                    orderedImports.add(orderedImport);
                }
                extraLineSpace = "";
                ++importIndex;
            }
        }
        return orderedImports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getClassCountToUseStarImport() {
        return this.classCountToUseStarImport;
    }

    public int getNameCountToUseStarImport() {
        return this.nameCountToUseStarImport;
    }

    public List<Block> getLayout() {
        return this.layout;
    }

    private static class BlockSerializer
    extends JsonSerializer<List<Block>> {
        private BlockSerializer() {
        }

        public void serialize(List<Block> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String[] blocks = (String[])value.stream().map(block -> {
                if (block instanceof Block.BlankLines) {
                    return "<blank line>";
                }
                if (block instanceof Block.AllOthers) {
                    return (((Block.AllOthers)block).isStatic() ? "static " : "") + "all other imports";
                }
                if (block instanceof Block.ImportPackage) {
                    Block.ImportPackage importPackage = (Block.ImportPackage)block;
                    return (importPackage.isStatic() ? "static " : "") + "import" + importPackage.getPackageWildcard();
                }
                return new UnsupportedOperationException("Unknown block type " + block.getClass().getName());
            }).toArray(String[]::new);
            gen.writeArray(blocks, 0, value.size());
        }
    }

    private static class BlockDeserializer
    extends JsonDeserializer<List<Block>> {
        private BlockDeserializer() {
        }

        public List<Block> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] blockIter = (String[])p.readValueAs(String[].class);
            Builder builder = ImportLayoutStyle.builder();
            for (String block : blockIter) {
                if ((block = block.trim()).equals("<blank line>")) {
                    builder.blankLine();
                    continue;
                }
                if (block.startsWith("import ")) {
                    block = block.substring("import ".length());
                    boolean statik = false;
                    if (block.startsWith("static")) {
                        statik = true;
                        block = block.substring("static ".length());
                    }
                    if (block.equals("all other imports")) {
                        if (statik) {
                            builder.importStaticAllOthers();
                            continue;
                        }
                        builder.importAllOthers();
                        continue;
                    }
                    if (statik) {
                        builder.staticImportPackage(block);
                        continue;
                    }
                    builder.importPackage(block);
                    continue;
                }
                throw new IllegalArgumentException("Syntax error in layout block [" + block + "]");
            }
            return builder.build().layout;
        }
    }

    public static interface Block {
        public boolean accept(JRightPadded<J.Import> var1);

        public List<JRightPadded<J.Import>> orderedImports();

        public static class AllOthers
        extends ImportPackage {
            private final boolean statik;
            private Collection<ImportPackage> packageImports = Collections.emptyList();

            public AllOthers(boolean statik, int classCountToUseStarImport, int nameCountToUseStarImport) {
                super(statik, "*", true, classCountToUseStarImport, nameCountToUseStarImport);
                this.statik = statik;
            }

            public void setPackageImports(Collection<ImportPackage> packageImports) {
                this.packageImports = packageImports;
            }

            @Override
            public boolean isStatic() {
                return this.statik;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                if (this.packageImports.stream().noneMatch(pi -> pi.accept(anImport))) {
                    super.accept(anImport);
                }
                return anImport.getElement().isStatic() == this.statik;
            }
        }

        public static class ImportPackage
        implements Block {
            static final Comparator<JRightPadded<J.Import>> IMPORT_SORTING = (i1, i2) -> {
                String[] import1 = ((J.Import)i1.getElement()).getQualid().printTrimmed().split("\\.");
                String[] import2 = ((J.Import)i2.getElement()).getQualid().printTrimmed().split("\\.");
                for (int i = 0; i < Math.min(import1.length, import2.length); ++i) {
                    int diff = import1[i].compareTo(import2[i]);
                    if (diff == 0) continue;
                    return diff;
                }
                if (import1.length == import2.length) {
                    return 0;
                }
                return import1.length > import2.length ? 1 : -1;
            };
            private final List<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>();
            private final boolean statik;
            private final Pattern packageWildcard;
            private final int classCountToUseStarImport;
            private final int nameCountToUseStarImport;

            public ImportPackage(boolean statik, String packageWildcard, boolean withSubpackages, int classCountToUseStarImport, int nameCountToUseStarImport) {
                this.statik = statik;
                this.classCountToUseStarImport = classCountToUseStarImport;
                this.nameCountToUseStarImport = nameCountToUseStarImport;
                this.packageWildcard = Pattern.compile(packageWildcard.replace(".", "\\.").replace("*", withSubpackages ? ".+" : "[^.]+"));
            }

            public boolean isStatic() {
                return this.statik;
            }

            public Pattern getPackageWildcard() {
                return this.packageWildcard;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                if (anImport.getElement().isStatic() == this.statik && this.packageWildcard.matcher(anImport.getElement().getQualid().printTrimmed()).matches()) {
                    this.imports.add(anImport);
                    return true;
                }
                return false;
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports() {
                Map groupedImports = this.imports.stream().sorted(IMPORT_SORTING).collect(Collectors.groupingBy(anImport -> {
                    if (((J.Import)anImport.getElement()).isStatic()) {
                        return ((J.Import)anImport.getElement()).getTypeName();
                    }
                    return ((J.Import)anImport.getElement()).getPackageName();
                }, LinkedHashMap::new, Collectors.toList()));
                return groupedImports.values().stream().flatMap(importGroup -> {
                    JRightPadded toStar = (JRightPadded)importGroup.get(0);
                    boolean statik1 = ((J.Import)toStar.getElement()).isStatic();
                    int threshold = statik1 ? this.nameCountToUseStarImport : this.classCountToUseStarImport;
                    boolean starImportExists = importGroup.stream().anyMatch(it -> ((J.Import)it.getElement()).getQualid().getSimpleName().equals("*"));
                    if (importGroup.size() >= threshold || starImportExists && importGroup.size() > 1) {
                        J.FieldAccess qualid = ((J.Import)toStar.getElement()).getQualid();
                        J.Identifier name = qualid.getName();
                        return Stream.of(toStar.withElement(((J.Import)toStar.getElement()).withQualid(qualid.withName(name.withName("*")))));
                    }
                    return importGroup.stream().filter(StreamUtils.distinctBy(t -> ((J.Import)t.getElement()).printTrimmed()));
                }).collect(Collectors.toList());
            }
        }

        public static class BlankLines
        implements Block {
            private int count = 1;

            private int getCount() {
                return this.count;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                return false;
            }

            @Override
            public List<JRightPadded<J.Import>> orderedImports() {
                return Collections.emptyList();
            }
        }
    }

    public static class Builder {
        private final List<Block> blocks = new ArrayList<Block>();
        private int classCountToUseStarImport = 5;
        private int nameCountToUseStarImport = 3;

        public Builder importAllOthers() {
            this.blocks.add(new Block.AllOthers(false, this.classCountToUseStarImport, this.nameCountToUseStarImport));
            return this;
        }

        public Builder importStaticAllOthers() {
            this.blocks.add(new Block.AllOthers(true, this.classCountToUseStarImport, this.nameCountToUseStarImport));
            return this;
        }

        public Builder blankLine() {
            if (!this.blocks.isEmpty() && this.blocks.get(this.blocks.size() - 1) instanceof Block.BlankLines) {
                ((Block.BlankLines)this.blocks.get(this.blocks.size() - 1)).count++;
            } else {
                this.blocks.add(new Block.BlankLines());
            }
            return this;
        }

        public Builder importPackage(String packageWildcard, boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(false, packageWildcard, withSubpackages, this.classCountToUseStarImport, this.nameCountToUseStarImport));
            return this;
        }

        public Builder importPackage(String packageWildcard) {
            return this.importPackage(packageWildcard, true);
        }

        public Builder staticImportPackage(String packageWildcard, boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(true, packageWildcard, withSubpackages, this.classCountToUseStarImport, this.nameCountToUseStarImport));
            return this;
        }

        public Builder staticImportPackage(String packageWildcard) {
            return this.staticImportPackage(packageWildcard, true);
        }

        public Builder classCountToUseStarImport(int classCountToUseStarImport) {
            this.classCountToUseStarImport = classCountToUseStarImport;
            return this;
        }

        public Builder nameCountToUseStarImport(int nameCountToUseStarImport) {
            this.nameCountToUseStarImport = nameCountToUseStarImport;
            return this;
        }

        public ImportLayoutStyle build() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.AllOthers)) continue;
                ((Block.AllOthers)block).setPackageImports(this.blocks.stream().filter(b -> b.getClass().equals(Block.ImportPackage.class)).map(Block.ImportPackage.class::cast).collect(Collectors.toList()));
            }
            return new ImportLayoutStyle(this.classCountToUseStarImport, this.nameCountToUseStarImport, this.blocks);
        }
    }
}

