/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

public class UnwrapParentheses<P>
extends JavaVisitor<P> {
    private final J.Parentheses<?> scope;

    public UnwrapParentheses(J.Parentheses<?> scope) {
        this.scope = scope;
        this.setCursoringOn();
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        return this.scope.isScope(parens) && UnwrapParentheses.isUnwrappable(this.getCursor()) ? parens.getTree().withPrefix(parens.getPrefix()) : super.visitParentheses(parens, p);
    }

    public static boolean isUnwrappable(Cursor parensScope) {
        if (!(parensScope.getValue() instanceof J.Parentheses)) {
            return false;
        }
        J parent = (J)parensScope.dropParentUntil(J.class::isInstance).getValue();
        if (parent instanceof J.If || parent instanceof J.Switch || parent instanceof J.Synchronized || parent instanceof J.Try.Catch || parent instanceof J.TypeCast || parent instanceof J.WhileLoop) {
            return false;
        }
        if (parent instanceof J.DoWhileLoop) {
            return parensScope.getValue() != ((J.DoWhileLoop)parent).getWhileCondition();
        }
        return true;
    }
}

