/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;

public class OrderImports
extends Recipe {
    private boolean removeUnused = true;

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new OrderImportsVisitor();
    }

    public boolean isRemoveUnused() {
        return this.removeUnused;
    }

    public void setRemoveUnused(boolean removeUnused) {
        this.removeUnused = removeUnused;
    }

    public String toString() {
        return "OrderImports(removeUnused=" + this.isRemoveUnused() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderImports)) {
            return false;
        }
        OrderImports other = (OrderImports)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isRemoveUnused() == other.isRemoveUnused();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderImports;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRemoveUnused() ? 79 : 97);
        return result;
    }

    @ConstructorProperties(value={"removeUnused"})
    public OrderImports(boolean removeUnused) {
        this.removeUnused = removeUnused;
    }

    public OrderImports() {
    }

    private class OrderImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private OrderImportsVisitor() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            List<JRightPadded<J.Import>> orderedImports = layoutStyle.orderImports(cu.getImports());
            if (orderedImports.size() != cu.getImports().size()) {
                cu = cu.withImports(orderedImports);
            }
            for (int i = 0; i < orderedImports.size(); ++i) {
                if (orderedImports.get(i) == cu.getImports().get(i)) continue;
                cu = cu.withImports(orderedImports);
            }
            if (OrderImports.this.removeUnused) {
                this.doAfterVisit(new RemoveUnusedImports());
            }
            return cu;
        }
    }
}

