/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.format.SpacesProcessor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.J;

public class Spaces
extends Recipe {
    public Spaces() {
        this.processor = () -> new SpacesFromCompilationUnitStyle();
    }

    private static class SpacesFromCompilationUnitStyle
    extends JavaIsoProcessor<ExecutionContext> {
        private SpacesFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            SpacesStyle style = (SpacesStyle)cu.getStyle(SpacesStyle.class);
            if (style == null) {
                style = IntelliJ.spaces();
            }
            this.doAfterVisit(new SpacesProcessor(style, null));
            return super.visitCompilationUnit(cu, executionContext);
        }
    }
}

