/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;

public class ReorderMethodArguments
extends Recipe {
    private MethodMatcher methodMatcher;
    private String[] order;
    private String[] originalOrder = new String[0];

    public ReorderMethodArguments() {
        this.processor = () -> new ReorderMethodArgumentsProcessor(this.methodMatcher, this.order, this.originalOrder);
    }

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setOrder(String ... order) {
        this.order = order;
    }

    public void setOriginalOrder(String ... originalOrder) {
        this.originalOrder = originalOrder;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"order", (Object)this.order));
    }

    private static class ReorderMethodArgumentsProcessor
    extends JavaIsoProcessor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final String[] order;
        private final String[] originalOrder;

        private ReorderMethodArgumentsProcessor(MethodMatcher methodMatcher, String[] order, String[] originalOrder) {
            this.methodMatcher = methodMatcher;
            this.order = order;
            this.originalOrder = originalOrder;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((J.MethodInvocation)m) && ((J.MethodInvocation)m).getType() != null) {
                void var13_16;
                List<String> paramNames;
                List<String> list = paramNames = this.originalOrder.length == 0 ? ((J.MethodInvocation)m).getType().getParamNames() : Arrays.asList(this.originalOrder);
                if (paramNames == null) {
                    throw new IllegalStateException("There is no source attachment for method " + ((J.MethodInvocation)m).getType().getDeclaringType().getFullyQualifiedName() + "." + ((J.MethodInvocation)m).getSimpleName() + "(..). Provide a reference for original parameter names by calling setOriginalParamNames(..)");
                }
                List<JRightPadded<Expression>> originalArgs = ((J.MethodInvocation)m).getArgs().getElem();
                int resolvedParamCount = ((J.MethodInvocation)m).getType().getResolvedSignature() == null ? originalArgs.size() : ((J.MethodInvocation)m).getType().getResolvedSignature().getParamTypes().size();
                int i = 0;
                ArrayList reordered = new ArrayList(originalArgs.size());
                ArrayList<Space> formattings = new ArrayList<Space>(originalArgs.size());
                ArrayList<Space> rightFormattings = new ArrayList<Space>(originalArgs.size());
                String[] stringArray = this.order;
                int n = stringArray.length;
                boolean bl = false;
                while (var13_16 < n) {
                    String name = stringArray[var13_16];
                    int fromPos = paramNames.indexOf(name);
                    if (originalArgs.size() > resolvedParamCount && fromPos == resolvedParamCount - 1) {
                        List<JRightPadded<Expression>> varargs = originalArgs.subList(fromPos, originalArgs.size());
                        reordered.addAll(varargs);
                        for (JRightPadded<Expression> exp : originalArgs.subList(i, i++ + varargs.size())) {
                            formattings.add(exp.getElem().getPrefix());
                            rightFormattings.add(exp.getAfter());
                        }
                    } else if (fromPos >= 0 && originalArgs.size() > fromPos) {
                        reordered.add(originalArgs.get(fromPos));
                        formattings.add(originalArgs.get(i).getElem().getPrefix());
                        rightFormattings.add(originalArgs.get(i++).getAfter());
                    }
                    ++var13_16;
                }
                boolean changed = false;
                i = 0;
                for (JRightPadded jRightPadded : reordered) {
                    int index = i;
                    reordered.set(i, jRightPadded.map(e -> (Expression)e.withPrefix((Space)formattings.get(index))).withAfter((Space)rightFormattings.get(index)));
                    if (reordered.get(i) != originalArgs.get(i)) {
                        changed = true;
                    }
                    ++i;
                }
                if (changed) {
                    m = ((J.MethodInvocation)m).withArgs(((J.MethodInvocation)m).getArgs().withElem(reordered));
                }
            }
            return m;
        }
    }
}

