/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.LinkedHashSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoProcessor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class ChangeMethodTargetToStatic
extends Recipe {
    private String method;
    private String targetType;

    public ChangeMethodTargetToStatic() {
        this.processor = () -> new ChangeMethodTargetToStaticProcessor(new MethodMatcher(this.method), this.targetType);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.method).and(Validated.required((String)"target.type", (Object)this.targetType));
    }

    private static class ChangeMethodTargetToStaticProcessor
    extends JavaIsoProcessor<ExecutionContext> {
        private final MethodMatcher methodMatcher;
        private final String targetType;

        public ChangeMethodTargetToStaticProcessor(MethodMatcher methodMatcher, String targetType) {
            this.methodMatcher = methodMatcher;
            this.targetType = targetType;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches(method)) {
                JavaType.Class classType = JavaType.Class.build(this.targetType);
                m = method.withSelect(new JRightPadded<Expression>(J.Ident.build(Tree.randomId(), method.getSelect() == null ? Space.EMPTY : method.getSelect().getElem().getPrefix(), Markers.EMPTY, classType.getClassName(), classType), Space.EMPTY));
                this.maybeAddImport(this.targetType);
                JavaType.Method transformedType = null;
                if (method.getType() != null) {
                    this.maybeRemoveImport(method.getType().getDeclaringType());
                    transformedType = method.getType().withDeclaringType(classType);
                    if (!method.getType().hasFlags(Flag.Static)) {
                        LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(method.getType().getFlags());
                        flags.add(Flag.Static);
                        transformedType = transformedType.withFlags(flags);
                    }
                }
                m = ((J.MethodInvocation)m).withType(transformedType);
            }
            return m;
        }
    }
}

