/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import org.openrewrite.java.internal.PrintJava;
import org.openrewrite.java.tree.J;

public class ClassDeclToString {
    private static final PrintJava CLASS_DECL_PRINTER = new PrintJava(){

        @Override
        public String visitClassDecl(J.ClassDecl classDecl) {
            String modifiers = this.visitModifiers(classDecl.getModifiers()).trim();
            String kind = "";
            if (classDecl.getKind() instanceof J.ClassDecl.Kind.Class) {
                kind = "class ";
            } else if (classDecl.getKind() instanceof J.ClassDecl.Kind.Enum) {
                kind = "enum ";
            } else if (classDecl.getKind() instanceof J.ClassDecl.Kind.Interface) {
                kind = "interface ";
            } else if (classDecl.getKind() instanceof J.ClassDecl.Kind.Annotation) {
                kind = "@interface ";
            }
            return (modifiers.isEmpty() ? "" : modifiers + " ") + kind + classDecl.getName().printTrimmed() + (classDecl.getTypeParameters() == null ? "" : classDecl.getTypeParameters().printTrimmed() + " ") + (classDecl.getExtends() == null ? "" : "extends" + (String)this.visit(classDecl.getExtends().getFrom()) + " ") + (classDecl.getImplements() == null ? "" : (classDecl.getKind() instanceof J.ClassDecl.Kind.Interface ? "extends " : "implements ") + this.visit(classDecl.getImplements().getFrom(), ","));
        }
    };

    public static String toString(J.ClassDecl clazz) {
        return (String)CLASS_DECL_PRINTER.visit(clazz);
    }
}

