/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import java.util.Objects;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.java.AbstractJavaSourceVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;

@Incubating(since="6.0.0")
public class SemanticallyEqual
extends AbstractJavaSourceVisitor<Boolean> {
    private final Tree tree;

    public SemanticallyEqual(Tree tree) {
        this.tree = tree;
    }

    public Boolean defaultTo(Tree t) {
        return true;
    }

    public Boolean reduce(Boolean r1, Boolean r2) {
        return r1 != false && r2 != false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean visitAnnotation(J.Annotation otherAnnotation) {
        boolean areArgsEqual;
        if (!(this.tree instanceof J.Annotation)) return false;
        J.Annotation annotation = (J.Annotation)this.tree;
        if (annotation.getArgs() != null && otherAnnotation.getArgs() != null) {
            if (annotation.getArgs().getArgs() == null || otherAnnotation.getArgs().getArgs() == null || annotation.getArgs().getArgs().size() != otherAnnotation.getArgs().getArgs().size()) return false;
            List<Expression> theseArgs = annotation.getArgs().getArgs();
            List<Expression> thoseArgs = otherAnnotation.getArgs().getArgs();
            areArgsEqual = true;
            for (int i = 0; i < theseArgs.size(); ++i) {
                if (((Boolean)new SemanticallyEqual(theseArgs.get(i)).visit(thoseArgs.get(i))).booleanValue()) continue;
                areArgsEqual = false;
            }
            return areArgsEqual && new SemanticallyEqual(annotation.getAnnotationType()).visitTypeName(otherAnnotation.getAnnotationType()) != false;
        } else {
            if (annotation.getArgs() != null || otherAnnotation.getArgs() != null) return false;
            areArgsEqual = true;
        }
        return areArgsEqual && new SemanticallyEqual(annotation.getAnnotationType()).visitTypeName(otherAnnotation.getAnnotationType()) != false;
    }

    @Override
    public Boolean visitIdentifier(J.Ident otherIdent) {
        if (this.tree instanceof J.Ident) {
            J.Ident ident = (J.Ident)this.tree;
            return Objects.equals(ident.getType(), otherIdent.getType()) && ident.getSimpleName().equals(otherIdent.getSimpleName());
        }
        return false;
    }

    @Override
    public Boolean visitFieldAccess(J.FieldAccess otherFieldAccess) {
        J.FieldAccess fieldAccess;
        if (this.tree instanceof J.FieldAccess && (fieldAccess = (J.FieldAccess)this.tree).getSimpleName().equals("class")) {
            if (!otherFieldAccess.getSimpleName().equals("class")) {
                return false;
            }
            return SemanticallyEqual.typeEquals(fieldAccess.getType(), otherFieldAccess.getType()) && SemanticallyEqual.typeEquals(fieldAccess.getTarget().getType(), otherFieldAccess.getTarget().getType());
        }
        return false;
    }

    @Override
    public Boolean visitAssign(J.Assign otherAssign) {
        if (this.tree instanceof J.Assign) {
            J.Assign assign = (J.Assign)this.tree;
            return Objects.equals(assign.getType(), otherAssign.getType()) && (Boolean)new SemanticallyEqual(assign.getVariable()).visit(otherAssign.getVariable()) != false && (Boolean)new SemanticallyEqual(assign.getAssignment()).visit(otherAssign.getAssignment()) != false;
        }
        return false;
    }

    @Override
    public Boolean visitLiteral(J.Literal otherLiteral) {
        if (this.tree instanceof J.Literal) {
            J.Literal literal = (J.Literal)this.tree;
            return Objects.equals(literal.getValue(), otherLiteral.getValue());
        }
        return false;
    }

    @Override
    public Boolean visitTypeName(NameTree name) {
        if (this.tree instanceof J.Ident) {
            if (!(name instanceof J.Ident)) {
                return false;
            }
            return SemanticallyEqual.identEquals((J.Ident)this.tree, (J.Ident)name);
        }
        return (Boolean)super.visitTypeName(name);
    }

    private static boolean identEquals(J.Ident thisIdent, J.Ident otherIdent) {
        return Objects.equals(thisIdent.getSimpleName(), otherIdent.getSimpleName()) && SemanticallyEqual.typeEquals(thisIdent.getType(), otherIdent.getType());
    }

    private static boolean typeEquals(JavaType thisType, JavaType otherType) {
        if (thisType == null) {
            return otherType == null;
        }
        if (thisType instanceof JavaType.FullyQualified) {
            if (!(otherType instanceof JavaType.FullyQualified)) {
                return false;
            }
            return ((JavaType.FullyQualified)thisType).getFullyQualifiedName().equals(((JavaType.FullyQualified)otherType).getFullyQualifiedName());
        }
        return thisType.deepEquals(otherType);
    }
}

