/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Tree;
import org.openrewrite.java.AbstractJavaSourceVisitor;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveUnusedImports
extends JavaIsoRefactorVisitor {
    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(ImportLayoutStyle.getDefaultImportLayoutStyle());
        Map methodsByTypeName = (Map)new StaticMethodsByType().visit(cu);
        Map typesByPackage = (Map)new TypesByPackage().visit(cu);
        boolean changed = false;
        ArrayList<J.Import> importsWithUsage = new ArrayList<J.Import>();
        for (J.Import anImport : cu.getImports()) {
            if (anImport.isStatic()) {
                Set methods = (Set)methodsByTypeName.get(anImport.getTypeName());
                if (methods == null) {
                    changed = true;
                    continue;
                }
                if ("*".equals(anImport.getQualid().getSimpleName())) {
                    if (methods.size() < layoutStyle.getNameCountToUseStarImport()) {
                        methods.stream().sorted().forEach(method -> importsWithUsage.add((J.Import)anImport.withQualid(anImport.getQualid().withName(anImport.getQualid().getName().withName((String)method))).withPrefix("\n")));
                        changed = true;
                        continue;
                    }
                    importsWithUsage.add(anImport);
                    continue;
                }
                importsWithUsage.add(anImport);
                continue;
            }
            Set types = (Set)typesByPackage.get(anImport.getPackageName());
            if (types == null) {
                changed = true;
                continue;
            }
            if ("*".equals(anImport.getQualid().getSimpleName())) {
                if (types.size() < layoutStyle.getClassCountToUseStarImport()) {
                    types.stream().map(JavaType.FullyQualified::getClassName).sorted().forEach(typeClassName -> importsWithUsage.add((J.Import)anImport.withQualid(anImport.getQualid().withName(anImport.getQualid().getName().withName((String)typeClassName))).withPrefix("\n")));
                    changed = true;
                    continue;
                }
                importsWithUsage.add(anImport);
                continue;
            }
            importsWithUsage.add(anImport);
        }
        return changed ? cu.withImports(importsWithUsage) : cu;
    }

    static class StaticMethodsByType
    extends AbstractJavaSourceVisitor<Map<String, Set<String>>> {
        StaticMethodsByType() {
        }

        public Map<String, Set<String>> reduce(Map<String, Set<String>> r1, Map<String, Set<String>> r2) {
            if (r1.isEmpty()) {
                return r2;
            }
            for (Map.Entry<String, Set<String>> r2Entry : r2.entrySet()) {
                r1.compute(r2Entry.getKey(), (pkg, types) -> Stream.concat(types == null ? Stream.empty() : types.stream(), ((Set)r2Entry.getValue()).stream()).collect(Collectors.toSet()));
            }
            return r1;
        }

        public Map<String, Set<String>> defaultTo(Tree t) {
            return new HashMap<String, Set<String>>();
        }

        @Override
        public Map<String, Set<String>> visitMethodInvocation(J.MethodInvocation method) {
            JavaType.Method type;
            Map<String, Set<String>> m = (Map<String, Set<String>>)super.visitMethodInvocation(method);
            if (method.getSelect() == null && (type = method.getType()) != null && type.hasFlags(Flag.Static)) {
                HashMap<String, Set<String>> m2 = new HashMap<String, Set<String>>();
                m2.put(type.getDeclaringType().getFullyQualifiedName(), Collections.singleton(type.getName()));
                m = this.reduce(m, m2);
            }
            return m;
        }
    }

    static class TypesByPackage
    extends AbstractJavaSourceVisitor<Map<String, Set<JavaType.Class>>> {
        TypesByPackage() {
            this.setCursoringOn();
        }

        public Map<String, Set<JavaType.Class>> reduce(Map<String, Set<JavaType.Class>> r1, Map<String, Set<JavaType.Class>> r2) {
            if (r1.isEmpty()) {
                return r2;
            }
            for (Map.Entry<String, Set<JavaType.Class>> r2Entry : r2.entrySet()) {
                r1.compute(r2Entry.getKey(), (pkg, types) -> Stream.concat(types == null ? Stream.empty() : types.stream(), ((Set)r2Entry.getValue()).stream()).collect(Collectors.toSet()));
            }
            return r1;
        }

        public Map<String, Set<JavaType.Class>> defaultTo(Tree t) {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Set<JavaType.Class>> visitTypeName(NameTree name) {
            JavaType.Class clazz;
            if (this.getCursor().firstEnclosing(J.Import.class) == null && (clazz = TypeUtils.asClass(name.getType())) != null) {
                HashMap<String, Set<JavaType.Class>> typeByPackage = new HashMap<String, Set<JavaType.Class>>();
                typeByPackage.put(clazz.getPackageName(), Collections.singleton(clazz));
                return typeByPackage;
            }
            return (Map)super.visitTypeName(name);
        }
    }
}

