/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AbstractJavaSourceVisitor;
import org.openrewrite.java.FillTypeAttributions;
import org.openrewrite.java.JavaFormatter;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.ShiftFormatRightVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class TreeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TreeBuilder.class);
    private static final Pattern whitespacePrefixPattern = Pattern.compile("^\\s*");
    private static final Pattern whitespaceSuffixPattern = Pattern.compile("\\s*[^\\s]+(\\s*)");
    private final JavaParser parser;

    public TreeBuilder(JavaParser parser) {
        this.parser = parser;
    }

    public static <T extends TypeTree & Expression> T buildName(String fullyQualifiedName) {
        return TreeBuilder.buildName(fullyQualifiedName, Tree.randomId());
    }

    public static <T extends TypeTree & Expression> T buildName(String fullyQualifiedName, UUID id) {
        String[] parts = fullyQualifiedName.split("\\.");
        String fullName = "";
        Expression expr = null;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == 0) {
                fullName = part;
                expr = J.Ident.build(Tree.randomId(), part, null, Collections.emptyList(), Formatting.EMPTY, Markers.EMPTY);
                continue;
            }
            fullName = fullName + "." + part;
            Matcher whitespacePrefix = whitespacePrefixPattern.matcher(part);
            Formatting identFmt = whitespacePrefix.matches() ? Formatting.format((String)whitespacePrefix.group(0)) : Formatting.EMPTY;
            Matcher whitespaceSuffix = whitespaceSuffixPattern.matcher(part);
            whitespaceSuffix.matches();
            Formatting partFmt = i == parts.length - 1 ? Formatting.EMPTY : Formatting.format((String)"", (String)whitespaceSuffix.group(1));
            expr = new J.FieldAccess(i == parts.length - 1 ? id : Tree.randomId(), expr, J.Ident.build(Tree.randomId(), part.trim(), null, Collections.emptyList(), identFmt, Markers.EMPTY), Character.isUpperCase(part.charAt(0)) || i == parts.length - 1 ? JavaType.Class.build(fullName) : null, Collections.emptyList(), partFmt, Markers.EMPTY);
        }
        return (T)expr;
    }

    public J buildDeclaration(J.ClassDecl insertionScope, String snippet, JavaType ... types) {
        String scopeVariables = insertionScope.getFields().stream().flatMap(field -> field.getVars().stream().map(v -> TreeBuilder.variableDefinitionSource(field, v))).collect(Collectors.joining(";\n  ", "  // variables visible in the insertion scope\n  ", ";\n")) + "\n";
        if (insertionScope.getFields().isEmpty()) {
            scopeVariables = "";
        }
        JavaType.Class[] imports = (JavaType.Class[])Arrays.stream(types).filter(Objects::nonNull).filter(it -> it instanceof JavaType.Class).map(JavaType.Class.class::cast).toArray(JavaType.Class[]::new);
        String source = Arrays.stream(imports).map(i -> "import " + i.getFullyQualifiedName() + ";").collect(Collectors.joining("\n", "", "\n\n")) + "class CodeSnippet {\n" + scopeVariables + StringUtils.trimIndent((String)snippet) + "\n}";
        if (logger.isDebugEnabled()) {
            logger.debug("Building code snippet using synthetic class:");
            logger.debug(source);
        }
        J.CompilationUnit cu = this.parser.parse(source).get(0);
        List<J> statements = cu.getClasses().get(0).getBody().getStatements();
        return (J)new FillTypeAttributions(imports).visit(statements.get(statements.size() - 1));
    }

    public J.ClassDecl buildInnerClassDeclaration(J.ClassDecl insertionScope, String classDeclarationSnippet, JavaType ... types) {
        J.ClassDecl cd = (J.ClassDecl)this.buildDeclaration(insertionScope, classDeclarationSnippet, types);
        JavaType.Class clazz = cd.getType();
        if (insertionScope.getType() != null && clazz != null) {
            JavaType.Class newClazz = JavaType.Class.build(insertionScope.getType().getFullyQualifiedName() + "." + cd.getSimpleName());
            return cd.withType(newClazz);
        }
        return cd;
    }

    public J.VariableDecls buildFieldDeclaration(J.ClassDecl insertionScope, String fieldDeclarationSnippet, JavaType ... types) {
        return (J.VariableDecls)this.buildDeclaration(insertionScope, fieldDeclarationSnippet, types);
    }

    public J.MethodDecl buildMethodDeclaration(J.ClassDecl insertionScope, String methodDeclarationSnippet, JavaType ... types) {
        return (J.MethodDecl)this.buildDeclaration(insertionScope, methodDeclarationSnippet, types);
    }

    public <T extends J> List<T> buildSnippet(Cursor insertionScope, String snippet, JavaType ... imports) {
        List localScopeVariables;
        JavaType.Method method;
        StringBuilder source = new StringBuilder(512);
        ArrayList<JavaType> allImports = new ArrayList<JavaType>(Arrays.asList(imports));
        J.CompilationUnit compilationUnit = this.getCompilationUnit(insertionScope);
        List typesInScope = (List)new GetTypesInScope(insertionScope).visit(compilationUnit);
        ArrayList<JavaType.Method> localMethods = new ArrayList<JavaType.Method>();
        for (JavaType type : typesInScope) {
            if (type instanceof JavaType.Method) {
                method = (JavaType.Method)type;
                if (method.getDeclaringType() == null) continue;
                if (compilationUnit.getClasses().stream().map(J.ClassDecl::getType).filter(Objects::nonNull).anyMatch(t -> t.equals(method.getDeclaringType()))) {
                    localMethods.add(method);
                    continue;
                }
                allImports.add(method);
                continue;
            }
            if (!(type instanceof JavaType.FullyQualified)) continue;
            allImports.add(type);
        }
        for (JavaType importType : allImports) {
            if (importType == null) continue;
            if (importType instanceof JavaType.FullyQualified) {
                source.append("import ").append(((JavaType.FullyQualified)importType).getFullyQualifiedName()).append(";\n");
                continue;
            }
            if (!(importType instanceof JavaType.Method)) continue;
            method = (JavaType.Method)importType;
            source.append("import static ").append(method.getDeclaringType().getFullyQualifiedName()).append(".").append(method.getName()).append(";\n");
        }
        source.append("\nclass CodeSnippet {\n");
        if (!localMethods.isEmpty()) {
            source.append("\n// local methods in scope at insertion point\n").append(localMethods.stream().map(TreeBuilder::stubMethod).collect(Collectors.joining("\n", "\n", "\n")));
        }
        if (!(localScopeVariables = (List)new ListScopeVariables(insertionScope).visit(compilationUnit)).isEmpty()) {
            source.append("\n// variables visible in the insertion scope\n").append(((List)new ListScopeVariables(insertionScope).visit(compilationUnit)).stream().collect(Collectors.joining(";\n", "\n", ";\n")));
        }
        source.append("\n// begin snippet block\n{\n").append(StringUtils.trimIndent((String)snippet)).append("\n}\n// end snippet block\n}");
        String sourceString = source.toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Building code snippet using synthetic class:");
            logger.debug(sourceString);
        }
        J.CompilationUnit syntheticCompliationUnit = this.parser.parse(sourceString).get(0);
        List<J> statements = syntheticCompliationUnit.getClasses().get(0).getBody().getStatements();
        J.Block block = (J.Block)statements.get(statements.size() - 1);
        JavaFormatter formatter = new JavaFormatter(syntheticCompliationUnit);
        return block.getStatements().stream().map(stat -> {
            ShiftFormatRightVisitor shiftRight = new ShiftFormatRightVisitor((Tree)stat, JavaFormatter.enclosingIndent(insertionScope.getTree()) + formatter.findIndent(JavaFormatter.enclosingIndent(insertionScope.getTree()), new Tree[]{stat}).getEnclosingIndent(), formatter.isIndentedWithSpaces());
            return (J)shiftRight.visit((Tree)stat);
        }).collect(Collectors.toList());
    }

    @NonNull
    private J.CompilationUnit getCompilationUnit(Cursor cursor) {
        J.CompilationUnit cu = (J.CompilationUnit)cursor.firstEnclosing(J.CompilationUnit.class);
        if (cu == null) {
            throw new IllegalStateException("The AST does does not have a compilation unit.");
        }
        return cu;
    }

    private static String stubMethod(JavaType.Method method) {
        JavaType returnType;
        StringBuilder methodStub = new StringBuilder(128);
        if (!method.getFlags().isEmpty()) {
            methodStub.append(method.getFlags().stream().map(Flag::getKeyword).collect(Collectors.joining(" "))).append(" ");
        }
        JavaType javaType = returnType = method.getResolvedSignature() == null ? null : method.getResolvedSignature().getReturnType();
        if (returnType instanceof JavaType.FullyQualified || returnType instanceof JavaType.Array || returnType instanceof JavaType.Primitive) {
            methodStub.append(TreeBuilder.getTypeDeclaration(returnType)).append(" ");
        } else {
            methodStub.append("void ");
        }
        methodStub.append(method.getName()).append("(");
        int argIndex = 0;
        for (JavaType parameter : method.getResolvedSignature().getParamTypes()) {
            if (argIndex > 0) {
                methodStub.append(", ");
            }
            methodStub.append(TreeBuilder.getTypeDeclaration(parameter));
            methodStub.append(" arg").append(argIndex);
            ++argIndex;
        }
        methodStub.append(") {\n");
        if (returnType instanceof JavaType.FullyQualified || returnType instanceof JavaType.Array) {
            methodStub.append("  return null;\n");
        } else if (returnType instanceof JavaType.Primitive) {
            methodStub.append("  return ").append(((JavaType.Primitive)returnType).getDefaultValue()).append(";\n");
        }
        methodStub.append("}\n");
        return methodStub.toString();
    }

    private static String variableDefinitionSource(J.VariableDecls variableDecls, J.VariableDecls.NamedVar variable) {
        String typeDeclaration = variableDecls.getTypeExpr() != null ? variableDecls.getTypeExpr().printTrimmed() : TreeBuilder.getTypeDeclaration(variable.getType());
        return "static " + typeDeclaration + variableDecls.getDimensionsBeforeName().stream().map(d -> "[]").reduce("", (r1, r2) -> r1 + r2) + " " + variable.getSimpleName();
    }

    private static String getTypeDeclaration(@Nullable JavaType type) {
        if (type instanceof JavaType.Class) {
            JavaType.Class clazz = (JavaType.Class)type;
            StringBuilder typeDeclaration = new StringBuilder(50);
            typeDeclaration.append(clazz.getFullyQualifiedName());
            if (clazz.getTypeParameters() != null && !clazz.getTypeParameters().isEmpty()) {
                typeDeclaration.append("<").append(clazz.getTypeParameters().stream().map(TreeBuilder::getTypeDeclaration).collect(Collectors.joining(","))).append(">");
            }
            return typeDeclaration.toString();
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Array) {
            JavaType elementType = ((JavaType.Array)type).getElemType();
            if (elementType instanceof JavaType.FullyQualified) {
                return ((JavaType.FullyQualified)elementType).getFullyQualifiedName() + "[]";
            }
            if (elementType instanceof JavaType.Primitive) {
                return ((JavaType.Primitive)elementType).getKeyword() + "[]";
            }
            throw new IllegalArgumentException("Cannot resolve the array type declaration.");
        }
        if (type instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type).getKeyword();
        }
        throw new IllegalArgumentException("Cannot resolve type declaration.");
    }

    private static class ListScopeVariables
    extends AbstractJavaSourceVisitor<List<String>> {
        @Nullable
        private final Cursor scope;

        private ListScopeVariables(@Nullable Cursor scope) {
            this.scope = scope;
            this.setCursoringOn();
        }

        public List<String> defaultTo(@Nullable Tree t) {
            return Collections.emptyList();
        }

        @Override
        public List<String> visitCompilationUnit(J.CompilationUnit cu) {
            return this.scope == null ? Collections.emptyList() : (List)super.visitCompilationUnit(cu);
        }

        @Override
        public List<String> visitVariable(J.VariableDecls.NamedVar variable) {
            if (this.isInSameNameScope(this.scope)) {
                return Collections.singletonList(TreeBuilder.variableDefinitionSource((J.VariableDecls)this.getCursor().getParentOrThrow().getTree(), variable));
            }
            return (List)super.visitVariable(variable);
        }
    }

    private static class GetTypesInScope
    extends AbstractJavaSourceVisitor<List<JavaType>> {
        @Nullable
        private final Cursor scope;

        private GetTypesInScope(@Nullable Cursor scope) {
            this.scope = scope;
            this.setCursoringOn();
        }

        public List<JavaType> defaultTo(@Nullable Tree t) {
            return Collections.emptyList();
        }

        @Override
        public List<JavaType> visitMethodInvocation(J.MethodInvocation method) {
            List methods = (List)super.visitMethodInvocation(method);
            if (this.isInSameNameScope(this.scope)) {
                if (method.getType() != null && method.getSelect() == null) {
                    methods.add(method.getType());
                } else if (method.getSelect() == null) {
                    logger.warn("There is an invocation to a method [" + method.getSimpleName() + "] within the original insertion scope that does not have type information.");
                }
            }
            return methods;
        }

        @Override
        public List<JavaType> visitNewClass(J.NewClass newClass) {
            List types = (List)super.visitNewClass(newClass);
            if (this.isInSameNameScope(this.scope) && newClass.getType() != null) {
                types.add(newClass.getType());
            }
            return types;
        }

        @Override
        public List<JavaType> visitVariable(J.VariableDecls.NamedVar variable) {
            List types = (List)super.visitVariable(variable);
            if (this.isInSameNameScope(this.scope) && variable.getType() != null) {
                types.add(variable.getType());
            }
            return types;
        }
    }
}

