/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class RemoveImport
extends JavaIsoRefactorVisitor {
    private String type;
    private JavaType.Class classType;
    private MethodMatcher methodMatcher;
    private J.Import namedImport;
    private J.Import starImport;
    private J.Import staticStarImport;
    private final Set<String> referencedTypes = new HashSet<String>();
    private final Set<J.Ident> referencedMethods = new HashSet<J.Ident>();
    private final Set<String> referencedFields = new HashSet<String>();
    private final Set<J.Import> staticNamedImports = Collections.newSetFromMap(new IdentityHashMap());

    public RemoveImport() {
        this.setCursoringOn();
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String)"type", (String)this.type);
    }

    public Validated validate() {
        return Validated.required((String)"type", (Object)this.type);
    }

    public void setType(String type) {
        this.type = type;
        this.methodMatcher = new MethodMatcher(type + " *(..)");
        this.classType = JavaType.Class.build(type);
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        this.namedImport = null;
        this.starImport = null;
        this.staticStarImport = null;
        this.referencedTypes.clear();
        this.referencedMethods.clear();
        this.referencedFields.clear();
        this.staticNamedImports.clear();
        J.CompilationUnit c = super.visitCompilationUnit(cu);
        return this.staticImportDeletions(this.classImportDeletions(c));
    }

    @Override
    public J.Import visitImport(J.Import impoort) {
        if (impoort.isStatic()) {
            if (impoort.getQualid().getTarget().printTrimmed().equals(this.type)) {
                if ("*".equals(impoort.getQualid().getSimpleName())) {
                    this.staticStarImport = impoort;
                } else {
                    this.staticNamedImports.add(impoort);
                }
            }
        } else if (impoort.getQualid().printTrimmed().equals(this.type)) {
            this.namedImport = impoort;
        } else if ("*".equals(impoort.getQualid().getSimpleName()) && this.type.startsWith(impoort.getQualid().getTarget().printTrimmed())) {
            this.starImport = impoort;
        }
        return super.visitImport(impoort);
    }

    @Override
    public NameTree visitTypeName(NameTree name) {
        JavaType.Class asClass = TypeUtils.asClass(name.getType());
        if (asClass != null && asClass.getPackageName().equals(this.classType.getPackageName())) {
            if (this.getCursor().getPathAsStream().noneMatch(J.Import.class::isInstance)) {
                this.referencedTypes.add(asClass.getFullyQualifiedName());
            }
        }
        return super.visitTypeName(name);
    }

    @Override
    public J.Ident visitIdentifier(J.Ident ident) {
        if (this.getCursor().getPathAsStream().noneMatch(J.Import.class::isInstance)) {
            this.referencedFields.add(ident.getSimpleName());
        }
        return super.visitIdentifier(ident);
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method) && method.getType() != null && method.getType().getDeclaringType().getFullyQualifiedName().equals(this.type)) {
            this.referencedMethods.add(method.getName());
        }
        return super.visitMethodInvocation(method);
    }

    private J.CompilationUnit classImportDeletions(J.CompilationUnit cu) {
        if (this.namedImport != null && this.referencedTypes.stream().noneMatch(t -> t.equals(this.type))) {
            return this.delete(cu, this.namedImport);
        }
        if (this.starImport != null && this.referencedTypes.isEmpty()) {
            return this.delete(cu, this.starImport);
        }
        if (this.starImport != null && this.referencedTypes.size() == 1) {
            return cu.withImports(cu.getImports().stream().map(i -> i == this.starImport ? new J.Import(Tree.randomId(), (J.FieldAccess)TreeBuilder.buildName(this.referencedTypes.iterator().next()).withFormatting(Formatting.format((String)" ")), false, i.getComments(), i.getFormatting(), Markers.EMPTY) : i).collect(Collectors.toList()));
        }
        return cu;
    }

    private J.CompilationUnit staticImportDeletions(J.CompilationUnit cu) {
        if (this.staticStarImport != null) {
            JavaType.Class qualidType = TypeUtils.asClass(this.staticStarImport.getQualid().getTarget().getType());
            if (this.referencedMethods.isEmpty() && this.noFieldReferences(qualidType, null)) {
                cu = this.delete(cu, this.staticStarImport);
            }
        }
        for (J.Import staticImport : this.staticNamedImports) {
            String methodOrField = staticImport.getQualid().getSimpleName();
            JavaType.Class qualidType = TypeUtils.asClass(staticImport.getQualid().getTarget().getType());
            if (!this.referencedMethods.stream().noneMatch(m -> m.getSimpleName().equals(methodOrField)) || !this.noFieldReferences(qualidType, methodOrField)) continue;
            cu = this.delete(cu, staticImport);
        }
        return cu;
    }

    private boolean noFieldReferences(@Nullable JavaType.Class qualidType, @Nullable String fieldName) {
        return qualidType == null || (fieldName != null ? !this.referencedFields.contains(fieldName) : this.referencedFields.stream().noneMatch(f -> qualidType.getMembers().stream().anyMatch(v -> f.equals(v.getName())) || qualidType.getVisibleSupertypeMembers().stream().anyMatch(v -> f.equals(v.getName()))));
    }

    private J.CompilationUnit delete(J.CompilationUnit cu, J.Import impoort) {
        return cu.withImports(cu.getImports().stream().filter(i -> i != impoort).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveImport)) {
            return false;
        }
        RemoveImport other = (RemoveImport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

