/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TreeBuilder;

public class GenerateGetter
extends JavaRefactorVisitor {

    public static class Scoped
    extends JavaRefactorVisitor {
        private final JavaType.Class clazz;
        private final String fieldName;

        public Scoped(JavaType.Class clazz, String fieldName) {
            this.setCursoringOn();
            this.fieldName = fieldName;
            this.clazz = clazz;
        }

        @Override
        public J visitClassDecl(J.ClassDecl classDecl) {
            boolean isMissingTargetField;
            J.ClassDecl cd = (J.ClassDecl)this.refactor(classDecl, x$0 -> super.visitClassDecl((J.ClassDecl)x$0));
            JavaType.Class type = classDecl.getType();
            if (type == null || !this.clazz.getFullyQualifiedName().equals(type.getFullyQualifiedName())) {
                return cd;
            }
            J.VariableDecls field = cd.getFields().stream().filter(it -> it.getVars().get(0).getSimpleName().equals(this.fieldName)).findAny().orElse(null);
            if (field == null) {
                return cd;
            }
            assert (field.getTypeExpr() != null);
            String simpleFieldName = field.getVars().get(0).getSimpleName();
            MethodMatcher getterMatcher = new MethodMatcher(type.getFullyQualifiedName() + " get" + StringUtils.capitalize((String)simpleFieldName) + "()");
            boolean getterAlreadyExists = classDecl.getMethods().stream().anyMatch(it -> getterMatcher.matches((J.MethodDecl)it, classDecl));
            if (getterAlreadyExists) {
                return cd;
            }
            boolean bl = isMissingTargetField = !cd.getFields().stream().filter(arg_0 -> ((J.VariableDecls)field).isScope(arg_0)).findAny().isPresent();
            if (isMissingTargetField) {
                return cd;
            }
            J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
            assert (cu != null);
            Object jp = ((JavaParser.Builder)JavaParser.fromJavaVersion().styles(cu.getStyles())).build();
            J.VariableDecls.NamedVar fieldVar = field.getVars().get(0);
            String fieldName = fieldVar.getSimpleName();
            J.MethodDecl getMethod = TreeBuilder.buildMethodDeclaration(jp, classDecl, "public " + field.getTypeExpr().print().trim() + " get" + StringUtils.capitalize((String)fieldName) + "() {\n    return " + fieldName + ";\n}\n", new JavaType[]{field.getTypeAsClass()});
            this.andThen((RefactorVisitor)new AutoFormat(getMethod));
            J.Block<J> body = cd.getBody();
            ArrayList<J> statements = new ArrayList<J>(body.getStatements());
            statements.add(getMethod);
            cd = cd.withBody(body.withStatements(statements));
            return cd;
        }
    }
}

