/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.LinkedHashSet;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class ChangeMethodTargetToVariable
extends JavaRefactorVisitor {
    private MethodMatcher methodMatcher;
    private String variable;
    private JavaType.Class variableType;

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public void setVariableType(String variableType) {
        this.variableType = JavaType.Class.build(variableType);
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"variable", (Object)this.variable)).and(Validated.required((String)"variable.type", (Object)this.variableType.getFullyQualifiedName()));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method)) {
            this.andThen((RefactorVisitor)new Scoped(method, this.variable, this.variableType));
        }
        return super.visitMethodInvocation(method);
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        private final J.MethodInvocation scope;
        private final String variable;
        @Nullable
        private final JavaType.Class type;
        private OrderImports orderImports;

        public Scoped(J.MethodInvocation scope, J.VariableDecls.NamedVar namedVar) {
            this(scope, namedVar.getSimpleName(), TypeUtils.asClass(namedVar.getType()));
        }

        public Scoped(J.MethodInvocation scope, String variable, @Nullable JavaType.Class type) {
            this.scope = scope;
            this.variable = variable;
            this.type = type;
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String)"to", (String)this.variable);
        }

        @Override
        public J visitCompilationUnit(J.CompilationUnit cu) {
            this.orderImports = cu.getStyle(ImportLayoutStyle.class).map(ImportLayoutStyle::orderImports).orElse(OrderImports.DEFAULT);
            return super.visitCompilationUnit(cu);
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method) {
            if (this.scope.isScope(method)) {
                Expression select = method.getSelect();
                JavaType.Method methodType = null;
                if (method.getType() != null) {
                    LinkedHashSet<Flag> flags = new LinkedHashSet<Flag>(method.getType().getFlags());
                    flags.remove((Object)Flag.Static);
                    methodType = method.getType().withDeclaringType(this.type).withFlags(flags);
                }
                this.andThen((RefactorVisitor)this.orderImports);
                return method.withSelect(J.Ident.build(Tree.randomId(), this.variable, this.type, select == null ? Formatting.EMPTY : select.getFormatting())).withType(methodType);
            }
            return super.visitMethodInvocation(method);
        }
    }
}

