/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.RefactorMethodSignatureParser;
import org.openrewrite.java.internal.grammar.RefactorMethodSignatureParserBaseVisitor;

class FormalParameterVisitor
extends RefactorMethodSignatureParserBaseVisitor<String> {
    private final List<Argument> arguments = new ArrayList<Argument>();

    FormalParameterVisitor() {
    }

    public String visitTerminal(TerminalNode node) {
        if ("...".equals(node.getText())) {
            ((Argument.FormalType)this.arguments.get(this.arguments.size() - 1)).setVariableArgs(true);
        }
        return (String)super.visitTerminal(node);
    }

    @Override
    public String visitDotDot(RefactorMethodSignatureParser.DotDotContext ctx) {
        this.arguments.add(Argument.DOT_DOT);
        return (String)super.visitDotDot(ctx);
    }

    @Override
    public String visitFormalTypePattern(RefactorMethodSignatureParser.FormalTypePatternContext ctx) {
        this.arguments.add(new Argument.FormalType(ctx));
        return (String)super.visitFormalTypePattern(ctx);
    }

    @Override
    public String visitFormalParametersPattern(RefactorMethodSignatureParser.FormalParametersPatternContext ctx) {
        super.visitFormalParametersPattern(ctx);
        ArrayList<String> argumentPatterns = new ArrayList<String>();
        for (int i = 0; i < this.arguments.size(); ++i) {
            Argument argument = this.arguments.get(i);
            if (argument == Argument.DOT_DOT) {
                if (this.arguments.size() == 1) {
                    argumentPatterns.add("(" + argument.getRegex() + ")?");
                    continue;
                }
                if (i > 0) {
                    argumentPatterns.add("(," + argument.getRegex() + ")?");
                    continue;
                }
                argumentPatterns.add("(" + argument.getRegex() + ",)?");
                continue;
            }
            if (i > 0 && this.arguments.get(i - 1) != Argument.DOT_DOT) {
                argumentPatterns.add("," + argument.getRegex());
                continue;
            }
            argumentPatterns.add(argument.getRegex());
        }
        return String.join((CharSequence)"", argumentPatterns).replace("...", "\\[\\]");
    }

    private static abstract class Argument {
        private static final Argument DOT_DOT = new Argument(){

            @Override
            String getRegex() {
                return "([^,]+,)*([^,]+)";
            }
        };

        private Argument() {
        }

        abstract String getRegex();

        static class FormalType
        extends Argument {
            RefactorMethodSignatureParser.FormalTypePatternContext ctx;
            boolean variableArgs = false;

            public FormalType(RefactorMethodSignatureParser.FormalTypePatternContext ctx) {
                this.ctx = ctx;
            }

            @Override
            String getRegex() {
                String baseType = (String)new TypeVisitor().visitFormalTypePattern(this.ctx);
                return baseType + (this.variableArgs ? "\\[\\]" : "");
            }

            public void setVariableArgs(boolean variableArgs) {
                this.variableArgs = variableArgs;
            }
        }
    }
}

